/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.BackingStoreHashTableFromScan;
import org.apache.derby.impl.store.access.RAMAccessManager;
import org.apache.derby.impl.store.access.RAMTransactionContext;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class RAMTransaction
implements XATransactionController,
TransactionManager {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected Transaction rawtran;
    protected RAMAccessManager accessmanager;
    protected RAMTransactionContext context;
    protected RAMTransaction parent_tran;
    private Vector scanControllers;
    private Vector conglomerateControllers;
    private Vector sorts;
    private Vector sortControllers;
    protected Hashtable tempCongloms = null;
    private long nextTempConglomId = -1L;
    private boolean alterTableCallMade = false;
    private int transaction_lock_level;

    private final void init(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) {
        this.rawtran = transaction;
        this.parent_tran = rAMTransaction;
        this.accessmanager = rAMAccessManager;
        this.scanControllers = new Vector();
        this.conglomerateControllers = new Vector();
        this.sorts = null;
        this.sortControllers = null;
        this.tempCongloms = rAMTransaction != null ? rAMTransaction.tempCongloms : null;
    }

    protected void closeControllers(boolean bl) throws StandardException {
        Enumeration enumeration;
        Object object;
        int n;
        if (!this.scanControllers.isEmpty()) {
            n = this.scanControllers.size() - 1;
            while (n >= 0) {
                object = (ScanManager)this.scanControllers.elementAt(n);
                if (object.closeForEndTransaction(bl)) {
                    // empty if block
                }
                --n;
            }
            if (bl) {
                this.scanControllers.removeAllElements();
            }
        }
        if (!this.conglomerateControllers.isEmpty()) {
            n = this.conglomerateControllers.size() - 1;
            while (n >= 0) {
                object = (ConglomerateController)this.conglomerateControllers.elementAt(n);
                if (object.closeForEndTransaction(bl)) {
                    // empty if block
                }
                --n;
            }
            if (bl) {
                this.conglomerateControllers.removeAllElements();
            }
        }
        if (this.sortControllers != null && !this.sortControllers.isEmpty() && bl) {
            enumeration = this.sortControllers.elements();
            while (enumeration.hasMoreElements()) {
                SortController sortController = (SortController)enumeration.nextElement();
                sortController.close();
            }
            this.sortControllers.removeAllElements();
        }
        if (this.sorts != null && !this.sorts.isEmpty() && bl) {
            enumeration = this.sorts.elements();
            while (enumeration.hasMoreElements()) {
                Sort sort = (Sort)enumeration.nextElement();
                if (sort == null) continue;
                sort.drop(this);
            }
            this.sorts.removeAllElements();
        }
    }

    private LockingPolicy determine_locking_policy(int n, int n2) {
        LockingPolicy lockingPolicy = this.accessmanager.getSystemLockLevel() == 7 || n == 7 ? this.accessmanager.table_level_policy[n2] : this.accessmanager.record_level_policy[n2];
        return lockingPolicy;
    }

    private int determine_lock_level(int n) {
        int n2 = this.accessmanager.getSystemLockLevel() == 7 || n == 7 ? 7 : 6;
        return n2;
    }

    private Conglomerate findExistingConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = null;
        if (l < 0L) {
            if (this.tempCongloms != null) {
                conglomerate = (Conglomerate)this.tempCongloms.get(new Long(l));
            }
        } else {
            conglomerate = this.accessmanager.conglomCacheFind(this, l);
        }
        if (conglomerate == null) {
            throw StandardException.newException("XSAI2.S", new Long(l));
        }
        return conglomerate;
    }

    private Conglomerate findConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = null;
        if (l >= 0L) {
            conglomerate = this.accessmanager.conglomCacheFind(this, l);
        } else if (this.tempCongloms != null) {
            conglomerate = (Conglomerate)this.tempCongloms.get(new Long(l));
        }
        return conglomerate;
    }

    void setContext(RAMTransactionContext rAMTransactionContext) {
        this.context = rAMTransactionContext;
    }

    public long[] getCacheStats(String string) {
        return this.getRawStoreXact().getCacheStats(string);
    }

    private ConglomerateController openConglomerate(Conglomerate conglomerate, boolean bl, int n, int n2, int n3, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.conglomerateControllers.addElement(conglomerateController);
        return conglomerateController;
    }

    private ScanController openScan(Conglomerate conglomerate, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.scanControllers.addElement(scanManager);
        return scanManager;
    }

    public void resetCacheStats(String string) {
        this.getRawStoreXact().resetCacheStats(string);
    }

    protected void invalidateConglomerateCache() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
    }

    public void addColumnToConglomerate(long l, int n, Storable storable) throws StandardException {
        boolean bl = l < 0L;
        Conglomerate conglomerate = this.findConglomerate(l);
        if (conglomerate == null) {
            throw StandardException.newException("XSAM2.S", new Long(l));
        }
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, false, 4, 7, this.accessmanager.table_level_policy[5], null, null);
        conglomerate.addColumn(this, n, storable);
        if (bl) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(new Long(l));
            }
            this.tempCongloms.put(new Long(l), conglomerate);
        } else {
            this.alterTableCallMade = true;
            this.accessmanager.conglomCacheUpdateEntry(l, conglomerate);
        }
        conglomerateController.close();
    }

    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(long l) throws StandardException {
        return this.findExistingConglomerate(l).getStaticCompiledConglomInfo(this, l);
    }

    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo(long l) throws StandardException {
        return this.findExistingConglomerate(l).getDynamicCompiledConglomInfo(l);
    }

    private final int countCreatedSorts() {
        int n = 0;
        if (this.sorts != null) {
            int n2 = 0;
            while (n2 < this.sorts.size()) {
                if (this.sorts.elementAt(n2) != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public int countOpens(int n) throws StandardException {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = this.conglomerateControllers.size();
                break;
            }
            case 2: {
                n2 = this.scanControllers.size();
                break;
            }
            case 3: {
                n2 = this.countCreatedSorts();
                break;
            }
            case 4: {
                n2 = this.sortControllers != null ? this.sortControllers.size() : 0;
                break;
            }
            case 5: {
                n2 = this.conglomerateControllers.size() + this.scanControllers.size() + (this.sortControllers != null ? this.sortControllers.size() : 0) + this.countCreatedSorts();
                break;
            }
        }
        return n2;
    }

    public long createConglomerate(String string, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, Properties properties, int n) throws StandardException {
        long l;
        long l2;
        int n2;
        MethodFactory methodFactory = this.accessmanager.findMethodFactoryByImpl(string);
        if (methodFactory == null || !(methodFactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", string);
        }
        ConglomerateFactory conglomerateFactory = (ConglomerateFactory)methodFactory;
        if ((n & 1) == 1) {
            n2 = -1;
            l2 = 0L;
        } else {
            n2 = 0;
            l2 = this.accessmanager.getNextConglomId(conglomerateFactory.getConglomerateFactoryId());
        }
        Conglomerate conglomerate = conglomerateFactory.createConglomerate(this, n2, l2, dataValueDescriptorArray, columnOrderingArray, properties, n);
        if ((n & 1) == 1) {
            l = this.nextTempConglomId--;
            if (this.tempCongloms == null) {
                this.tempCongloms = new Hashtable();
            }
            this.tempCongloms.put(new Long(l), conglomerate);
        } else {
            l = conglomerate.getContainerid();
            this.accessmanager.conglomCacheAddEntry(l, conglomerate);
        }
        return l;
    }

    public long createAndLoadConglomerate(String string, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, Properties properties, int n, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        return this.recreateAndLoadConglomerate(string, true, dataValueDescriptorArray, columnOrderingArray, properties, n, 0L, rowLocationRetRowSource, lArray);
    }

    public long recreateAndLoadConglomerate(String string, boolean bl, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, Properties properties, int n, long l, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        long l2 = this.createConglomerate(string, dataValueDescriptorArray, columnOrderingArray, properties, n);
        long l3 = this.loadConglomerate(l2, true, rowLocationRetRowSource);
        if (lArray != null) {
            lArray[0] = l3;
        }
        if (!bl && l3 == 0L) {
            this.dropConglomerate(l2);
            l2 = l;
        }
        return l2;
    }

    public String debugOpened() throws StandardException {
        String string = null;
        return string;
    }

    public boolean conglomerateExists(long l) throws StandardException {
        Conglomerate conglomerate = this.findConglomerate(l);
        return conglomerate != null;
    }

    public void dropConglomerate(long l) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        conglomerate.drop(this);
        if (l < 0L) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(new Long(l));
            }
        } else {
            this.accessmanager.conglomCacheRemoveEntry(l);
        }
    }

    public boolean fetchMaxOnBtree(long l, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        return conglomerate.fetchMaxOnBTree(this, this.rawtran, l, n, n2, this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray);
    }

    public Properties getUserCreateConglomPropList() {
        Properties properties = ConglomerateUtil.createUserRawStorePropertySet(null);
        return properties;
    }

    public boolean isIdle() {
        return this.rawtran.isIdle();
    }

    public boolean isGlobal() {
        return this.rawtran.getGlobalId() != null;
    }

    public boolean isPristine() {
        return this.rawtran.isPristine();
    }

    public Object createXATransactionFromLocalTransaction(int n, byte[] byArray, byte[] byArray2) throws StandardException {
        this.getRawStoreXact().createXATransactionFromLocalTransaction(n, byArray, byArray2);
        return this;
    }

    public long loadConglomerate(long l, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        return conglomerate.load(this, bl, rowLocationRetRowSource);
    }

    public void loadConglomerate(long l, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        this.loadConglomerate(l, false, rowLocationRetRowSource);
    }

    public void logAndDo(Loggable loggable) throws StandardException {
        this.rawtran.logAndDo(loggable);
    }

    public ConglomerateController openCompiledConglomerate(boolean bl, int n, int n2, int n3, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openConglomerate((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n, n2, n3, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    public ConglomerateController openConglomerate(long l, boolean bl, int n, int n2, int n3) throws StandardException {
        return this.openConglomerate(this.findExistingConglomerate(l), bl, n, n2, n3, null, null);
    }

    public long findConglomid(long l) throws StandardException {
        return l;
    }

    public long findContainerid(long l) throws StandardException {
        return l;
    }

    public BackingStoreHashtable createBackingStoreHashtableFromScan(long l, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, long l2, int[] nArray, boolean bl, long l3, long l4, int n6, float f, boolean bl2, boolean bl3) throws StandardException {
        return new BackingStoreHashTableFromScan(this, l, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, l2, nArray, bl, l3, l4, n6, f, bl2, bl3);
    }

    public GroupFetchScanController openGroupFetchScan(long l, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n, this.determine_lock_level(n2), this.determine_locking_policy(n2, n3), n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, null, null);
        this.scanControllers.addElement(scanManager);
        return scanManager;
    }

    public ScanController openScan(long l, boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5) throws StandardException {
        return this.openScan(this.findExistingConglomerate(l), bl, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, null, null);
    }

    public ScanController openCompiledScan(boolean bl, int n, int n2, int n3, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n4, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n5, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openScan((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n, n2, n3, formatableBitSet, dataValueDescriptorArray, n4, qualifierArray, dataValueDescriptorArray2, n5, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    public StoreCostController openStoreCost(long l) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l);
        StoreCostController storeCostController = conglomerate.openStoreCost(this, this.rawtran);
        return storeCostController;
    }

    public long createSort(Properties properties, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl, long l, int n) throws StandardException {
        MethodFactory methodFactory;
        String string = null;
        if (properties != null) {
            string = properties.getProperty("implType");
        }
        if (string == null) {
            string = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        int n2 = 0;
        Sort sort = sortFactory.createSort(this, n2, properties, dataValueDescriptorArray, columnOrderingArray, sortObserver, bl, l, n);
        if (this.sorts == null) {
            this.sorts = new Vector();
        }
        long l2 = this.sorts.size();
        this.sorts.addElement(sort);
        return l2;
    }

    public void dropSort(long l) throws StandardException {
        Sort sort = (Sort)this.sorts.elementAt((int)l);
        if (sort != null) {
            sort.drop(this);
            this.sorts.setElementAt(null, (int)l);
        }
    }

    public Serializable getProperty(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperty(this, string);
    }

    public Serializable getPropertyDefault(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getPropertyDefault(this, string);
    }

    public void setProperty(String string, Serializable serializable, boolean bl) throws StandardException {
        this.accessmanager.getTransactionalProperties().setProperty(this, string, serializable, bl);
    }

    public void setPropertyDefault(String string, Serializable serializable) throws StandardException {
        this.accessmanager.getTransactionalProperties().setPropertyDefault(this, string, serializable);
    }

    public boolean propertyDefaultIsVisible(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().propertyDefaultIsVisible(this, string);
    }

    public Properties getProperties() throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperties(this);
    }

    public SortController openSort(long l) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.elementAt((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        SortController sortController = sort.open(this);
        if (this.sortControllers == null) {
            this.sortControllers = new Vector();
        }
        this.sortControllers.addElement(sortController);
        return sortController;
    }

    public SortCostController openSortCostController(Properties properties) throws StandardException {
        MethodFactory methodFactory;
        String string = null;
        if (string == null) {
            string = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        return sortFactory.openSortCostController();
    }

    public ScanController openSortScan(long l, boolean bl) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.elementAt((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        ScanController scanController = sort.openSortScan(this, bl);
        this.scanControllers.addElement(scanController);
        return scanController;
    }

    public RowLocationRetRowSource openSortRowSource(long l) throws StandardException {
        Sort sort;
        if (this.sorts == null || l >= (long)this.sorts.size() || (sort = (Sort)this.sorts.elementAt((int)l)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(l));
        }
        ScanControllerRowSource scanControllerRowSource = sort.openSortRowSource(this);
        this.scanControllers.addElement(scanControllerRowSource);
        return scanControllerRowSource;
    }

    public void commit() throws StandardException {
        this.closeControllers(false);
        this.rawtran.commit();
        this.alterTableCallMade = false;
    }

    public DatabaseInstant commitNoSync(int n) throws StandardException {
        this.closeControllers(false);
        return this.rawtran.commitNoSync(n);
    }

    public void abort() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
        this.closeControllers(true);
        this.rawtran.abort();
        if (this.parent_tran != null) {
            this.parent_tran.abort();
        }
    }

    public ContextManager getContextManager() {
        return this.context.getContextManager();
    }

    public int setSavePoint(String string, Object object) throws StandardException {
        return this.rawtran.setSavePoint(string, object);
    }

    public int releaseSavePoint(String string, Object object) throws StandardException {
        return this.rawtran.releaseSavePoint(string, object);
    }

    public int rollbackToSavePoint(String string, boolean bl, Object object) throws StandardException {
        if (bl) {
            this.closeControllers(true);
        }
        return this.rawtran.rollbackToSavePoint(string, object);
    }

    public void destroy() {
        try {
            this.closeControllers(true);
            if (this.rawtran != null) {
                this.rawtran.destroy();
                this.rawtran = null;
            }
            if (this.context != null) {
                this.context.popMe();
            }
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
        catch (StandardException standardException) {
            this.rawtran = null;
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
    }

    public boolean anyoneBlocked() {
        return this.rawtran.anyoneBlocked();
    }

    public void xa_commit(boolean bl) throws StandardException {
        this.rawtran.xa_commit(bl);
    }

    public int xa_prepare() throws StandardException {
        return this.rawtran.xa_prepare();
    }

    public void xa_rollback() throws StandardException {
        this.rawtran.xa_rollback();
    }

    public void addPostCommitWork(Serviceable serviceable) {
        this.rawtran.addPostCommitWork(serviceable);
    }

    public void closeMe(ConglomerateController conglomerateController) {
        this.conglomerateControllers.removeElement(conglomerateController);
    }

    public void closeMe(SortController sortController) {
        this.sortControllers.removeElement(sortController);
    }

    public void closeMe(ScanManager scanManager) {
        this.scanControllers.removeElement(scanManager);
    }

    public AccessFactory getAccessManager() {
        return this.accessmanager;
    }

    public TransactionManager getInternalTransaction() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = this.accessmanager.getRawStore().startInternalTransaction(contextManager);
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, null);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMInternalContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    public TransactionController startNestedUserTransaction(boolean bl) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = bl ? this.accessmanager.getRawStore().startNestedReadOnlyUserTransaction(this.getLockObject(), contextManager, "nestedReadOnlyUserTransaction") : this.accessmanager.getRawStore().startNestedUpdateUserTransaction(contextManager, "nestedUpdateUserTransaction");
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, this);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMChildContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    public Transaction getRawStoreXact() {
        return this.rawtran;
    }

    public void saveScanPositions(Conglomerate conglomerate, Page page) throws StandardException {
        Enumeration enumeration = this.scanControllers.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            ScanManager scanManager = (ScanManager)e;
            scanManager.savePosition(conglomerate, page);
        }
    }

    public FileResource getFileHandler() {
        return this.rawtran.getFileHandler();
    }

    public Object getLockObject() {
        return this.rawtran.getCompatibilitySpace();
    }

    public String getTransactionIdString() {
        return this.rawtran.toString();
    }

    public String getActiveStateTxIdString() {
        return this.rawtran.getActiveStateTxIdString();
    }

    public String toString() {
        String string = null;
        return string;
    }

    protected RAMTransaction(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) throws StandardException {
        this.init(rAMAccessManager, transaction, rAMTransaction);
    }

    RAMTransaction(RAMAccessManager rAMAccessManager, RAMTransaction rAMTransaction, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        this.init(rAMAccessManager, rAMTransaction.getRawStoreXact(), null);
        this.context = rAMTransaction.context;
        this.context.setTransaction(this);
        this.rawtran.createXATransactionFromLocalTransaction(n, byArray, byArray2);
        rAMTransaction.rawtran = null;
    }

    RAMTransaction() {
    }
}

