/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.GenericConstantAction;

class SetSchemaConstantAction
extends GenericConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private final String schemaName;
    private final int type;

    public String toString() {
        return "SET SCHEMA " + (this.type == 1 ? "USER" : (this.type == 2 && this.schemaName == null ? "?" : this.schemaName));
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = this.schemaName;
        if (this.type == 2) {
            object = activation.getParameterValueSet();
            DataValueDescriptor dataValueDescriptor = object.getParameter(0);
            string = dataValueDescriptor.getString();
            if (string == null || string.length() > 128) {
                throw StandardException.newException("42815.S.713", "CURRENT SCHEMA");
            }
        } else if (this.type == 1) {
            string = languageConnectionContext.getAuthorizationId();
        }
        object = dataDictionary.getSchemaDescriptor(string, null, true);
        languageConnectionContext.setDefaultSchema((SchemaDescriptor)object);
    }

    SetSchemaConstantAction(String string, int n) {
        this.schemaName = string;
        this.type = n;
    }
}

