/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.UpdateResultSet;

public class DeleteCascadeResultSet
extends DeleteResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2002, 2004.";
    public ResultSet[] dependentResultSets;
    private int noDependents = 0;
    private CursorResultSet parentSource;
    private FKInfo parentFKInfo;
    private long fkIndexConglomNumber;
    private String resultSetId;
    private boolean mainNodeForTable = true;
    private boolean affectedRows = false;
    private int tempRowHolderId;

    public void open() throws StandardException {
        try {
            this.setup();
            if (this.isMultipleDeletePathsExist()) {
                this.setRowHoldersTypeToUniqueStream();
                while (this.collectAffectedRows(false)) {
                }
            } else {
                this.collectAffectedRows(false);
            }
            if (!this.affectedRows) {
                this.activation.addWarning(StandardException.newWarning("02000"));
            }
            this.runFkChecker(true);
            Hashtable hashtable = new Hashtable();
            this.mergeRowHolders(hashtable);
            this.fireBeforeTriggers(hashtable);
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rowChangerFinish();
            this.fireAfterTriggers();
            this.cleanUp();
        }
        finally {
            Object var2_2 = null;
            this.activation.clearParentResultSets();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        super.setup();
        this.activation.setParentResultSet(this.rowHolder, this.resultSetId);
        Vector vector = this.activation.getParentResultSet(this.resultSetId);
        this.tempRowHolderId = vector.size() - 1;
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).setup();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).setup();
            }
            ++n;
        }
    }

    boolean collectAffectedRows(boolean bl) throws StandardException {
        if (super.collectAffectedRows()) {
            this.affectedRows = true;
            bl = true;
        }
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                if (((UpdateResultSet)this.dependentResultSets[n]).collectAffectedRows()) {
                    bl = true;
                }
            } else if (((DeleteCascadeResultSet)this.dependentResultSets[n]).collectAffectedRows(bl)) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    void fireBeforeTriggers(Hashtable hashtable) throws StandardException {
        if (!this.mainNodeForTable && !hashtable.containsKey(this.resultSetId)) {
            this.mainNodeForTable = true;
            hashtable.put(this.resultSetId, this.resultSetId);
        }
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).fireBeforeTriggers();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).fireBeforeTriggers(hashtable);
            }
            ++n;
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireBeforeTriggers();
        }
    }

    void fireAfterTriggers() throws StandardException {
        int n = 0;
        while (n < this.noDependents && this.affectedRows) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).fireAfterTriggers();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).fireAfterTriggers();
            }
            ++n;
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireAfterTriggers();
        }
    }

    void deleteDeferredRows() throws StandardException {
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).updateDeferredRows();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).deleteDeferredRows();
            }
            ++n;
        }
        if (this.mainNodeForTable) {
            super.deleteDeferredRows();
        }
    }

    void runFkChecker(boolean bl) throws StandardException {
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).runChecker(bl);
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).runFkChecker(bl);
            }
            ++n;
        }
        if (this.mainNodeForTable) {
            super.runFkChecker(bl);
        }
    }

    public void cleanUp() throws StandardException {
        super.cleanUp();
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).cleanUp();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).cleanUp();
            }
            ++n;
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    private void rowChangerFinish() throws StandardException {
        this.rc.finish();
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[n]).rowChangerFinish();
            } else {
                ((DeleteCascadeResultSet)this.dependentResultSets[n]).rowChangerFinish();
            }
            ++n;
        }
    }

    private void mergeRowHolders(Hashtable hashtable) throws StandardException {
        if (hashtable.containsKey(this.resultSetId) || this.rowCount == 0) {
            this.mainNodeForTable = false;
        } else {
            this.mergeResultSets();
            this.mainNodeForTable = true;
            hashtable.put(this.resultSetId, this.resultSetId);
        }
        int n = 0;
        while (n < this.noDependents) {
            if (this.dependentResultSets[n] instanceof UpdateResultSet) {
                return;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[n]).mergeRowHolders(hashtable);
            ++n;
        }
    }

    private void mergeResultSets() throws StandardException {
        Vector vector = this.activation.getParentResultSet(this.resultSetId);
        int n = vector.size();
        if (n > 1) {
            ExecRow execRow = null;
            int n2 = 0;
            while (n2 < n) {
                if (n2 == this.tempRowHolderId) {
                    ++n2;
                    continue;
                }
                TemporaryRowHolder temporaryRowHolder = (TemporaryRowHolder)vector.elementAt(n2);
                CursorResultSet cursorResultSet = temporaryRowHolder.getResultSet();
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.rowHolder.insert(execRow);
                }
                cursorResultSet.close();
                ++n2;
            }
        }
    }

    public void finish() throws StandardException {
        super.finish();
        this.activation.clearParentResultSets();
    }

    private boolean isMultipleDeletePathsExist() {
        Hashtable hashtable = this.activation.getParentResultSets();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = this.activation.getParentResultSet(string);
            int n = vector.size();
            if (n <= 1) continue;
            return true;
        }
        return false;
    }

    private void setRowHoldersTypeToUniqueStream() {
        Hashtable hashtable = this.activation.getParentResultSets();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = this.activation.getParentResultSet(string);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                TemporaryRowHolder temporaryRowHolder = (TemporaryRowHolder)vector.elementAt(n2);
                temporaryRowHolder.setRowHolderTypeToUniqueStream();
                ++n2;
            }
        }
    }

    public DeleteCascadeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, ResultSet[] resultSetArray, String string) throws StandardException {
        super(noPutResultSet, n == -1 ? activation.getConstantAction() : (ConstantAction)activation.getPreparedStatement().getSavedObject(n), activation);
        if (n == -1) {
            ConstantAction constantAction = activation.getConstantAction();
        } else {
            ConstantAction constantAction = (ConstantAction)activation.getPreparedStatement().getSavedObject(n);
            this.resultDescription = this.constants.resultDescription;
        }
        this.cascadeDelete = true;
        this.resultSetId = string;
        if (resultSetArray != null) {
            this.noDependents = resultSetArray.length;
            this.dependentResultSets = resultSetArray;
        }
    }
}

