/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SumAggregator;

public final class AvgAggregator
extends SumAggregator {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private long count;
    private int scale;

    protected void accumulate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.count == 0L) {
            String string = dataValueDescriptor.getTypeName();
            if (string.equals("TINYINT") || string.equals("SMALLINT") || string.equals("INTEGER") || string.equals("BIGINT")) {
                this.scale = 0;
            } else if (string.equals("REAL") || string.equals("DOUBLE")) {
                this.scale = 31;
            } else {
                this.scale = dataValueDescriptor.getBigDecimal().scale();
                if (this.scale < 4) {
                    this.scale = 4;
                }
            }
        }
        try {
            super.accumulate(dataValueDescriptor);
            ++this.count;
            return;
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("22003")) {
                throw standardException;
            }
            String string = this.value.getTypeName();
            this.value = string.equals("INTEGER") ? new SQLLongint(this.value.getLong()) : (string.equals("TINYINT") || string.equals("SMALLINT") ? new SQLInteger(this.value.getInt()) : (string.equals("REAL") ? new SQLDouble(this.value.getDouble()) : new SQLDecimal(this.value.getBigDecimal())));
            this.accumulate(dataValueDescriptor);
            return;
        }
    }

    public void merge(ExecAggregator execAggregator) throws StandardException {
        AvgAggregator avgAggregator = (AvgAggregator)execAggregator;
        if (this.count == 0L) {
            this.count = avgAggregator.count;
            this.value = avgAggregator.value;
            this.scale = avgAggregator.scale;
            return;
        }
        if (avgAggregator.value != null) {
            this.count += avgAggregator.count - 1L;
            this.accumulate(avgAggregator.value);
        }
    }

    public Object getResult() {
        if (this.count == 0L) {
            return null;
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = this.value.getBigDecimal().divide(BigDecimal.valueOf(this.count), this.scale, 1);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return bigDecimal;
    }

    public ExecAggregator newAggregator() {
        return new AvgAggregator();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.count);
        objectOutput.writeInt(this.scale);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.count = objectInput.readLong();
        this.scale = objectInput.readInt();
    }

    public int getTypeFormatId() {
        return 149;
    }
}

