/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.impl.services.stream.BasicGetLogHeader;
import org.apache.derby.impl.services.stream.BasicHeaderPrintWriter;

public class SingleStream
implements InfoStreams,
ModuleControl,
PrivilegedAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private HeaderPrintWriter theStream;
    private String PBfileName;
    private PrintWriterGetHeader PBheader;

    public void boot(boolean bl, Properties properties) {
        this.theStream = this.makeStream();
    }

    public void stop() {
        ((BasicHeaderPrintWriter)this.theStream).complete();
    }

    public HeaderPrintWriter stream() {
        return this.theStream;
    }

    private HeaderPrintWriter makeStream() {
        StringBuffer stringBuffer = new StringBuffer("derby.stream.error.");
        int n = stringBuffer.length();
        PrintWriterGetHeader printWriterGetHeader = this.makeHeader();
        stringBuffer.setLength(n);
        HeaderPrintWriter headerPrintWriter = this.makeHPW(stringBuffer, printWriterGetHeader);
        if (headerPrintWriter == null) {
            headerPrintWriter = this.createDefaultStream(printWriterGetHeader);
        }
        return headerPrintWriter;
    }

    private PrintWriterGetHeader makeHeader() {
        return new BasicGetLogHeader(true, true, null);
    }

    private HeaderPrintWriter makeHPW(StringBuffer stringBuffer, PrintWriterGetHeader printWriterGetHeader) {
        int n = stringBuffer.length();
        stringBuffer.append("file");
        String string = PropertyUtil.getSystemProperty(stringBuffer.toString());
        if (string != null) {
            return this.makeFileHPW(string, printWriterGetHeader);
        }
        stringBuffer.setLength(n);
        stringBuffer.append("method");
        string = PropertyUtil.getSystemProperty(stringBuffer.toString());
        if (string != null) {
            return this.makeMethodHPW(string, printWriterGetHeader);
        }
        stringBuffer.setLength(n);
        stringBuffer.append("field");
        string = PropertyUtil.getSystemProperty(stringBuffer.toString());
        if (string != null) {
            return this.makeFieldHPW(string, printWriterGetHeader);
        }
        return null;
    }

    private HeaderPrintWriter PBmakeFileHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        Object object;
        boolean bl = PropertyUtil.getSystemBoolean("derby.infolog.append");
        File file = new File(string);
        if (!file.isAbsolute() && (object = Monitor.getMonitor().getEnvironment()) instanceof File) {
            file = new File((File)object, string);
        }
        try {
            object = file.exists() && bl ? new FileOutputStream(file.getPath(), true) : new FileOutputStream(file);
        }
        catch (IOException iOException) {
            return this.useDefaultStream(printWriterGetHeader, iOException);
        }
        catch (SecurityException securityException) {
            return this.useDefaultStream(printWriterGetHeader, securityException);
        }
        return new BasicHeaderPrintWriter((OutputStream)new BufferedOutputStream((OutputStream)object), printWriterGetHeader, true);
    }

    private HeaderPrintWriter makeMethodHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        Throwable throwable;
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string2);
            try {
                Method method = clazz.getMethod(string3, new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(method.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(method, method.invoke(null, new Object[0]), printWriterGetHeader);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throwable = illegalArgumentException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getTargetException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throwable = noSuchMethodException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, throwable);
    }

    private HeaderPrintWriter makeFieldHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        Exception exception;
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        try {
            Class<?> clazz = Class.forName(string2);
            try {
                Field field = clazz.getField(string3);
                if (!Modifier.isStatic(field.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(field.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(field, field.get(null), printWriterGetHeader);
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, exception);
    }

    private HeaderPrintWriter makeValueHPW(Member member, Object object, PrintWriterGetHeader printWriterGetHeader) {
        if (object instanceof OutputStream) {
            return new BasicHeaderPrintWriter((OutputStream)object, printWriterGetHeader, false);
        }
        if (object instanceof Writer) {
            return new BasicHeaderPrintWriter((Writer)object, printWriterGetHeader, false);
        }
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        if (object == null) {
            headerPrintWriter.printlnWithHeader(member.toString() + "=null");
        } else {
            headerPrintWriter.printlnWithHeader(member.toString() + " instanceof " + object.getClass().getName());
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter createDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return this.makeFileHPW("derby.log", printWriterGetHeader);
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return new BasicHeaderPrintWriter((OutputStream)System.err, printWriterGetHeader, false);
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader, Throwable throwable) {
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        headerPrintWriter.printlnWithHeader(throwable.toString());
        return headerPrintWriter;
    }

    private HeaderPrintWriter makeFileHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        this.PBfileName = string;
        this.PBheader = printWriterGetHeader;
        return (HeaderPrintWriter)AccessController.doPrivileged(this);
    }

    public final Object run() {
        return this.PBmakeFileHPW(this.PBfileName, this.PBheader);
    }
}

