/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;

public final class FileMonitor
extends BaseMonitor
implements PrivilegedExceptionAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private File home;
    private ProductVersionHolder engineVersion;
    private int action;
    private String key3;
    private Runnable task;
    private int intValue;
    private URL propertyFileURL;

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File file = FileUtil.newFile(this.home, "derby.properties");
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public Object getEnvironment() {
        return this.home;
    }

    private boolean PBinitialize(boolean bl) {
        String string;
        if (!bl) {
            try {
                this.daemonGroup = new ThreadGroup("derby.daemons");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/DBMS.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
        try {
            string = System.getProperty("derby.system.home");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string != null) {
            this.home = new File(string);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + string + " does not represent a directory");
                    return false;
                }
            } else if (!bl) {
                try {
                    this.home.mkdirs();
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public final synchronized boolean initialize(boolean bl) {
        this.action = bl ? 0 : 1;
        try {
            Object t = AccessController.doPrivileged(this);
            return (Boolean)t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    protected final synchronized InputStream loadModuleDefinitions(URL uRL) throws IOException {
        this.action = 2;
        this.propertyFileURL = uRL;
        try {
            try {
                InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
                Object var3_3 = null;
                this.propertyFileURL = null;
                return inputStream;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw (RuntimeException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.propertyFileURL = null;
            throw throwable;
        }
    }

    public final synchronized String getJVMProperty(String string) {
        if (!string.startsWith("derby.")) {
            return this.PBgetJVMProperty(string);
        }
        try {
            this.action = 3;
            this.key3 = string;
            String string2 = (String)AccessController.doPrivileged(this);
            this.key3 = null;
            return string2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public final synchronized Thread getDaemonThread(Runnable runnable, String string, boolean bl) {
        this.action = 4;
        this.key3 = string;
        this.task = runnable;
        this.intValue = bl ? 1 : 0;
        try {
            Thread thread = (Thread)AccessController.doPrivileged(this);
            this.key3 = null;
            runnable = null;
            return thread;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    public final synchronized void setThreadPriority(int n) {
        this.action = 5;
        this.intValue = n;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (RuntimeException)privilegedActionException.getException();
        }
    }

    protected final synchronized InputStream applicationPropertiesStream() throws IOException {
        this.action = 6;
        try {
            return (InputStream)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public final Object run() throws IOException {
        switch (this.action) {
            case 0: 
            case 1: {
                return new Boolean(this.PBinitialize(this.action == 0));
            }
            case 2: {
                return super.loadModuleDefinitions(this.propertyFileURL);
            }
            case 3: {
                return this.PBgetJVMProperty(this.key3);
            }
            case 4: {
                return super.getDaemonThread(this.task, this.key3, this.intValue != 0);
            }
            case 5: {
                super.setThreadPriority(this.intValue);
                return null;
            }
            case 6: {
                return this.PBapplicationPropertiesStream();
            }
        }
        return null;
    }

    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintStream printStream) {
        this.runWithState(properties, printStream);
    }
}

