/**
 * Creates SQL functions that perform regular expression operations.
 */

package examples.tutorial.derby;
import java.util.*;
import org.apache.regexp.*;

public class DerbyRegex
{
   /**
    * Entrypoint for SQL function that performs a regular expression match by
    * calling org.apache.regexp.match().
    *
    * @param src The string to be searched.
    * @param pattern The regular expression to use for the search.
    * @return int 1 if the match is found, otherwise 0.
    */
   public static int tutMatchRegexp(String src, String pattern)
   {
      int retval=0;
      RE r = new RE(pattern);
      if (r.match(src))
         retval=1;
      return retval;
   }

   /**
    * Entrypoint for SQL function that performs a regular expression replace by
    * calling org.apache.regexp.subst().
    *
    * @param src The string to be searched.
    * @param pattern The regular expression to use for the search.
    * @param change The replacement text.
    * @return The modified string.
    */
   public static String tutReplaceRegexp(String src,String pattern,String change)
   {
      RE r = new RE(pattern);
      String s1 = r.subst(src, change, RE.REPLACE_BACKREFERENCES);
      return s1;
   }

}
