/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolverUtils;
import org.apache.commons.math.distribution.ContinuousDistribution;

public abstract class AbstractContinuousDistribution
implements ContinuousDistribution,
Serializable {
    static final long serialVersionUID = -38038050983108802L;

    protected AbstractContinuousDistribution() {
    }

    public double cumulativeProbability(double x0, double x1) throws MathException {
        if (x0 > x1) {
            throw new IllegalArgumentException("lower endpoint must be less than or equal to upper endpoint");
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public double inverseCumulativeProbability(final double p) throws MathException {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0.0 and 1.0, inclusive.");
        }
        UnivariateRealFunction rootFindingFunction = new UnivariateRealFunction(){

            public double value(double x) throws FunctionEvaluationException {
                try {
                    return AbstractContinuousDistribution.this.cumulativeProbability(x) - p;
                }
                catch (MathException ex) {
                    throw new FunctionEvaluationException(x, "Error computing cdf", ex);
                }
            }
        };
        double lowerBound = this.getDomainLowerBound(p);
        double upperBound = this.getDomainUpperBound(p);
        double[] bracket = null;
        try {
            bracket = UnivariateRealSolverUtils.bracket(rootFindingFunction, this.getInitialDomain(p), lowerBound, upperBound);
        }
        catch (ConvergenceException ex) {
            if (Math.abs(rootFindingFunction.value(lowerBound)) < 1.0E-6) {
                return lowerBound;
            }
            if (Math.abs(rootFindingFunction.value(upperBound)) < 1.0E-6) {
                return upperBound;
            }
            throw new MathException(ex);
        }
        double root = UnivariateRealSolverUtils.solve(rootFindingFunction, bracket[0], bracket[1]);
        return root;
    }

    protected abstract double getInitialDomain(double var1);

    protected abstract double getDomainLowerBound(double var1);

    protected abstract double getDomainUpperBound(double var1);

    public abstract /* synthetic */ double cumulativeProbability(double var1) throws MathException;
}

