/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.univariate.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.univariate.moment.SecondMoment;

public class ThirdMoment
extends SecondMoment
implements Serializable {
    static final long serialVersionUID = -7818711964045118679L;
    protected double m3 = Double.NaN;
    protected double nDevSq = Double.NaN;

    public void increment(double d) {
        if (this.n < 1L) {
            this.m1 = 0.0;
            this.m2 = 0.0;
            this.m3 = 0.0;
        }
        double prevM2 = this.m2;
        super.increment(d);
        this.nDevSq = this.nDev * this.nDev;
        double n0 = this.n;
        this.m3 = this.m3 - 3.0 * this.nDev * prevM2 + (n0 - 1.0) * (n0 - 2.0) * this.nDevSq * this.dev;
    }

    public double getResult() {
        return this.m3;
    }

    public void clear() {
        super.clear();
        this.m3 = Double.NaN;
        this.nDevSq = Double.NaN;
    }
}

