/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.univariate;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.math.stat.univariate.DescriptiveStatisticsImpl;
import org.apache.commons.math.stat.univariate.StatisticalSummary;
import org.apache.commons.math.stat.univariate.UnivariateStatistic;
import org.apache.commons.math.stat.univariate.moment.GeometricMean;
import org.apache.commons.math.stat.univariate.moment.Kurtosis;
import org.apache.commons.math.stat.univariate.moment.Mean;
import org.apache.commons.math.stat.univariate.moment.Skewness;
import org.apache.commons.math.stat.univariate.moment.Variance;
import org.apache.commons.math.stat.univariate.rank.Max;
import org.apache.commons.math.stat.univariate.rank.Min;
import org.apache.commons.math.stat.univariate.rank.Percentile;
import org.apache.commons.math.stat.univariate.summary.Sum;
import org.apache.commons.math.stat.univariate.summary.SumOfSquares;

public abstract class DescriptiveStatistics
implements StatisticalSummary,
Serializable {
    static final long serialVersionUID = 5188298269533339922L;
    public static final int INFINITE_WINDOW = -1;
    static /* synthetic */ Class class$org$apache$commons$math$stat$univariate$DescriptiveStatistics;

    public static DescriptiveStatistics newInstance(Class cls) throws InstantiationException, IllegalAccessException {
        return (DescriptiveStatistics)cls.newInstance();
    }

    public static DescriptiveStatistics newInstance() {
        DescriptiveStatistics factory = null;
        try {
            DiscoverClass dc = new DiscoverClass();
            factory = (DescriptiveStatistics)dc.newInstance(class$org$apache$commons$math$stat$univariate$DescriptiveStatistics == null ? (class$org$apache$commons$math$stat$univariate$DescriptiveStatistics = DescriptiveStatistics.class$("org.apache.commons.math.stat.univariate.DescriptiveStatistics")) : class$org$apache$commons$math$stat$univariate$DescriptiveStatistics, "org.apache.commons.math.stat.univariate.DescriptiveStatisticsImpl");
        }
        catch (Throwable t) {
            return new DescriptiveStatisticsImpl();
        }
        return factory;
    }

    public abstract void addValue(double var1);

    public double getMean() {
        return this.apply(new Mean());
    }

    public double getGeometricMean() {
        return this.apply(new GeometricMean());
    }

    public double getVariance() {
        return this.apply(new Variance());
    }

    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getSkewness() {
        return this.apply(new Skewness());
    }

    public double getKurtosis() {
        return this.apply(new Kurtosis());
    }

    public double getMax() {
        return this.apply(new Max());
    }

    public double getMin() {
        return this.apply(new Min());
    }

    public abstract long getN();

    public double getSum() {
        return this.apply(new Sum());
    }

    public double getSumsq() {
        return this.apply(new SumOfSquares());
    }

    public abstract void clear();

    public abstract int getWindowSize();

    public abstract void setWindowSize(int var1);

    public abstract double[] getValues();

    public double[] getSortedValues() {
        double[] sort = this.getValues();
        Arrays.sort(sort);
        return sort;
    }

    public abstract double getElement(int var1);

    public double getPercentile(double p) {
        return this.apply(new Percentile(p));
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("DescriptiveStatistics:\n");
        outBuffer.append("n: " + this.getN() + "\n");
        outBuffer.append("min: " + this.getMin() + "\n");
        outBuffer.append("max: " + this.getMax() + "\n");
        outBuffer.append("mean: " + this.getMean() + "\n");
        outBuffer.append("std dev: " + this.getStandardDeviation() + "\n");
        outBuffer.append("median: " + this.getPercentile(50.0) + "\n");
        outBuffer.append("skewness: " + this.getSkewness() + "\n");
        outBuffer.append("kurtosis: " + this.getKurtosis() + "\n");
        return outBuffer.toString();
    }

    public abstract double apply(UnivariateStatistic var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

