/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.math.BigDecimal;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;

public interface BigMatrix {
    public BigMatrix copy();

    public BigMatrix add(BigMatrix var1) throws IllegalArgumentException;

    public BigMatrix subtract(BigMatrix var1) throws IllegalArgumentException;

    public BigMatrix scalarAdd(BigDecimal var1);

    public BigMatrix scalarMultiply(BigDecimal var1);

    public BigMatrix multiply(BigMatrix var1) throws IllegalArgumentException;

    public BigMatrix preMultiply(BigMatrix var1) throws IllegalArgumentException;

    public BigDecimal[][] getData();

    public double[][] getDataAsDoubleArray();

    public void setData(BigDecimal[][] var1);

    public void setData(double[][] var1);

    public void setData(String[][] var1);

    public void setRoundingMode(int var1);

    public int getRoundingMode();

    public BigDecimal getNorm();

    public BigDecimal[] getRow(int var1) throws MatrixIndexException;

    public double[] getRowAsDoubleArray(int var1) throws MatrixIndexException;

    public BigDecimal[] getColumn(int var1) throws MatrixIndexException;

    public double[] getColumnAsDoubleArray(int var1) throws MatrixIndexException;

    public BigDecimal getEntry(int var1, int var2) throws MatrixIndexException;

    public double getEntryAsDouble(int var1, int var2) throws MatrixIndexException;

    public void setEntry(int var1, int var2, BigDecimal var3) throws MatrixIndexException;

    public void setEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public void setEntry(int var1, int var2, String var3) throws MatrixIndexException;

    public BigMatrix transpose();

    public BigMatrix inverse() throws InvalidMatrixException;

    public BigDecimal getDeterminant() throws InvalidMatrixException;

    public boolean isSquare();

    public boolean isSingular();

    public int getRowDimension();

    public int getColumnDimension();

    public BigDecimal getTrace();

    public BigDecimal[] operate(BigDecimal[] var1) throws IllegalArgumentException;

    public BigDecimal[] preMultiply(BigDecimal[] var1) throws IllegalArgumentException;

    public BigDecimal[] solve(BigDecimal[] var1) throws IllegalArgumentException, InvalidMatrixException;

    public BigMatrix solve(BigMatrix var1) throws IllegalArgumentException, InvalidMatrixException;
}

