/**
 * Creates SQL functions Java that obtain a randomly generated integer.
 */

package examples.tutorial.derby;
import java.util.*;
import org.apache.commons.math.random.*;

public class DerbyRand
{

   /**
    * Entrypoint for SQL function that obtains a randomly generated integer by 
    * calling java.util.Random.nextInt(), which sets the lower bound to 0.
    *
    * @param maxInt Upper bound on the number to be returned. 
    * @return Randomly generated integer.
    */
   public static int randIntSun(int maxInt)
   {
       int return_int=0;
       Random rand = new Random();
       return_int = rand.nextInt(maxInt);
       return return_int;
   }

   /**
    * Entrypoint for SQL function that obtains a randomly generated integer by 
    * calling org.apache.commons.math.random.nextInt().
    *
    * @param minInt Lower bound on the number to be returned. 
    * @param maxInt Upper bound on the number to be returned. 
    * @return Randomly generated integer.
    */
   public static int randIntJakarta(int minInt, int maxInt)
   {
       int return_int=0;
       RandomDataImpl randomData = new RandomDataImpl();
       return_int = randomData.nextInt(minInt,maxInt);
       return return_int;
   }
}
