/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.stat.inference.ChiSquareTest;

public class ChiSquareTestImpl
implements ChiSquareTest {
    private DistributionFactory distributionFactory = null;

    public double chiSquare(double[] expected, long[] observed) throws IllegalArgumentException {
        double sumSq = 0.0;
        double dev = 0.0;
        if (expected.length < 2 || expected.length != observed.length) {
            throw new IllegalArgumentException("observed, expected array lengths incorrect");
        }
        if (!this.isPositive(expected) || !this.isNonNegative(observed)) {
            throw new IllegalArgumentException("observed counts must be non-negative and expected counts must be postive");
        }
        for (int i = 0; i < observed.length; ++i) {
            dev = (double)observed[i] - expected[i];
            sumSq += dev * dev / expected[i];
        }
        return sumSq;
    }

    public double chiSquareTest(double[] expected, long[] observed) throws IllegalArgumentException, MathException {
        ChiSquaredDistribution chiSquaredDistribution = this.getDistributionFactory().createChiSquareDistribution((double)expected.length - 1.0);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(expected, observed));
    }

    public boolean chiSquareTest(double[] expected, long[] observed, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.chiSquareTest(expected, observed) < alpha;
    }

    public double chiSquare(long[][] counts) throws IllegalArgumentException {
        this.checkArray(counts);
        int nRows = counts.length;
        int nCols = counts[0].length;
        double[] rowSum = new double[nRows];
        double[] colSum = new double[nCols];
        double total = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                int n = row;
                rowSum[n] = rowSum[n] + (double)counts[row][col];
                int n2 = col;
                colSum[n2] = colSum[n2] + (double)counts[row][col];
                total += (double)counts[row][col];
            }
        }
        double sumSq = 0.0;
        double expected = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                expected = rowSum[row] * colSum[col] / total;
                sumSq += ((double)counts[row][col] - expected) * ((double)counts[row][col] - expected) / expected;
            }
        }
        return sumSq;
    }

    public double chiSquareTest(long[][] counts) throws IllegalArgumentException, MathException {
        this.checkArray(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        ChiSquaredDistribution chiSquaredDistribution = this.getDistributionFactory().createChiSquareDistribution(df);
        return 1.0 - chiSquaredDistribution.cumulativeProbability(this.chiSquare(counts));
    }

    public boolean chiSquareTest(long[][] counts, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new IllegalArgumentException("bad significance level: " + alpha);
        }
        return this.chiSquareTest(counts) < alpha;
    }

    private void checkArray(long[][] in) throws IllegalArgumentException {
        if (in.length < 2) {
            throw new IllegalArgumentException("Input table must have at least two rows");
        }
        if (in[0].length < 2) {
            throw new IllegalArgumentException("Input table must have at least two columns");
        }
        if (!this.isRectangular(in)) {
            throw new IllegalArgumentException("Input table must be rectangular");
        }
        if (!this.isNonNegative(in)) {
            throw new IllegalArgumentException("All entries in input 2-way table must be non-negative");
        }
    }

    protected DistributionFactory getDistributionFactory() {
        if (this.distributionFactory == null) {
            this.distributionFactory = DistributionFactory.newInstance();
        }
        return this.distributionFactory;
    }

    private boolean isRectangular(long[][] in) {
        for (int i = 1; i < in.length; ++i) {
            if (in[i].length == in[0].length) continue;
            return false;
        }
        return true;
    }

    private boolean isPositive(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (!(in[i] <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean isNonNegative(long[] in) {
        for (int i = 0; i < in.length; ++i) {
            if (in[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    private boolean isNonNegative(long[][] in) {
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[i].length; ++j) {
                if (in[i][j] > 0L) continue;
                return false;
            }
        }
        return true;
    }
}

