/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.random.EmpiricalDistribution;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.stat.univariate.StatisticalSummary;
import org.apache.commons.math.stat.univariate.SummaryStatistics;

public class EmpiricalDistributionImpl
implements Serializable,
EmpiricalDistribution {
    static final long serialVersionUID = -6773236347582113490L;
    private ArrayList binStats = null;
    SummaryStatistics sampleStats = null;
    private int binCount = 1000;
    private boolean loaded = false;
    private double[] upperBounds = null;
    private RandomData randomData = new RandomDataImpl();

    public EmpiricalDistributionImpl() {
        this.binStats = new ArrayList();
    }

    public EmpiricalDistributionImpl(int binCount) {
        this.binCount = binCount;
        this.binStats = new ArrayList();
    }

    public void load(double[] in) {
        ArrayDataAdapter da = new ArrayDataAdapter(in);
        try {
            ((DataAdapter)da).computeStats();
            this.fillBinStats(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            try {
                ((DataAdapter)da).computeStats();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fillBinStats(in);
            this.loaded = true;
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (Exception ex) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            try {
                ((DataAdapter)da).computeStats();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            in = new BufferedReader(new FileReader(file));
            this.fillBinStats(in);
            this.loaded = true;
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (Exception ex) {}
    }

    private void fillBinStats(Object in) throws IOException {
        int i;
        double min = this.sampleStats.getMin();
        double max = this.sampleStats.getMax();
        double delta = (max - min) / new Double(this.binCount);
        double[] binUpperBounds = new double[this.binCount];
        binUpperBounds[0] = min + delta;
        for (i = 1; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = binUpperBounds[i - 1] + delta;
        }
        binUpperBounds[this.binCount - 1] = max;
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats = SummaryStatistics.newInstance();
            this.binStats.add(i, stats);
        }
        DataAdapterFactory aFactory = new DataAdapterFactory();
        DataAdapter da = aFactory.getAdapter(in);
        try {
            da.computeBinStats(min, delta);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw new RuntimeException(e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)((SummaryStatistics)this.binStats.get(0)).getN() / (double)this.sampleStats.getN();
        for (int i2 = 1; i2 < this.binCount - 1; ++i2) {
            this.upperBounds[i2] = this.upperBounds[i2 - 1] + (double)((SummaryStatistics)this.binStats.get(i2)).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    public double getNextValue() throws IllegalStateException {
        if (!this.loaded) {
            throw new IllegalStateException("distribution not loaded");
        }
        double x = Math.random();
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats;
            if (!(x <= this.upperBounds[i]) || (stats = (SummaryStatistics)this.binStats.get(i)).getN() <= 0L) continue;
            if (stats.getStandardDeviation() > 0.0) {
                return this.randomData.nextGaussian(stats.getMean(), stats.getStandardDeviation());
            }
            return stats.getMean();
        }
        throw new RuntimeException("No bin selected");
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        return this.upperBounds;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private double[] inputArray;

        public ArrayDataAdapter(double[] in) {
            this.inputArray = in;
        }

        public void computeStats() throws IOException {
            EmpiricalDistributionImpl.this.sampleStats = SummaryStatistics.newInstance();
            for (int i = 0; i < this.inputArray.length; ++i) {
                EmpiricalDistributionImpl.this.sampleStats.addValue(this.inputArray[i]);
            }
        }

        public void computeBinStats(double min, double delta) throws IOException {
            for (int i = 0; i < this.inputArray.length; ++i) {
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(Math.max((int)Math.ceil((this.inputArray[i] - min) / delta) - 1, 0));
                stats.addValue(this.inputArray[i]);
            }
        }
    }

    private class StreamDataAdapter
    extends DataAdapter {
        BufferedReader inputStream;

        public StreamDataAdapter(BufferedReader in) {
            this.inputStream = in;
        }

        public void computeBinStats(double min, double delta) throws IOException {
            String str = null;
            double val = 0.0;
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.parseDouble(str);
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(Math.max((int)Math.ceil((val - min) / delta) - 1, 0));
                stats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }

        public void computeStats() throws IOException {
            String str = null;
            double val = 0.0;
            EmpiricalDistributionImpl.this.sampleStats = SummaryStatistics.newInstance();
            while ((str = this.inputStream.readLine()) != null) {
                val = new Double(str);
                EmpiricalDistributionImpl.this.sampleStats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private class DataAdapterFactory {
        private DataAdapterFactory() {
        }

        public DataAdapter getAdapter(Object in) {
            if (in instanceof BufferedReader) {
                BufferedReader inputStream = (BufferedReader)in;
                return new StreamDataAdapter(inputStream);
            }
            if (in instanceof double[]) {
                double[] inputArray = (double[])in;
                return new ArrayDataAdapter(inputArray);
            }
            throw new IllegalArgumentException("Input data comes from the unsupported source");
        }
    }

    private abstract class DataAdapter {
        private DataAdapter() {
        }

        public abstract void computeBinStats(double var1, double var3) throws Exception;

        public abstract void computeStats() throws Exception;
    }
}

