/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.beans.view;

public class FlightHistoryBean // implements Serializable
{

	// in my package.jdo I'm using a value-strategy of auto-assign:
	// <field name="id" primary-key="true" value-strategy="autoassign">
	// <column name="id" jdbc-type="INTEGER"/>
	// </field>
	// and the db table has a column id, that is defined as
	// CREATE TABLE APP.FLIGHTHISTORY
	// ( id int not null generated always as identity constraint user_fh_pk
	// primary key,
	private int id;

	private String userName;

	private String flightId;

	private String startAirport;

	private String departDate;

	private String endAirport;

	private String aircraft;

	private String creditCardType;

	private String creditCardDisplay;

	private String miles;

	public FlightHistoryBean(String name, String flight_id, String beginAirport,
			String depart_date, String endAirp, String jettype, String mileage,
			String ccType, String ccDisplay) {
		aircraft = jettype;
		creditCardDisplay = ccDisplay;
		creditCardType = ccType;
		departDate = depart_date;
		endAirport = endAirp;
		flightId = flight_id;
		startAirport = beginAirport;
		userName = name;
		miles = mileage;
	}

	public FlightHistoryBean() {
		aircraft = "";
		creditCardDisplay = "";
		creditCardType = "";
		departDate = "";
		endAirport = "";
		flightId = "";
		startAirport = "";
		userName = "";
		miles = "";
	}

	/**
	 * @return Returns the departDate.
	 */
	public String getDepartDate() {
		return departDate;
	}

	/**
	 * @param departDate
	 *          The departDate to set.
	 */
	public void setDepartDate(String departDate) {
		this.departDate = departDate;
	}

	/**
	 * @return Returns the endAirport.
	 */
	public String getEndAirport() {
		return endAirport;
	}

	/**
	 * @param endAirport
	 *          The endAirport to set.
	 */
	public void setEndAirport(String endAirport) {
		this.endAirport = endAirport;
	}

	/**
	 * @return Returns the flightId.
	 */
	public String getFlightId() {
		return flightId;
	}

	/**
	 * @param flightId
	 *          The flightId to set.
	 */
	public void setFlightId(String flightId) {
		this.flightId = flightId;
	}

	/**
	 * @return Returns the startAirport.
	 */
	public String getStartAirport() {
		return startAirport;
	}

	/**
	 * @param startAirport
	 *          The startAirport to set.
	 */
	public void setStartAirport(String startAirport) {
		this.startAirport = startAirport;
	}

	/**
	 * @return Returns the userName.
	 */
	public String getUserName() {
		return userName;
	}

	/**
	 * @param userName
	 *          The userName to set.
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getAircraft() {
		return aircraft;
	}

	public void setAircraft(String aircraft) {
		this.aircraft = aircraft;
	}

	public String getCreditCardDisplay() {
		return creditCardDisplay;
	}

	public void setCreditCardDisplay(String creditCardDisplay) {
		this.creditCardDisplay = creditCardDisplay;
	}

	public String getCreditCardType() {
		return creditCardType;
	}

	public void setCreditCardType(String creditCardType) {
		this.creditCardType = creditCardType;
	}

	public String getMiles() {
		return miles;

	}

	public void setMiles(String miles) {
		this.miles = miles;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

}
