/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.beans.model;

public class UserCreditCardBean 
{

	private int id = 0;

	private String lastName;

	private String userName;

	private String creditCardType;

	private String creditCardNumber;

	private String creditCardDisplay;

	public UserCreditCardBean() {
		creditCardType = "Visa";
	}

	public UserCreditCardBean(String lastName, String userName,
			String creditCardType, String creditCardNumber,
			String creditCardDisplay) {
		this.lastName = lastName;
		this.userName = userName;
		this.creditCardType = creditCardType;
		this.creditCardNumber = creditCardNumber;
		this.creditCardDisplay = creditCardDisplay;

	}

	public String getCreditCardNumber() {
		return creditCardNumber;
	}

	public void setCreditCardNumber(String creditCardNumber) {
		this.creditCardNumber = creditCardNumber;
		setCreditCardDisplay(creditCardNumber);
	}

	public String getCreditCardType() {
		return creditCardType;
	}

	public void setCreditCardType(String creditCardType) {
		this.creditCardType = creditCardType;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getCreditCardDisplay() {
		return creditCardDisplay;
	}

	public void setCreditCardDisplay(String creditCardNum) {
		StringBuffer sbuf = new StringBuffer(25);
		sbuf.append(creditCardNum.substring(0, 2));
		// mc is either 14 or 16 chars long
		int mcLength = creditCardNum.length();
		for (int i = 0; i < mcLength - 5; i++) {
			sbuf.append("*");
		}
		sbuf.append(creditCardNum.substring(mcLength - 3, mcLength));
		this.creditCardDisplay = sbuf.toString();
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

}
