/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.beans.view;

public class CityBean {

	private int cityId;

	private String cityName;

	private String country;

	private String airport;

	private String language; // VARCHAR(16),

	private String countryCode; // COUNTRY_ISO_CODE CHAR(2)

	public CityBean() {
		cityId = 0;
		cityName = "";
		country = "";
		airport = "";
		language = "";
		countryCode = "";
	}

	public CityBean(int city_id, String city, String ctry, String air) {
		cityId = city_id;
		cityName = city;
		country = ctry;
		airport = air;
	}

	public CityBean(int cityId, String cityName, String country, String airport,
			String language, String countryCode) {
		this.cityId = cityId;
		this.cityName = cityName;
		this.country = country;
		this.airport = airport;
		this.language = language;
		this.countryCode = countryCode;
	}

	/**
	 * @return Returns the airport.
	 */
	public String getAirport() {
		return airport;
	}

	/**
	 * @param airport
	 *          The airport to set.
	 */
	public void setAirport(String airport) {
		this.airport = airport;
	}

	/**
	 * @return Returns the cityName.
	 */
	public String getCityName() {
		return cityName;
	}

	/**
	 * @param cityName
	 *          The cityName to set.
	 */
	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	/**
	 * @return Returns the country.
	 */
	public String getCountry() {
		return country;
	}

	/**
	 * @param country
	 *          The country to set.
	 */
	public void setCountry(String country) {
		this.country = country;
	}

	public String toString() {
		// return cityId + "-" + cityName + " - " + airport + ", " + country;
		return cityName + " - " + airport + ", " + country;
	}

	public String toString2() {
		return cityId + ", " + cityName + " , " + country + ", " + airport + ", "
				+ language + ", " + countryCode;
	}

	public int getCityId() {
		return cityId;
	}

	public void setCityId(int cityId) {
		this.cityId = cityId;
	}

	public String getCountryCode() {
		return countryCode;
	}

	public void setCountryCode(String countryCode) {
		this.countryCode = countryCode;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}
}
