/*
 * Copyright 2006 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.derby.demo.application;

import java.sql.Time;
import java.util.Date;

import org.apache.derby.demo.beans.model.UserBean;
import org.apache.derby.demo.beans.view.CityBean;
import org.apache.derby.demo.beans.view.FlightHistoryBean;
import org.apache.derby.demo.beans.view.FlightsBean;
import org.apache.derby.demo.persistence.JPoxJDO;

public class DerbyJPox {

	public static void main(String[] args) {
		JPoxJDO jpoxJDO = new JPoxJDO();
		UserBean userBean = jpoxJDO.getUserPassword("apacheu");
		System.out.println("Issuing JPOX queries against the Derby DB, airlinesDB");
		System.out
				.println("***********************************************************");
		System.out
				.println("Query 1: The UserBean corresponding to the username apacheu is: ");
		System.out.print("firstname: " + userBean.getFirstName());
		System.out.print(" lastname: " + userBean.getLastName());
		System.out.println(" email: " + userBean.getEmail());
		System.out
				.println("***********************************************************");
		// Note, the user table has a primary key on username ... this insert
		// will only work once.
		System.out
				.println("Insert 1: Create a new user by calling JPoxJDO.insertUser(");
		System.out
				.println("\"Susan\", \"Cline\", \"slc\", \"slc@mycomp.org\", \"mypass\")");

		int success = jpoxJDO.insertUser("Susan", "Cline", "slc",
				"slc@mycomp.org", "mypass");
		if (success == 1) {
			System.out
					.println("Successfully inserted the user 'slc' into the database.");
		} else {
			System.out
		.println("Was not successful inserting the user into the database.");
		}
		System.out
				.println("***********************************************************");
		System.out
				.println("Query 2: Find the destination cities of flights from Athens.");
		CityBean[] cityBeans = jpoxJDO.destAirports("ATH");
		for (int i = 0; i < cityBeans.length; i++) {
			System.out.println("Dest City: " + cityBeans[i].getCityName());
		}
		System.out
				.println("***********************************************************");
		System.out.println("Insert 2: Create a FlightsHistoryBean by calling ");
		System.out.println("JPoxJDO.insertUserFlightHistory");
		System.out
				.println("(\"slc\", myFlightsBean, \"visa\", \"4728-xxxx-xxxx-xxxx-4567\")");
		FlightsBean flightsBean = new FlightsBean("AA1134", 1, "ATH", new Time(0),
				"AMS", new Time(1), "B", 12.00, "1200", "B747", new Date());
		int success2 = jpoxJDO.insertUserFlightHistory("slc", flightsBean, "visa",
				"4728-xxxx-xxxx-xxxx-4567");
		if (success2 == 1) {
			System.out
					.println("Successfully inserted a row into the FlightHistory table.");
		} else {
			System.out.println("Did not insert a row into the FlightHistory table.");
		}
		System.out
				.println("***********************************************************");
		System.out
				.println("Query 3: Select the row from the FlightHistory table based on username slc ");
		System.out.println("by calling JPoxJDO.fetchFlightHistory(\"slc\")");
		FlightHistoryBean[] flightHistoryBeans = jpoxJDO.fetchFlightHistory("slc");
		for (int i = 0; i < flightHistoryBeans.length; i++) {
			System.out.print("Flight: " + flightHistoryBeans[i].getFlightId());
			System.out.print(" Orig Airport: "
					+ flightHistoryBeans[i].getStartAirport());
			System.out.print(" Dest: " + flightHistoryBeans[i].getEndAirport());
			System.out.println(" Credit Crd: "
					+ flightHistoryBeans[i].getCreditCardDisplay());
		}
		System.out
				.println("***********************************************************");
		System.out.println("Shutting down JPOX persistence manager.");
		jpoxJDO.shutdown();
		System.out
				.println("***********************************************************");
	}

}
