package org.apache.derby.plugin.lab;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JaySpecies
{

    public static void selectLatinCommonName(String genus,
            ResultSet[] common_latin) throws SQLException
    {

        Connection conn = DriverManager
                .getConnection("jdbc:default:connection");

        String select = "select common_name, latin_name from APP.jay_species where genus = ?";

        PreparedStatement prepStmt = conn.prepareStatement(select);
        prepStmt.setString(1, genus);
        common_latin[0] = prepStmt.executeQuery();
     
        conn.close();
    }

    public static void selectAttributes(String common_name,
            ResultSet[] jay_attributes) throws SQLException
    {
        Connection conn = DriverManager
        .getConnection("jdbc:default:connection");

        String select = "select common_name, wing_span_in, length_in, weight_oz, range, voice " +
                "from APP.jay_attributes where common_name = ?";

        PreparedStatement prepStmt = conn.prepareStatement(select);
        prepStmt.setString(1, common_name);
        jay_attributes[0] = prepStmt.executeQuery();

        conn.close();
    }
    
    public static void wingSpan(java.math.BigDecimal minWingSpan, java.math.BigDecimal maxWingSpan,
            ResultSet[] jay_attributes) throws SQLException
    {
        Connection conn = DriverManager
        .getConnection("jdbc:default:connection");

        String select = "select species.genus, species.latin_name, attributes.common_name, " +
                "attributes.wing_span_in, attributes.length_in, attributes.weight_oz, " +
                "attributes.range, attributes.voice from APP.jay_species as species, " +
                "APP.jay_attributes as attributes where species.species_id = attributes.species_fk_id " +
                "and attributes.wing_span_in >= ? and attributes.wing_span_in <= ?";

        PreparedStatement prepStmt = conn.prepareStatement(select);
        prepStmt.setBigDecimal(1, minWingSpan);
        prepStmt.setBigDecimal(2, maxWingSpan);
        jay_attributes[0] = prepStmt.executeQuery();
        

        conn.close();
    }

}
