connect 'jdbc:derby://localhost:1527/jayDB;create=true;user=APP;password=APP;';

DROP table APP.jay_species;

create table APP.jay_species
(
 species_id int not null generated always as identity,
 genus varchar(30) not null,
 latin_name varchar(30) not null,
 common_name varchar(30) not null,
 primary key (species_id)
);

DROP table APP.jay_attributes;

 create table APP.jay_attributes
 (
   species_fk_id int not null,
   common_name varchar(30) not null,
   wing_span_in decimal(4,2),
   length_in double,
   weight_oz double,
   range char(40),
   voice varchar(100)
 );
   
ALTER TABLE APP.jay_attributes ADD FOREIGN KEY (species_fk_id) REFERENCES APP.jay_species(species_id);

insert into APP.jay_species (genus, latin_name, common_name)
values
('Cyanocitta', 'Cyanocitta stelleri', 'Stellar''s Jay');

insert into APP.jay_attributes (species_fk_id, common_name)
select species_id, common_name from APP.jay_species where species_id = IDENTITY_VAL_LOCAL();

UPDATE APP.jay_attributes set wing_span_in = 19.0, length_in = 11.5, 
weight_oz = 3.7, range = 'pacific, queen charlotte islands', voice = 'Varied; most common a very harsh, unmusical, descending shaaaar'
where species_fk_id = IDENTITY_VAL_LOCAL();

insert into APP.jay_species (genus, latin_name, common_name)
values
('Aphelocoma', 'Aphelocoma californica', 'Western Scrub-Jay');

insert into APP.jay_attributes (species_fk_id, common_name)
select species_id, common_name from APP.jay_species where species_id = IDENTITY_VAL_LOCAL();

UPDATE APP.jay_attributes set wing_span_in = 15.5, length_in = 11.5, 
weight_oz = 3.0, range = 'pacific, southwest', voice = 'Generally harsh and angry sounding.  Most common call a harsh, rising shreeenk.'
where species_fk_id = IDENTITY_VAL_LOCAL();

insert into APP.jay_species (genus, latin_name, common_name)
values
('Aphelocoma', 'Aphelocoma insularis', 'Island Scrub-Jay');

insert into APP.jay_attributes (species_fk_id, common_name)
select species_id, common_name from APP.jay_species where species_id = IDENTITY_VAL_LOCAL();

UPDATE APP.jay_attributes set wing_span_in = 17.0, length_in = 13.0, 
weight_oz = 4.1, range = 'Santa Cruz island', voice = 'Generally harsh and angry sounding.  Most common call a harsh, rising shreeenk.'
where species_fk_id = IDENTITY_VAL_LOCAL();

insert into APP.jay_species (genus, latin_name, common_name)
values
('Nucifraga', 'Nucifraga columbiana', 'Clark''s Nutcracker');

insert into APP.jay_attributes (species_fk_id, common_name)
select species_id, common_name from APP.jay_species where species_id = IDENTITY_VAL_LOCAL();

UPDATE APP.jay_attributes set wing_span_in = 24.0, length_in = 12.0, 
weight_oz = 4.6, range = 'southwest, northwest', voice = 'Varied; common call a long, harsh, slightly rising shraaaaaa.'
where species_fk_id = IDENTITY_VAL_LOCAL();

insert into APP.jay_species (genus, latin_name, common_name)
values
('Pica', 'Pica nuttalli', 'Yellow-billed Magpie');

insert into APP.jay_attributes (species_fk_id, common_name)
select species_id, common_name from APP.jay_species where species_id = IDENTITY_VAL_LOCAL();

UPDATE APP.jay_attributes set wing_span_in = 24.0, length_in = 16.5, 
weight_oz = 5.0, range = 'california coast, valley', voice = 'Chatter call reportedly higher-pitched and clearer than Black-billed.'
where species_fk_id = IDENTITY_VAL_LOCAL();
 
select * from APP.jay_species;
 
select * from APP.jay_attributes;

   
