/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class MemByteHolder
implements ByteHolder {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    int bufSize;
    boolean writing = true;
    Vector bufV;
    int curBufVEleAt;
    byte[] curBuf;
    int curBufPos;
    int curBufDataBytes;
    int lastBufVEleAt = 0;
    int lastBufDataBytes = 0;

    public void write(int n) throws IOException {
        if (this.curBufPos >= this.curBuf.length) {
            this.getNextBuffer_w();
        }
        this.curBuf[this.curBufPos++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            int n4;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n4 = n2) > (n3 = this.curBuf.length - this.curBufPos)) {
                n4 = n3;
            }
            System.arraycopy(byArray, n, this.curBuf, this.curBufPos, n4);
            n += n4;
            this.curBufPos += n4;
            n2 -= n4;
        }
    }

    public long write(InputStream inputStream, long l) throws IOException {
        long l2 = l;
        int n = 0;
        do {
            int n2;
            int n3;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n = inputStream.read(this.curBuf, this.curBufPos, n3 = l2 >= (long)(n2 = this.curBuf.length - this.curBufPos) ? n2 : (int)l2)) <= 0) continue;
            l2 -= (long)n;
            this.curBufPos += n;
        } while (l2 > 0L && n > 0);
        return l - l2;
    }

    public void clear() throws IOException {
        this.writing = true;
        this.curBuf = (byte[])this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.lastBufVEleAt = 0;
        this.lastBufDataBytes = 0;
    }

    public void startReading() throws IOException {
        if (this.writing) {
            this.writing = false;
            this.lastBufDataBytes = this.curBufPos;
            this.lastBufVEleAt = this.curBufVEleAt;
        }
        this.curBuf = (byte[])this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
    }

    public int read() throws IOException {
        if (this.curBufPos >= this.curBufDataBytes) {
            this.getNextBuffer_r();
        }
        if (this.curBufPos >= this.curBufDataBytes) {
            return -1;
        }
        return 0xFF & this.curBuf[this.curBufPos++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, null, n2);
    }

    public int read(OutputStream outputStream, int n) throws IOException {
        return this.read(null, 0, outputStream, n);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, OutputStream var3_3, int var4_4) throws IOException {
        var5_5 = 0;
        var6_6 = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            var6_6 = this.getNextBuffer_r();
        }
        if (!var6_6) ** GOTO lbl19
        return -1;
lbl-1000:
        // 1 sources

        {
            var7_7 = this.curBufDataBytes - this.curBufPos;
            var8_8 = var4_4 >= var7_7 ? var7_7 : var4_4;
            if (var3_3 == null) {
                System.arraycopy(this.curBuf, this.curBufPos, var1_1, var2_2, var8_8);
            } else {
                var3_3.write(this.curBuf, this.curBufPos, var8_8);
            }
            var2_2 += var8_8;
            this.curBufPos += var8_8;
            var4_4 -= var8_8;
            var5_5 += var8_8;
            if (this.curBufPos < this.curBufDataBytes) continue;
            var6_6 = this.getNextBuffer_r();
lbl19:
            // 3 sources

            ** while (var4_4 > 0 && !var6_6)
        }
lbl20:
        // 1 sources

        return var5_5;
    }

    public int shiftToFront() throws IOException {
        int n = this.available();
        n = n > 0 ? n : -1 * n;
        byte[] byArray = new byte[n + 1];
        int n2 = this.read(byArray, 0, n);
        this.clear();
        this.writing = true;
        this.write(byArray, 0, n2);
        this.curBufDataBytes = 0;
        return n2;
    }

    public int available() {
        int n = this.curBufDataBytes - this.curBufPos;
        int n2 = 0;
        int n3 = 0;
        if (this.curBufVEleAt != this.lastBufVEleAt) {
            n3 = this.lastBufVEleAt - this.curBufVEleAt - 1;
            n2 = this.lastBufDataBytes;
        }
        int n4 = n + n2 + n3 * this.bufSize;
        return n4;
    }

    public int numBytesSaved() {
        int n = this.writing ? this.curBufVEleAt * this.bufSize + this.curBufPos : this.lastBufVEleAt * this.bufSize + this.lastBufDataBytes;
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        boolean bl = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            bl = this.getNextBuffer_r();
        }
        while (l > 0L && !bl) {
            int n = this.curBufDataBytes - this.curBufPos;
            int n2 = l >= (long)n ? n : (int)l;
            this.curBufPos += n2;
            l2 += (long)n2;
            if ((l -= (long)n2) <= 0L) continue;
            bl = this.getNextBuffer_r();
        }
        return l2;
    }

    public boolean writingMode() {
        return this.writing;
    }

    protected void getNextBuffer_w() throws IOException {
        ++this.curBufVEleAt;
        if (this.bufV.size() <= this.curBufVEleAt) {
            this.curBuf = new byte[this.bufSize];
            this.bufV.addElement(this.curBuf);
        } else {
            this.curBuf = (byte[])this.bufV.elementAt(this.curBufVEleAt);
        }
        this.initBuffer_w();
    }

    protected void getNextBuffer_w_Sanity() {
    }

    protected void initBuffer_w() {
        this.curBufPos = 0;
    }

    protected boolean getNextBuffer_r() throws IOException {
        if (this.curBufVEleAt >= this.lastBufVEleAt) {
            return true;
        }
        this.curBuf = (byte[])this.bufV.elementAt(++this.curBufVEleAt);
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
        return false;
    }

    private String dumpBuf(int n) {
        StringBuffer stringBuffer = new StringBuffer(100);
        byte[] byArray = (byte[])this.bufV.elementAt(n);
        stringBuffer.append("(");
        int n2 = 0;
        while (n2 < byArray.length) {
            stringBuffer.append(byArray[n2] + ".");
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return " writing: " + this.writing + " curBufVEleAt: " + this.curBufVEleAt + " curBufPos: " + this.curBufPos + " curBufDataBytes: " + this.curBufDataBytes + " lastBufVEleAt: " + this.lastBufVEleAt + " lastBufDataBytes: " + this.lastBufDataBytes + " curBuf: " + this.dumpBuf(this.curBufVEleAt);
    }

    public MemByteHolder(int n) {
        this.bufSize = n;
        this.curBuf = new byte[n];
        this.curBufPos = 0;
        this.bufV = new Vector(128);
        this.bufV.addElement(this.curBuf);
        this.curBufVEleAt = 0;
    }
}

