/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.File;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.access.CacheableConglomerate;
import org.apache.derby.impl.store.access.PropertyConglomerate;
import org.apache.derby.impl.store.access.RAMTransaction;
import org.apache.derby.impl.store.access.RAMTransactionContext;

public abstract class RAMAccessManager
implements AccessFactory,
CacheableFactory,
ModuleControl,
PropertySetCallback {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private RawStoreFactory rawstore;
    private Hashtable implhash = new Hashtable();
    private Hashtable formathash = new Hashtable();
    private Properties serviceProperties;
    LockingPolicy system_default_locking_policy;
    private PropertyConglomerate xactProperties;
    private PropertyFactory pf;
    protected LockingPolicy[] table_level_policy;
    protected LockingPolicy[] record_level_policy;
    protected ConglomerateFactory[] conglom_map;
    private CacheManager conglom_cache;
    private long conglom_nextid = 0L;

    protected LockingPolicy getDefaultLockingPolicy() {
        return this.system_default_locking_policy;
    }

    RawStoreFactory getRawStore() {
        return this.rawstore;
    }

    PropertyConglomerate getTransactionalProperties() {
        return this.xactProperties;
    }

    private void boot_load_conglom_map() throws StandardException {
        this.conglom_map = new ConglomerateFactory[2];
        MethodFactory methodFactory = this.findMethodFactoryByImpl("heap");
        if (methodFactory == null || !(methodFactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "heap");
        }
        this.conglom_map[0] = (ConglomerateFactory)methodFactory;
        methodFactory = this.findMethodFactoryByImpl("BTREE");
        if (methodFactory == null || !(methodFactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", "BTREE");
        }
        this.conglom_map[1] = (ConglomerateFactory)methodFactory;
    }

    protected abstract int getSystemLockLevel();

    protected abstract void bootLookupSystemLockLevel(TransactionController var1) throws StandardException;

    protected long getNextConglomId(int n) throws StandardException {
        long l;
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            if (this.conglom_nextid == 0L) {
                this.conglom_nextid = (this.rawstore.getMaxContainerId() >> 4) + 1L;
            }
            l = this.conglom_nextid++;
        }
        return l << 4 | (long)n;
    }

    private ConglomerateFactory getFactoryFromConglomId(long l) throws StandardException {
        try {
            return this.conglom_map[(int)(0xFL & l)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw StandardException.newException("XSAI2.S", new Long(l));
        }
    }

    private void conglomCacheInit() throws StandardException {
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.conglom_cache = cacheFactory.newCacheManager(this, "ConglomerateDirectoryCache", 200, 300);
    }

    Conglomerate conglomCacheFind(TransactionManager transactionManager, long l) throws StandardException {
        Conglomerate conglomerate = null;
        Long l2 = new Long(l);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.findCached(l2);
            if (cacheableConglomerate != null) {
                conglomerate = cacheableConglomerate.getConglom();
                this.conglom_cache.release(cacheableConglomerate);
            } else {
                conglomerate = this.getFactoryFromConglomId(l).readConglomerate(transactionManager, new ContainerKey(0L, l));
                if (conglomerate != null) {
                    cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.create(l2, conglomerate);
                    this.conglom_cache.release(cacheableConglomerate);
                }
            }
        }
        return conglomerate;
    }

    protected void conglomCacheInvalidate() throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            this.conglom_cache.ageOut();
        }
    }

    void conglomCacheUpdateEntry(long l, Conglomerate conglomerate) throws StandardException {
        Long l2 = new Long(l);
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.findCached(l2);
            if (cacheableConglomerate != null) {
                this.conglom_cache.remove(cacheableConglomerate);
            }
            cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.create(l2, conglomerate);
            this.conglom_cache.release(cacheableConglomerate);
        }
    }

    void conglomCacheAddEntry(long l, Conglomerate conglomerate) throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.create(new Long(l), conglomerate);
            this.conglom_cache.release(cacheableConglomerate);
        }
    }

    void conglomCacheRemoveEntry(long l) throws StandardException {
        CacheManager cacheManager = this.conglom_cache;
        synchronized (cacheManager) {
            CacheableConglomerate cacheableConglomerate = (CacheableConglomerate)this.conglom_cache.findCached(new Long(l));
            if (cacheableConglomerate != null) {
                this.conglom_cache.remove(cacheableConglomerate);
            }
        }
    }

    public void createFinished() throws StandardException {
        this.rawstore.createFinished();
    }

    public MethodFactory findMethodFactoryByFormat(UUID uUID) {
        MethodFactory methodFactory = (MethodFactory)this.formathash.get(uUID);
        if (methodFactory != null) {
            return methodFactory;
        }
        Enumeration enumeration = this.formathash.elements();
        while (enumeration.hasMoreElements()) {
            methodFactory = (MethodFactory)enumeration.nextElement();
            if (!methodFactory.supportsFormat(uUID)) continue;
            return methodFactory;
        }
        return null;
    }

    public MethodFactory findMethodFactoryByImpl(String string) throws StandardException {
        Properties properties;
        MethodFactory methodFactory;
        block5: {
            methodFactory = (MethodFactory)this.implhash.get(string);
            if (methodFactory != null) {
                return methodFactory;
            }
            Enumeration enumeration = this.implhash.elements();
            while (enumeration.hasMoreElements()) {
                methodFactory = (MethodFactory)enumeration.nextElement();
                if (!methodFactory.supportsImplementation(string)) continue;
                return methodFactory;
            }
            methodFactory = null;
            properties = new Properties(this.serviceProperties);
            ((Hashtable)properties).put("derby.access.Conglomerate.type", string);
            try {
                methodFactory = (MethodFactory)Monitor.bootServiceModule(false, this, "org.apache.derby.iapi.store.access.conglomerate.MethodFactory", string, properties);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("XBM02.D")) break block5;
                throw standardException;
            }
        }
        properties = null;
        if (methodFactory != null) {
            this.registerAccessMethod(methodFactory);
            return methodFactory;
        }
        return null;
    }

    public LockFactory getLockFactory() {
        return this.rawstore.getLockFactory();
    }

    public TransactionController getTransaction(ContextManager contextManager) throws StandardException {
        return this.getAndNameTransaction(contextManager, "UserTransaction");
    }

    public TransactionController getAndNameTransaction(ContextManager contextManager, String string) throws StandardException {
        if (contextManager == null) {
            return null;
        }
        RAMTransactionContext rAMTransactionContext = (RAMTransactionContext)contextManager.getContext("RAMTransactionContext");
        if (rAMTransactionContext == null) {
            Transaction transaction = this.rawstore.findUserTransaction(contextManager, string);
            RAMTransaction rAMTransaction = new RAMTransaction(this, transaction, null);
            rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMTransactionContext", rAMTransaction, false);
            RAMTransaction rAMTransaction2 = rAMTransactionContext.getTransaction();
            if (this.xactProperties != null) {
                transaction.setup(rAMTransaction2);
                rAMTransaction2.commit();
            }
            transaction.setDefaultLockingPolicy(this.system_default_locking_policy);
            rAMTransaction2.commit();
            return rAMTransaction2;
        }
        return rAMTransactionContext.getTransaction();
    }

    public Object startXATransaction(ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        RAMTransaction rAMTransaction;
        block2: {
            rAMTransaction = null;
            if (contextManager == null) {
                return null;
            }
            RAMTransactionContext rAMTransactionContext = (RAMTransactionContext)contextManager.getContext("RAMTransactionContext");
            if (rAMTransactionContext != null) break block2;
            Transaction transaction = this.rawstore.startGlobalTransaction(contextManager, n, byArray, byArray2);
            rAMTransaction = new RAMTransaction(this, transaction, null);
            rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMTransactionContext", rAMTransaction, false);
            if (this.xactProperties != null) {
                transaction.setup(rAMTransaction);
                rAMTransaction.commitNoSync(5);
            }
            transaction.setDefaultLockingPolicy(this.system_default_locking_policy);
            rAMTransaction.commitNoSync(5);
        }
        return rAMTransaction;
    }

    public Object getXAResourceManager() throws StandardException {
        return this.rawstore.getXAResourceManager();
    }

    public void registerAccessMethod(MethodFactory methodFactory) {
        this.implhash.put(methodFactory.primaryImplementationType(), methodFactory);
        this.formathash.put(methodFactory.primaryFormat(), methodFactory);
    }

    public boolean isReadOnly() {
        return this.rawstore.isReadOnly();
    }

    private void addPropertySetNotification(PropertySetCallback propertySetCallback, TransactionController transactionController) {
        this.pf.addPropertySetNotification(propertySetCallback);
        Hashtable hashtable = new Hashtable();
        try {
            this.xactProperties.getProperties(transactionController, hashtable, false, false);
        }
        catch (StandardException standardException) {
            return;
        }
        boolean bl = PropertyUtil.isDBOnly(hashtable);
        propertySetCallback.init(bl, hashtable);
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.rawstore.getTransactionInfo();
    }

    public void freeze() throws StandardException {
        this.rawstore.freeze();
    }

    public void unfreeze() throws StandardException {
        this.rawstore.unfreeze();
    }

    public void backup(String string) throws StandardException {
        this.rawstore.backup(string);
    }

    public void backup(File file) throws StandardException {
        this.rawstore.backup(file);
    }

    public void backupAndEnableLogArchiveMode(String string, boolean bl) throws StandardException {
        this.rawstore.backupAndEnableLogArchiveMode(string, bl);
    }

    public void backupAndEnableLogArchiveMode(File file, boolean bl) throws StandardException {
        this.rawstore.backupAndEnableLogArchiveMode(file, bl);
    }

    public void disableLogArchiveMode(boolean bl) throws StandardException {
        this.rawstore.disableLogArchiveMode(bl);
    }

    public void checkpoint() throws StandardException {
        this.rawstore.checkpoint();
    }

    public void waitForPostCommitToFinishWork() {
        this.rawstore.getDaemon().waitUntilQueueIsEmpty();
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.serviceProperties = properties;
        this.boot_load_conglom_map();
        if (bl) {
            this.conglom_nextid = 1L;
        }
        this.rawstore = (RawStoreFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.store.raw.RawStoreFactory", this.serviceProperties);
        Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.property.PropertyFactory", properties);
        this.conglomCacheInit();
        RAMTransaction rAMTransaction = (RAMTransaction)this.getAndNameTransaction(ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        int n = 2;
        this.system_default_locking_policy = rAMTransaction.getRawStoreXact().newLockingPolicy(n, 5, true);
        this.table_level_policy = new LockingPolicy[6];
        this.table_level_policy[0] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 0, true);
        this.table_level_policy[1] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 1, true);
        this.table_level_policy[2] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 2, true);
        this.table_level_policy[3] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 3, true);
        this.table_level_policy[4] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 4, true);
        this.table_level_policy[5] = rAMTransaction.getRawStoreXact().newLockingPolicy(2, 5, true);
        this.record_level_policy = new LockingPolicy[6];
        this.record_level_policy[0] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 0, true);
        this.record_level_policy[1] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 1, true);
        this.record_level_policy[2] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 2, true);
        this.record_level_policy[3] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 3, true);
        this.record_level_policy[4] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 4, true);
        this.record_level_policy[5] = rAMTransaction.getRawStoreXact().newLockingPolicy(1, 5, true);
        rAMTransaction.commit();
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.xactProperties = new PropertyConglomerate(rAMTransaction, bl, properties, this.pf);
        this.rawstore.getRawStoreProperties(rAMTransaction);
        this.bootLookupSystemLockLevel(rAMTransaction);
        n = this.getSystemLockLevel() == 7 ? 2 : 1;
        this.system_default_locking_policy = rAMTransaction.getRawStoreXact().newLockingPolicy(n, 5, true);
        this.addPropertySetNotification(this.getLockFactory(), rAMTransaction);
        this.addPropertySetNotification(this, rAMTransaction);
        rAMTransaction.commit();
        rAMTransaction.destroy();
        rAMTransaction = null;
    }

    public void stop() {
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("encryptionAlgorithm")) {
            throw StandardException.newException("XBCXD.S");
        }
        if (string.equals("encryptionProvider")) {
            throw StandardException.newException("XBCXE.S");
        }
        return true;
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        return null;
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        return new CacheableConglomerate();
    }
}

