/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexSetChanger;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class RowChangerImpl
implements RowChanger {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    boolean isOpen;
    boolean[] fixOnUpdate;
    long heapConglom;
    DynamicCompiledOpenConglomInfo heapDCOCI;
    StaticCompiledOpenConglomInfo heapSCOCI;
    long[] indexCIDS;
    DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    StaticCompiledOpenConglomInfo[] indexSCOCIs;
    IndexRowGenerator[] irgs;
    Activation activation;
    TransactionController tc;
    FormatableBitSet changedColumnBitSet;
    FormatableBitSet baseRowReadList;
    protected int[] baseRowReadMap;
    int[] changedColumnIds;
    TemporaryRowHolderImpl rowHolder;
    String[] indexNames;
    protected ConglomerateController baseCC;
    protected RowLocation baseRowLocation;
    IndexSetChanger isc;
    private DataValueDescriptor[] sparseRowArray;
    private int[] partialChangedColumnIds;

    public void setRowHolder(TemporaryRowHolder temporaryRowHolder) {
        this.rowHolder = (TemporaryRowHolderImpl)temporaryRowHolder;
    }

    public void setIndexNames(String[] stringArray) {
        this.indexNames = stringArray;
    }

    public void open(int n) throws StandardException {
        if (this.fixOnUpdate == null) {
            this.fixOnUpdate = new boolean[this.irgs.length];
            int n2 = 0;
            while (n2 < this.irgs.length) {
                this.fixOnUpdate[n2] = true;
                ++n2;
            }
        }
        this.openForUpdate(this.fixOnUpdate, n, true);
    }

    public void openForUpdate(boolean[] blArray, int n, boolean bl) throws StandardException {
        LanguageConnectionContext languageConnectionContext = null;
        if (this.activation != null) {
            languageConnectionContext = this.activation.getLanguageConnectionContext();
        }
        int n2 = languageConnectionContext == null ? 2 : languageConnectionContext.getCurrentIsolationLevel();
        switch (n2) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
        }
        try {
            this.baseCC = this.heapSCOCI != null ? this.tc.openCompiledConglomerate(false, 4 | (bl ? 0 : 128), n, n2, this.heapSCOCI, this.heapDCOCI) : this.tc.openConglomerate(this.heapConglom, false, 4 | (bl ? 0 : 128), n, n2);
        }
        catch (StandardException standardException) {
            if (this.activation != null) {
                this.activation.checkStatementValidity();
            }
            throw standardException;
        }
        if (this.activation != null) {
            this.activation.checkStatementValidity();
            this.activation.setHeapConglomerateController(this.baseCC);
        }
        if (this.indexCIDS.length != 0) {
            if (this.isc == null) {
                this.isc = new IndexSetChanger(this.irgs, this.indexCIDS, this.indexSCOCIs, this.indexDCOCIs, this.indexNames, this.baseCC, this.tc, n, this.baseRowReadList, n2, this.activation);
                this.isc.setRowHolder(this.rowHolder);
            } else {
                this.isc.setBaseCC(this.baseCC);
            }
            this.isc.open(blArray);
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.baseCC.newRowLocationTemplate();
            }
        }
        this.isOpen = true;
    }

    public void insertRow(ExecRow execRow) throws StandardException {
        if (!this.baseCC.isKeyed()) {
            if (this.isc != null) {
                this.baseCC.insertAndFetchLocation(execRow.getRowArray(), this.baseRowLocation);
                this.isc.insert(execRow, this.baseRowLocation);
            } else {
                this.baseCC.insert(execRow.getRowArray());
            }
        }
    }

    public void deleteRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.delete(execRow, rowLocation);
        }
        this.baseCC.delete(rowLocation);
    }

    public void updateRow(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.update(execRow, execRow2, rowLocation);
        }
        if (this.changedColumnBitSet != null) {
            DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
            int[] nArray = this.partialChangedColumnIds == null ? this.changedColumnIds : this.partialChangedColumnIds;
            int n = -1;
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2] - 1;
                n = this.changedColumnBitSet.anySetBit(n);
                this.sparseRowArray[n] = dataValueDescriptorArray[n3];
                ++n2;
            }
        } else {
            this.sparseRowArray = execRow2.getRowArray();
        }
        this.baseCC.replace(rowLocation, this.sparseRowArray, this.changedColumnBitSet);
    }

    public void finish() throws StandardException {
        if (this.isc != null) {
            this.isc.finish();
        }
    }

    public void close() throws StandardException {
        if (this.isc != null) {
            this.isc.close();
        }
        if (this.baseCC != null) {
            if (this.activation == null || this.activation.getForUpdateIndexScan() == null) {
                this.baseCC.close();
            }
            this.baseCC = null;
        }
        this.isOpen = false;
        if (this.activation != null) {
            this.activation.clearHeapConglomerateController();
        }
    }

    public ConglomerateController getHeapConglomerateController() {
        return this.baseCC;
    }

    private int[] sortArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2);
        return nArray2;
    }

    /*
     * Unable to fully structure code
     */
    public RowChangerImpl(long var1_1, StaticCompiledOpenConglomInfo var3_2, DynamicCompiledOpenConglomInfo var4_3, IndexRowGenerator[] var5_4, long[] var6_5, StaticCompiledOpenConglomInfo[] var7_6, DynamicCompiledOpenConglomInfo[] var8_7, int var9_8, int[] var10_9, TransactionController var11_10, FormatableBitSet var12_11, int[] var13_12, Activation var14_13) throws StandardException {
        block4: {
            super();
            this.isOpen = false;
            this.fixOnUpdate = null;
            this.indexCIDS = null;
            this.irgs = null;
            this.baseCC = null;
            this.baseRowLocation = null;
            this.heapConglom = var1_1;
            this.heapSCOCI = var3_2;
            this.heapDCOCI = var4_3;
            this.irgs = var5_4;
            this.indexCIDS = var6_5;
            this.indexSCOCIs = var7_6;
            this.indexDCOCIs = var8_7;
            this.tc = var11_10;
            this.baseRowReadList = var12_11;
            this.baseRowReadMap = var13_12;
            this.activation = var14_13;
            if (var10_9 == null) break block4;
            this.changedColumnIds = RowUtil.inAscendingOrder(var10_9) != false ? var10_9 : this.sortArray(var10_9);
            this.sparseRowArray = new DataValueDescriptor[this.changedColumnIds[this.changedColumnIds.length - 1] + 1];
            this.changedColumnBitSet = new FormatableBitSet(var9_8);
            var15_14 = 0;
            while (var15_14 < this.changedColumnIds.length) {
                this.changedColumnBitSet.grow(this.changedColumnIds[var15_14]);
                this.changedColumnBitSet.set(this.changedColumnIds[var15_14] - 1);
                ++var15_14;
            }
            if (var12_11 == null) break block4;
            this.partialChangedColumnIds = new int[this.changedColumnIds.length];
            var15_14 = 1;
            var16_15 = 0;
            var17_16 = 0;
            ** GOTO lbl42
            {
                if (var12_11.get(var16_15)) {
                    ++var15_14;
                }
                ++var16_15;
                do {
                    if (var16_15 < this.changedColumnIds[var17_16]) continue block1;
                    this.partialChangedColumnIds[var17_16] = var15_14;
                    ++var17_16;
lbl42:
                    // 2 sources

                } while (var17_16 < this.changedColumnIds.length);
            }
        }
    }
}

