/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.context.ErrorStringBuilder;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.i18n.BundleFinder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableInstanceGetter;
import org.apache.derby.iapi.services.io.RegisteredFormatIds;
import org.apache.derby.iapi.services.loader.ClassInfo;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.impl.services.monitor.AntiGC;
import org.apache.derby.impl.services.monitor.PersistentServiceImpl;
import org.apache.derby.impl.services.monitor.ProtocolKey;
import org.apache.derby.impl.services.monitor.ServiceBootContext;
import org.apache.derby.impl.services.monitor.TopService;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;

public abstract class BaseMonitor
implements ModuleFactory,
BundleFinder {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final String SERVICE = "derby.service.";
    private static final HashMap storageFactories = new HashMap();
    protected Hashtable serviceProviders;
    protected Vector[] implementationSets;
    private Vector services = new Vector(0, 1);
    protected Properties bootProperties;
    protected Properties applicationProperties;
    boolean inShutdown;
    private InfoStreams systemStreams;
    private ContextService contextService;
    private UUIDFactory uuidFactory;
    protected boolean reportOn;
    private PrintStream logging;
    protected ThreadGroup daemonGroup;
    AntiGC dontGC;
    private InstanceGetter[] rc2;
    private Boolean exceptionTrace;
    private PrintWriter tmpWriter;
    private AccessibleByteArrayOutputStream tmpArray;
    private boolean dumpedTempWriter;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$services$io$FormatableInstanceGetter;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$services$monitor$ModuleSupportable;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$services$monitor$ModuleControl;
    private static /* synthetic */ Class class$Lorg$apache$derby$io$StorageFactory;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$services$monitor$PersistentService;

    public InfoStreams getSystemStreams() {
        return this.systemStreams;
    }

    /*
     * Unable to fully structure code
     */
    public void shutdown() {
        var1_1 = this;
        synchronized (var1_1) {
            if (this.inShutdown) {
                var2_2 = null;
                return;
            }
            this.inShutdown = true;
        }
        this.contextService.notifyAllActiveThreads(null);
        while (true) lbl-1000:
        // 3 sources

        {
            var5_5 = this;
            synchronized (var5_5) {
                var4_4 = this.services.size() - 1;
                if (var4_4 == 0) {
                    var6_7 = null;
                    ** break;
                }
                var3_3 = (TopService)this.services.elementAt(var4_4);
            }
            var7_8 = this.contextService.newContextManager();
            try {
                var7_8.popContext();
                this.contextService.setCurrentContextManager(var7_8);
                this.shutdown(var3_3.getService());
            }
            finally {
                var6_7 = null;
                this.contextService.resetCurrentContextManager(var7_8);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl38:
        // 1 sources

        ((TopService)this.services.elementAt(0)).shutdown();
        var1_1 = this.dontGC;
        synchronized (var1_1) {
            this.dontGC.goAway = true;
            this.dontGC.notifyAll();
        }
        ContextService.stop();
        Monitor.clearMonitor();
    }

    public void shutdown(Object object) {
        if (object == null) {
            return;
        }
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return;
        }
        boolean bl = true;
        try {
            bl = topService.shutdown();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            BaseMonitor baseMonitor = this;
            synchronized (baseMonitor) {
                if (bl) {
                    boolean bl2 = this.services.removeElement(topService);
                }
            }
            throw throwable;
        }
        Object var5_4 = null;
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            if (bl) {
                boolean bl3 = this.services.removeElement(topService);
            }
        }
    }

    protected final void runWithState(Properties properties, PrintStream printStream) {
        this.bootProperties = properties;
        this.logging = printStream;
        if (!this.initialize(false)) {
            return;
        }
        if (!Monitor.setMonitor(this)) {
            return;
        }
        Object object = MessageService.setFinder(this);
        Object[] objectArray = new Object[]{this, new Monitor(), object};
        this.dontGC = new AntiGC(objectArray);
        Thread thread = this.getDaemonThread(this.dontGC, "antiGC", true);
        thread.start();
        this.applicationProperties = this.readApplicationProperties();
        Properties properties2 = null;
        Vector vector = this.getImplementations(this.bootProperties, false);
        Vector vector2 = null;
        Vector vector3 = null;
        vector2 = this.getImplementations(properties2, false);
        vector3 = this.getImplementations(this.applicationProperties, false);
        Vector vector4 = this.getDefaultImplementations();
        int n = 0;
        if (vector != null) {
            ++n;
        }
        if (vector2 != null) {
            ++n;
        }
        if (vector3 != null) {
            ++n;
        }
        if (vector4 != null) {
            ++n;
        }
        this.implementationSets = new Vector[n];
        n = 0;
        if (vector != null) {
            this.implementationSets[n++] = vector;
        }
        if (vector2 != null) {
            this.implementationSets[n++] = vector2;
        }
        if (vector3 != null) {
            this.implementationSets[n++] = vector3;
        }
        if (vector4 != null) {
            this.implementationSets[n++] = vector4;
        }
        try {
            this.systemStreams = (InfoStreams)Monitor.startSystemModule("org.apache.derby.iapi.services.stream.InfoStreams");
            this.contextService = new ContextService();
            this.uuidFactory = (UUIDFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.uuid.UUIDFactory");
        }
        catch (StandardException standardException) {
            this.reportException(standardException);
            this.dumpTempWriter(true);
            return;
        }
        this.dumpTempWriter(false);
        this.bootServiceProviders();
        boolean bl = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.system.bootAll"));
        this.startServices(this.bootProperties, bl);
        this.startServices(properties2, bl);
        this.startServices(this.applicationProperties, bl);
        if (bl) {
            this.bootPersistentServices();
        }
    }

    public Object findService(String string, String string2) {
        ProtocolKey protocolKey;
        if (string2 == null) {
            return null;
        }
        try {
            protocolKey = ProtocolKey.create(string, string2);
        }
        catch (StandardException standardException) {
            return null;
        }
        TopService topService = null;
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            int n = 1;
            while (n < this.services.size()) {
                TopService topService2 = (TopService)this.services.elementAt(n);
                if (topService2.isPotentialService(protocolKey)) {
                    topService = topService2;
                    break;
                }
                ++n;
            }
        }
        if (topService != null && topService.isActiveService(protocolKey)) {
            return topService.getService();
        }
        return null;
    }

    public Locale getLocale(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.serviceLocale;
    }

    public Locale getLocaleFromString(String string) throws StandardException {
        return BaseMonitor.staticGetLocaleFromString(string);
    }

    public String getServiceName(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.getServiceType().getUserServiceName(topService.getKey().getIdentifier());
    }

    public Locale setLocale(Object object, String string) throws StandardException {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        PersistentService persistentService = topService.getServiceType();
        if (persistentService == null) {
            return null;
        }
        String string2 = topService.getKey().getIdentifier();
        Properties properties = persistentService.getServiceProperties(string2, null);
        properties = new UpdateServiceProperties(persistentService, string2, properties, true);
        return this.setLocale(properties, string);
    }

    public Locale setLocale(Properties properties, String string) throws StandardException {
        Locale locale = BaseMonitor.staticGetLocaleFromString(string);
        ((Hashtable)properties).put("derby.serviceLocale", locale.toString());
        return locale;
    }

    public PersistentService getServiceType(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.getServiceType();
    }

    public Object startModule(boolean bl, Object object, String string, String string2, Properties properties) throws StandardException {
        ProtocolKey protocolKey = ProtocolKey.create(string, string2);
        TopService topService = this.findTopService(object);
        Object object2 = topService.bootModule(bl, object, protocolKey, properties);
        if (object2 == null) {
            throw Monitor.missingImplementation(string);
        }
        return object2;
    }

    private synchronized TopService findTopService(Object object) {
        if (object == null) {
            return (TopService)this.services.elementAt(0);
        }
        int n = 1;
        while (n < this.services.size()) {
            TopService topService = (TopService)this.services.elementAt(n);
            if (topService.inService(object)) {
                return topService;
            }
            ++n;
        }
        return null;
    }

    public Object findModule(Object object, String string, String string2) {
        ProtocolKey protocolKey;
        try {
            protocolKey = ProtocolKey.create(string, string2);
        }
        catch (StandardException standardException) {
            return null;
        }
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.findModule(protocolKey, true, null);
    }

    public InstanceGetter classFromIdentifier(int n) throws StandardException {
        String string;
        InstanceGetter[] instanceGetterArray;
        int n2;
        try {
            InstanceGetter instanceGetter;
            n2 = n;
            instanceGetterArray = this.rc2;
            if (instanceGetterArray == null) {
                instanceGetterArray = this.rc2 = new InstanceGetter[RegisteredFormatIds.TwoByte.length];
            }
            if ((instanceGetter = instanceGetterArray[n2]) != null) {
                return instanceGetter;
            }
            string = RegisteredFormatIds.TwoByte[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
            instanceGetterArray = null;
            n2 = 0;
        }
        if (string != null) {
            Throwable throwable;
            try {
                Class<?> clazz = Class.forName(string);
                if ((class$Lorg$apache$derby$iapi$services$io$FormatableInstanceGetter != null ? class$Lorg$apache$derby$iapi$services$io$FormatableInstanceGetter : (class$Lorg$apache$derby$iapi$services$io$FormatableInstanceGetter = BaseMonitor.class$("org.apache.derby.iapi.services.io.FormatableInstanceGetter"))).isAssignableFrom(clazz)) {
                    FormatableInstanceGetter formatableInstanceGetter = (FormatableInstanceGetter)clazz.newInstance();
                    formatableInstanceGetter.setFormatId(n);
                    instanceGetterArray[n2] = formatableInstanceGetter;
                    return instanceGetterArray[n2];
                }
                instanceGetterArray[n2] = new ClassInfo(clazz);
                return instanceGetterArray[n2];
            }
            catch (ClassNotFoundException classNotFoundException) {
                throwable = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                throwable = instantiationException;
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            throw StandardException.newException("XBM0V.S", throwable, (Object)FormatIdUtil.formatIdToString(n), (Object)string);
        }
        throw StandardException.newException("XBM0U.S", FormatIdUtil.formatIdToString(n));
    }

    public Object newInstanceFromIdentifier(int n) throws StandardException {
        Throwable throwable;
        InstanceGetter instanceGetter = this.classFromIdentifier(n);
        try {
            Object object = instanceGetter.getNewInstance();
            return object;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw StandardException.newException("XBM0W.S", throwable, (Object)new Integer(n), (Object)"XX");
    }

    protected Object loadInstance(Class clazz, Properties properties) {
        Object object = null;
        Vector vector = this.getImplementations(properties, false);
        if (vector != null) {
            object = this.loadInstance(vector, clazz, properties);
        }
        int n = 0;
        while (n < this.implementationSets.length) {
            object = this.loadInstance(this.implementationSets[n], clazz, properties);
            if (object != null) break;
            ++n;
        }
        return object;
    }

    private Object loadInstance(Vector vector, Class clazz, Properties properties) {
        int n = 0;
        while ((n = BaseMonitor.findImplementation(vector, n, clazz)) >= 0) {
            Object object = this.newInstance((Class)vector.elementAt(n));
            if (BaseMonitor.canSupport(object, properties)) {
                return object;
            }
            ++n;
        }
        return null;
    }

    private static int findImplementation(Vector vector, int n, Class clazz) {
        int n2 = n;
        while (n2 < vector.size()) {
            Class clazz2 = (Class)vector.elementAt(n2);
            if (clazz.isAssignableFrom(clazz2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private Object newInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.report(string + " " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            this.report(string + " " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.report(string + " " + illegalAccessException.toString());
        }
        catch (LinkageError linkageError) {
            this.report(string + " " + linkageError.toString());
            this.reportException(linkageError);
        }
        return null;
    }

    private Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.report(clazz.getName() + " " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.report(clazz.getName() + " " + illegalAccessException.toString());
        }
        catch (LinkageError linkageError) {
            this.report(clazz.getName() + " " + linkageError.toString());
            this.reportException(linkageError);
        }
        return null;
    }

    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    public String[] getServiceList(String string) {
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            TopService topService;
            int n = 0;
            int n2 = 1;
            while (n2 < this.services.size()) {
                topService = (TopService)this.services.elementAt(n2);
                if (topService.isActiveService() && topService.getKey().getFactoryInterface().getName().equals(string)) {
                    ++n;
                }
                ++n2;
            }
            String[] stringArray = new String[n];
            if (n != 0) {
                int n3 = 0;
                int n4 = 1;
                while (n4 < this.services.size()) {
                    topService = (TopService)this.services.elementAt(n4);
                    if (topService.isActiveService() && topService.getKey().getFactoryInterface().getName().equals(string)) {
                        stringArray[n3++] = topService.getServiceType().getUserServiceName(topService.getKey().getIdentifier());
                        if (n3 == n) break;
                    }
                    ++n4;
                }
            }
            String[] stringArray2 = stringArray;
            Object var4_10 = null;
            return stringArray2;
        }
    }

    void dumpProperties(String string, Properties properties) {
    }

    protected void report(String string) {
        PrintWriter printWriter = this.getTempWriter();
        if (printWriter != null) {
            printWriter.println(string);
        }
        if (this.systemStreams != null) {
            this.systemStreams.stream().printlnWithHeader(string);
        }
    }

    protected void reportException(Throwable throwable) {
        PrintWriterGetHeader printWriterGetHeader = null;
        if (this.systemStreams != null) {
            printWriterGetHeader = this.systemStreams.stream().getHeader();
        }
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(printWriterGetHeader);
        errorStringBuilder.appendln(throwable.getMessage());
        errorStringBuilder.stackTrace(throwable);
        this.report(errorStringBuilder.get().toString());
    }

    private void addDebugFlags(String string, boolean bl) {
    }

    public void startServices(Properties properties, boolean bl) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(SERVICE)) continue;
            String string2 = string.substring(SERVICE.length());
            String string3 = properties.getProperty(string);
            try {
                if (string3.equals("serviceDirectory")) {
                    if (!bl) continue;
                    this.startPersistentService(string2, properties, true);
                    continue;
                }
                this.bootService(null, string3, string2, null, false);
            }
            catch (StandardException standardException) {
                if (string3.equals("serviceDirectory")) continue;
                this.reportException(standardException);
            }
        }
    }

    public boolean startPersistentService(String string, Properties properties) throws StandardException {
        return this.startPersistentService(string, properties, false);
    }

    protected boolean startPersistentService(String string, Properties properties, boolean bl) throws StandardException {
        return this.findProviderAndStartService(string, properties, bl);
    }

    public Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        PersistentService persistentService = this.findProviderForCreate(properties, string2);
        if (persistentService == null) {
            throw StandardException.newException("XBM0K.D", string2);
        }
        return this.bootService(persistentService, string, string2, properties, true);
    }

    public void removePersistentService(String string) throws StandardException {
        String string2;
        PersistentService persistentService = null;
        persistentService = this.findProviderForCreate(null, string);
        boolean bl = persistentService.removeServiceRoot(string2 = persistentService.getCanonicalServiceName(string));
        if (!bl) {
            throw StandardException.newException("XBM0I.D", string2);
        }
    }

    public Object startNonPersistentService(String string, String string2, Properties properties) throws StandardException {
        return this.bootService(null, string, string2, properties, false);
    }

    protected Vector getImplementations(Properties properties, boolean bl) {
        if (properties == null) {
            return null;
        }
        Vector vector = bl ? new Vector(((Hashtable)properties).size()) : new Vector(0, 1);
        int n = JVMInfo.JDK_ID;
        int[] nArray = new int[n + 1];
        Enumeration<?> enumeration = properties.propertyNames();
        block9: while (enumeration.hasMoreElements()) {
            Object object;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("derby.module.")) {
                Object object2;
                int n2 = "derby.module.".length();
                string = string2.substring(n2);
                object = "derby.env.jdk.".concat(string);
                String string3 = properties.getProperty((String)object);
                int n3 = 0;
                if (string3 != null && (n3 = Integer.parseInt(string3.trim())) > n) continue;
                object = "derby.env.classes.".concat(string);
                String string4 = properties.getProperty((String)object);
                if (string4 != null) {
                    object2 = new StringTokenizer(string4, ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        try {
                            Class.forName(((StringTokenizer)object2).nextToken().trim());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            continue block9;
                        }
                        catch (LinkageError linkageError) {
                            continue block9;
                        }
                    }
                }
                object2 = properties.getProperty(string2);
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    if (this.getPersistentServiceImplementation(clazz)) continue;
                    if (n3 != 0) {
                        int n4 = 0;
                        int n5 = n;
                        while (n5 > n3) {
                            n4 += nArray[n5];
                            --n5;
                        }
                        vector.insertElementAt(clazz, n4);
                        int n6 = n3;
                        nArray[n6] = nArray[n6] + 1;
                        continue;
                    }
                    vector.addElement(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.report("Class " + (String)object2 + " " + classNotFoundException.toString() + ", module ignored.");
                }
                catch (LinkageError linkageError) {
                    this.report("Class " + (String)object2 + " " + linkageError.toString() + ", module ignored.");
                }
                continue;
            }
            if (!string2.startsWith("derby.subSubProtocol.")) continue;
            String string5 = string2.substring("derby.subSubProtocol.".length());
            string = properties.getProperty(string2);
            try {
                object = Class.forName(string);
                if (this.getPersistentServiceImplementation((Class)object) || !(class$Lorg$apache$derby$io$StorageFactory != null ? class$Lorg$apache$derby$io$StorageFactory : BaseMonitor.class$("org.apache.derby.io.StorageFactory")).isAssignableFrom((Class<?>)object)) continue;
                if (this.newInstance((Class)object) == null) {
                    this.report("Class " + string + " cannot create instance, StorageFactory ignored.");
                    continue;
                }
                storageFactories.put(string5, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.report("Class " + string + " " + classNotFoundException.toString() + ", module ignored.");
            }
            catch (LinkageError linkageError) {
                this.report("Class " + string + " " + linkageError.toString() + ", module ignored.");
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        vector.trimToSize();
        return vector;
    }

    private boolean getPersistentServiceImplementation(Class clazz) {
        if (!(class$Lorg$apache$derby$iapi$services$monitor$PersistentService != null ? class$Lorg$apache$derby$iapi$services$monitor$PersistentService : (class$Lorg$apache$derby$iapi$services$monitor$PersistentService = BaseMonitor.class$("org.apache.derby.iapi.services.monitor.PersistentService"))).isAssignableFrom(clazz)) {
            return false;
        }
        PersistentService persistentService = (PersistentService)this.newInstance(clazz);
        if (persistentService == null) {
            this.report("Class " + clazz.getName() + " cannot create instance, module ignored.");
        } else {
            if (this.serviceProviders == null) {
                this.serviceProviders = new Hashtable(3, 1.0f);
            }
            this.serviceProviders.put(persistentService.getType(), persistentService);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    protected Vector getDefaultImplementations() {
        Properties properties = new Properties();
        boolean bl = true;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("org/apache/derby/modules.properties");
            while (enumeration.hasMoreElements()) {
                Serializable serializable2222;
                InputStream inputStream;
                block16: {
                    URL uRL = enumeration.nextElement();
                    inputStream = null;
                    inputStream = this.loadModuleDefinitions(uRL);
                    if (bl) {
                        properties.load(inputStream);
                        bl = false;
                        break block16;
                    }
                    serializable2222 = new Properties();
                    ((Properties)serializable2222).load(inputStream);
                    Enumeration enumeration2 = ((Hashtable)serializable2222).keys();
                    while (enumeration2.hasMoreElements()) {
                        String string = (String)enumeration2.nextElement();
                        if (((Hashtable)properties).contains(string)) {
                            this.report("Ignored duplicate property " + string + " in " + uRL.toString());
                            continue;
                        }
                        properties.setProperty(string, ((Properties)serializable2222).getProperty(string));
                    }
                }
                Object var8_8 = null;
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException serializable2222) {}
                continue;
                {
                    catch (IOException iOException) {
                        var8_8 = null;
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException serializable2222) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException serializable2222) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            return null;
        }
        return this.getImplementations(properties, true);
    }

    protected InputStream loadModuleDefinitions(URL uRL) throws IOException {
        return uRL.openStream();
    }

    protected static Properties removeRuntimeProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("derby.__rt.")) continue;
            ((Hashtable)properties2).put(string, ((Hashtable)properties).get(string));
        }
        return properties2;
    }

    protected abstract InputStream applicationPropertiesStream() throws IOException;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Properties readApplicationProperties() {
        block13: {
            block12: {
                var1_1 = null;
                try {
                    try {
                        var1_1 = this.applicationPropertiesStream();
                        if (var1_1 == null) {
                            var4_2 = null;
                            var3_6 = null;
                            break block12;
                        }
                        var5_12 /* !! */  = new Properties();
                        org.apache.derby.iapi.util.PropertyUtil.loadWithTrimmedValues(new BufferedInputStream(var1_1), var5_12 /* !! */ );
                        var4_3 = var5_12 /* !! */ ;
                        break block13;
                    }
                    catch (SecurityException var5_13) {
                        var4_4 = null;
                        var3_8 = null;
                        try {
                            if (var1_1 == null) return var4_4;
                            var1_1.close();
                            return var4_4;
                        }
                        catch (IOException var5_14) {
                            // empty catch block
                        }
                        return var4_4;
                    }
                    catch (IOException var5_15) {
                        this.report(var5_15.toString() + " (" + "derby.properties" + ")");
                        this.reportException(var5_15);
                        var4_5 = null;
                        var3_9 = null;
                        ** try [egrp 2[TRYBLOCK] [3 : 127->140)] { 
lbl33:
                        // 1 sources

                        if (var1_1 == null) return var4_5;
                        var1_1.close();
                        return var4_5;
lbl36:
                        // 1 sources

                        catch (IOException var5_16) {
                            // empty catch block
                        }
                        return var4_5;
                    }
                }
                catch (Throwable var2_18) {
                    var3_10 = null;
                    try {}
                    catch (IOException var5_17) {
                        throw var2_18;
                    }
                    if (var1_1 == null) throw var2_18;
                    var1_1.close();
                    var1_1 = null;
                    throw var2_18;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 127->140)] { 
lbl51:
            // 1 sources

            if (var1_1 == null) return var4_2;
            var1_1.close();
            return var4_2;
lbl54:
            // 1 sources

            catch (IOException var5_11) {
                // empty catch block
            }
            return var4_2;
        }
        var3_7 = null;
        ** try [egrp 2[TRYBLOCK] [3 : 127->140)] { 
lbl60:
        // 1 sources

        if (var1_1 == null) return var4_3;
        var1_1.close();
        return var4_3;
lbl63:
        // 1 sources

        catch (IOException var5_12 /* !! */ ) {
            // empty catch block
        }
        return var4_3;
    }

    protected void bootServiceProviders() {
        if (this.serviceProviders == null) {
            return;
        }
        Enumeration enumeration = this.serviceProviders.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.serviceProviders.get(string);
            if (BaseMonitor.canSupport(v, null)) continue;
            this.serviceProviders.remove(string);
        }
    }

    protected void bootPersistentServices() {
        ProviderEnumeration providerEnumeration = new ProviderEnumeration(this.applicationProperties);
        while (true) {
            PersistentService persistentService = (PersistentService)providerEnumeration.nextElement();
            this.bootProviderServices(persistentService);
        }
    }

    protected void bootProviderServices(PersistentService persistentService) {
        Enumeration enumeration = persistentService.getBootTimeServices();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Properties properties;
            String string = (String)enumeration.nextElement();
            try {
                properties = persistentService.getServiceProperties(string, null);
            }
            catch (StandardException standardException) {
                this.report("Failed to load service properties, name: " + string + ", type = " + persistentService.getType());
                this.reportException(standardException);
                continue;
            }
            if (Boolean.valueOf(properties.getProperty("derby.database.noAutoBoot")).booleanValue()) continue;
            try {
                this.startProviderService(persistentService, string, properties);
            }
            catch (StandardException standardException) {
                this.report("Service failed to boot, name: " + string + ", type = " + persistentService.getType());
                this.reportException(standardException);
            }
        }
    }

    protected boolean findProviderAndStartService(String string, Properties properties, boolean bl) throws StandardException {
        PersistentService persistentService = null;
        Properties properties2 = null;
        String string2 = null;
        int n = string.indexOf(58);
        if (n != -1 && (persistentService = this.findProviderFromName(properties, string, n)) != null) {
            string2 = persistentService.getCanonicalServiceName(string);
            if (string2 == null) {
                return true;
            }
            properties2 = persistentService.getServiceProperties(string2, properties);
            if (properties2 == null) {
                return true;
            }
            if (bl && Boolean.valueOf(properties2.getProperty("derby.database.noAutoBoot")).booleanValue()) {
                return true;
            }
            this.startProviderService(persistentService, string2, properties2);
            return true;
        }
        StandardException standardException = null;
        ProviderEnumeration providerEnumeration = new ProviderEnumeration(properties);
        while (providerEnumeration.hasMoreElements()) {
            PersistentService persistentService2 = (PersistentService)providerEnumeration.nextElement();
            String string3 = persistentService2.getCanonicalServiceName(string);
            if (string3 == null) continue;
            Properties properties3 = null;
            try {
                properties3 = persistentService2.getServiceProperties(string3, properties);
                if (properties3 == null) {
                    continue;
                }
            }
            catch (StandardException standardException2) {
                standardException = standardException2;
            }
            if (persistentService == null) {
                persistentService = persistentService2;
                string2 = string3;
                properties2 = properties3;
                continue;
            }
            throw StandardException.newException("XBM0T.D", string);
        }
        if (persistentService == null) {
            return n == -1;
        }
        if (standardException != null) {
            throw standardException;
        }
        if (bl && Boolean.valueOf(properties2.getProperty("derby.database.noAutoBoot")).booleanValue()) {
            return true;
        }
        this.startProviderService(persistentService, string2, properties2);
        return true;
    }

    protected PersistentService findProvider() throws StandardException {
        return this.findProviderForCreate(null, "");
    }

    protected PersistentService findProviderForCreate(Properties properties, String string) throws StandardException {
        return this.findProviderFromName(properties, string, string.indexOf(58));
    }

    private PersistentService findProviderFromName(Properties properties, String string, int n) throws StandardException {
        if (n == 0) {
            return null;
        }
        String string2 = n < 2 ? "directory" : string.substring(0, n);
        return this.getServiceProvider(properties, string2);
    }

    public PersistentService getServiceProvider(Properties properties, String string) throws StandardException {
        PersistentService persistentService;
        if (string == null) {
            return null;
        }
        if (this.serviceProviders != null && (persistentService = (PersistentService)this.serviceProviders.get(string)) != null) {
            return persistentService;
        }
        return this.getPersistentService(properties, string);
    }

    private PersistentService getPersistentService(Properties properties, String string) throws StandardException {
        String string2 = this.getStorageFactoryClassName(properties, string);
        return this.getPersistentService(string2, string);
    }

    private PersistentService getPersistentService(String string, String string2) throws StandardException {
        if (string == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XBM08.D", throwable, (Object)string2, (Object)string);
        }
        return new PersistentServiceImpl(string2, clazz);
    }

    private String getStorageFactoryClassName(Properties properties, String string) {
        String string2 = "derby.subSubProtocol." + string;
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty(string2);
        }
        if (string3 == null) {
            string3 = PropertyUtil.getSystemProperty(string2);
        }
        if (string3 != null) {
            return string3;
        }
        return (String)storageFactories.get(string);
    }

    protected void startProviderService(PersistentService persistentService, String string, Properties properties) throws StandardException {
        String string2 = properties.getProperty("derby.serviceProtocol");
        if (string2 == null) {
            throw StandardException.newException("XCY03.S", "derby.serviceProtocol");
        }
        this.bootService(persistentService, string2, string, properties, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object bootService(PersistentService persistentService, String string, String string2, Properties properties, boolean bl) throws StandardException {
        Object object;
        ContextManager contextManager;
        if (persistentService != null) {
            string2 = persistentService.getCanonicalServiceName(string2);
        }
        ProtocolKey protocolKey = ProtocolKey.create(string, string2);
        ContextManager contextManager2 = contextManager = this.contextService.getCurrentContextManager();
        TopService topService = null;
        Context context = null;
        try {
            try {
                boolean bl2;
                Object object2;
                Cloneable cloneable;
                block35: {
                    Object var17_18;
                    block34: {
                        BaseMonitor baseMonitor = this;
                        synchronized (baseMonitor) {
                            block33: {
                                if (this.inShutdown) {
                                    throw StandardException.newException("XJ015.M");
                                }
                                int n = 1;
                                while (true) {
                                    if (n >= this.services.size()) {
                                        cloneable = null;
                                        if (!bl) break;
                                        properties = new Properties(properties);
                                        cloneable = BaseMonitor.setLocale(properties);
                                        ((Hashtable)properties).put("derby.serviceProtocol", string);
                                        string2 = persistentService.createServiceRoot(string2, Boolean.valueOf(properties.getProperty("derby.__deleteOnCreate")));
                                        protocolKey = ProtocolKey.create(string, string2);
                                        break block33;
                                    }
                                    object2 = (TopService)this.services.elementAt(n);
                                    if (((TopService)object2).isPotentialService(protocolKey)) {
                                        var17_18 = null;
                                        Object var16_19 = null;
                                        break block34;
                                    }
                                    ++n;
                                }
                                if (properties != null && (object2 = properties.getProperty("derby.serviceLocale")) != null) {
                                    cloneable = BaseMonitor.staticGetLocaleFromString((String)object2);
                                }
                            }
                            topService = new TopService(this, protocolKey, persistentService, (Locale)cloneable);
                            this.services.addElement(topService);
                            break block35;
                        }
                    }
                    Object var14_21 = var17_18;
                    Object var13_22 = null;
                    if (contextManager == contextManager2 && context != null) {
                        context.popMe();
                    }
                    if (contextManager == null) {
                        this.contextService.resetCurrentContextManager(contextManager2);
                    }
                    return var14_21;
                }
                if (properties != null) {
                    ((Hashtable)properties).put("derby.__rt.serviceDirectory", string2);
                    ((Hashtable)properties).put("derby.__rt.serviceType", persistentService.getType());
                }
                if (contextManager == null) {
                    contextManager2 = this.contextService.newContextManager();
                    this.contextService.setCurrentContextManager(contextManager2);
                }
                context = new ServiceBootContext(contextManager2);
                boolean bl3 = properties != null ? properties.getProperty("derby.__rt.inRestore") != null : (bl2 = false);
                if (persistentService != null && properties != null) {
                    cloneable = new UpdateServiceProperties(persistentService, string2, properties, !(bl || bl2));
                    object2 = cloneable;
                } else {
                    cloneable = null;
                    object2 = properties;
                }
                object = topService.bootModule(bl, null, protocolKey, (Properties)object2);
                if (bl || bl2) {
                    persistentService.saveServiceProperties(string2, ((UpdateServiceProperties)cloneable).getStorageFactory(), BaseMonitor.removeRuntimeProperties(properties), false);
                    ((UpdateServiceProperties)cloneable).setServiceBooted();
                }
            }
            catch (Throwable throwable) {
                Object object3;
                StandardException standardException;
                if (!(throwable instanceof StandardException) || ((StandardException)throwable).getSeverity() != 45000) {
                    standardException = Monitor.exceptionStartingModule(throwable);
                }
                if (contextManager2 != contextManager) {
                    contextManager2.cleanupOnError(standardException);
                }
                if (topService != null) {
                    boolean bl4;
                    topService.shutdown();
                    object3 = this;
                    synchronized (object3) {
                        this.services.removeElement(topService);
                    }
                    boolean bl5 = properties != null ? properties.getProperty("derby.__rt.deleteRootOnError") != null : (bl4 = false);
                    if (bl || bl4) {
                        persistentService.removeServiceRoot(string2);
                    }
                }
                if ((object3 = standardException.getNestedException()) instanceof ThreadDeath) {
                    throw (ThreadDeath)((Object)standardException);
                }
                if (object3 instanceof StandardException) {
                    throw standardException;
                }
                throw standardException;
            }
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            if (contextManager == contextManager2 && context != null) {
                context.popMe();
            }
            if (contextManager == null) {
                this.contextService.resetCurrentContextManager(contextManager2);
            }
            throw throwable;
        }
        Object var13_23 = null;
        if (contextManager == contextManager2 && context != null) {
            context.popMe();
        }
        if (contextManager == null) {
            this.contextService.resetCurrentContextManager(contextManager2);
        }
        topService.setTopModule(object);
        Thread.yield();
        return object;
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    private PrintWriter getTempWriter() {
        if (this.tmpWriter == null && !this.dumpedTempWriter) {
            this.tmpArray = new AccessibleByteArrayOutputStream();
            this.tmpWriter = new PrintWriter(this.tmpArray);
        }
        return this.tmpWriter;
    }

    private void dumpTempWriter(boolean bl) {
        if (this.tmpWriter == null) {
            return;
        }
        this.tmpWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.tmpArray.getInternalByteArray())));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (this.systemStreams != null) {
                    this.systemStreams.stream().printlnWithHeader(string);
                }
                if (this.systemStreams != null && !bl) continue;
                this.logging.println(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.systemStreams == null || bl) {
            this.logging.flush();
        }
        this.tmpWriter = null;
        this.tmpArray = null;
        this.dumpedTempWriter = true;
        this.logging = null;
    }

    static boolean canSupport(Object object, Properties properties) {
        return !(object instanceof ModuleSupportable) || ((ModuleSupportable)object).canSupport(properties);
    }

    static void boot(Object object, boolean bl, Properties properties) throws StandardException {
        if (object instanceof ModuleControl) {
            ((ModuleControl)object).boot(bl, properties);
        }
    }

    private static Locale staticGetLocaleFromString(String string) throws StandardException {
        String string2;
        boolean bl;
        int n = string.length();
        boolean bl2 = bl = n == 2 || n == 5 || n > 6;
        if (bl && n != 2) {
            boolean bl3 = bl = string.charAt(2) == '_';
        }
        if (bl && n > 5) {
            boolean bl4 = bl = string.charAt(5) == '_';
        }
        if (!bl) {
            throw StandardException.newException("XBM0X.D", string);
        }
        String string3 = string.substring(0, 2);
        String string4 = string2 = n == 2 ? "" : string.substring(3, 5);
        if (n < 6) {
            return new Locale(string3, string2);
        }
        String string5 = n > 6 ? string.substring(6, n) : null;
        return new Locale(string3, string2, string5);
    }

    private static Locale setLocale(Properties properties) throws StandardException {
        String string = properties.getProperty("territory");
        Locale locale = string == null ? Locale.getDefault() : BaseMonitor.staticGetLocaleFromString(string);
        ((Hashtable)properties).put("derby.serviceLocale", locale.toString());
        return locale;
    }

    public ResourceBundle getBundle(String string) {
        ContextManager contextManager;
        try {
            contextManager = ContextService.getFactory().getCurrentContextManager();
        }
        catch (ShutdownException shutdownException) {
            contextManager = null;
        }
        if (contextManager != null) {
            return MessageService.getBundleForLocale(contextManager.getMessageLocale(), string);
        }
        return null;
    }

    public Thread getDaemonThread(Runnable runnable, String string, boolean bl) {
        Thread thread = new Thread(this.daemonGroup, runnable, "derby.".concat(string));
        thread.setDaemon(true);
        if (bl) {
            thread.setPriority(1);
        }
        return thread;
    }

    public void setThreadPriority(int n) {
        Thread thread = Thread.currentThread();
        if (thread.getThreadGroup() == this.daemonGroup) {
            thread.setPriority(n);
        }
    }

    public abstract boolean initialize(boolean var1);

    public abstract Object getEnvironment();

    public abstract String getJVMProperty(String var1);

    public abstract ProductVersionHolder getEngineVersion();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BaseMonitor() {
        this.services.addElement(new TopService(this));
    }

    static {
        String string = JVMInfo.JDK_ID >= 4 ? "org.apache.derby.impl.io.DirStorageFactory4" : "org.apache.derby.impl.io.DirStorageFactory";
        storageFactories.put("directory", string);
        storageFactories.put("classpath", "org.apache.derby.impl.io.CPStorageFactory");
        storageFactories.put("jar", "org.apache.derby.impl.io.JarStorageFactory");
        storageFactories.put("http", "org.apache.derby.impl.io.URLStorageFactory");
        storageFactories.put("https", "org.apache.derby.impl.io.URLStorageFactory");
    }

    class ProviderEnumeration
    implements Enumeration {
        private Enumeration serviceProvidersKeys;
        private Properties startParams;
        private Enumeration paramEnumeration;
        private boolean enumeratedDirectoryProvider;
        private PersistentService storageFactoryPersistentService;

        public Object nextElement() throws NoSuchElementException {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return BaseMonitor.this.serviceProviders.get(this.serviceProvidersKeys.nextElement());
            }
            this.getNextStorageFactory();
            PersistentService persistentService = this.storageFactoryPersistentService;
            this.storageFactoryPersistentService = null;
            return persistentService;
        }

        private void getNextStorageFactory() {
            if (this.storageFactoryPersistentService != null) {
                return;
            }
            if (this.paramEnumeration != null) {
                while (this.paramEnumeration.hasMoreElements()) {
                    String string = (String)this.paramEnumeration.nextElement();
                    if (!string.startsWith("derby.subSubProtocol.")) continue;
                    try {
                        String string2 = (String)((Hashtable)this.startParams).get(string);
                        if (string2 == null) continue;
                        this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService((String)((Hashtable)this.startParams).get(string), string.substring("derby.subSubProtocol.".length()));
                        if (this.storageFactoryPersistentService == null) continue;
                        return;
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                }
            }
            if (!this.enumeratedDirectoryProvider) {
                try {
                    this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService(BaseMonitor.this.getStorageFactoryClassName(null, "directory"), "directory");
                }
                catch (StandardException standardException) {
                    this.storageFactoryPersistentService = null;
                }
                this.enumeratedDirectoryProvider = true;
            }
        }

        public boolean hasMoreElements() {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return true;
            }
            this.getNextStorageFactory();
            return this.storageFactoryPersistentService != null;
        }

        ProviderEnumeration(Properties properties) {
            this.serviceProvidersKeys = BaseMonitor.this.serviceProviders == null ? null : BaseMonitor.this.serviceProviders.keys();
            this.startParams = properties;
            if (properties != null) {
                this.paramEnumeration = ((Hashtable)properties).keys();
            }
        }
    }
}

