/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLNClob
extends SQLNationalVarchar {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";

    public String getTypeName() {
        return "NCLOB";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLNClob(this.getString(), this.getLocaleFinder());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        SQLNClob sQLNClob = new SQLNClob();
        sQLNClob.setLocaleFinder(this.getLocaleFinder());
        return sQLNClob;
    }

    public int getTypeFormatId() {
        return 450;
    }

    public Date getDate(Calendar calendar) throws StandardException {
        return this.nationalGetDate(calendar);
    }

    public Time getTime(Calendar calendar) throws StandardException {
        return this.nationalGetTime(calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        return this.nationalGetTimestamp(calendar);
    }

    public int typePrecedence() {
        return 13;
    }

    protected int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        return sQLChar.stringCollatorCompare(sQLChar2);
    }

    protected StringDataValue getNewVarchar() {
        return new SQLNationalVarchar();
    }

    protected boolean isNationalString() {
        return true;
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.setValue(this.getDateFormat(calendar).format(date));
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.setValue(this.getTimeFormat(calendar).format(time));
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.setValue(this.getTimestampFormat(calendar).format(timestamp));
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(((DataType)dataValueDescriptor).getNationalString(this.getLocaleFinder()));
    }

    public int hashCode() {
        return this.nationalHashCode();
    }

    public SQLNClob() {
    }

    public SQLNClob(String string, LocaleFinder localeFinder) {
        super(string, localeFinder);
    }
}

