/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.xact.TransactionId;

public class XactId
implements TransactionId {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private long id;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.id);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.id = CompressedNumber.readLong(objectInput);
    }

    public int getTypeFormatId() {
        return 147;
    }

    public int getMaxStoredSize() {
        return FormatIdUtil.getFormatIdByteLength(147) + 8;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            XactId xactId = (XactId)object;
            return this.id == xactId.id;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public static long compare(TransactionId transactionId, TransactionId transactionId2) {
        if (transactionId == null || transactionId2 == null) {
            if (transactionId == null) {
                return -1L;
            }
            if (transactionId2 == null) {
                return 1L;
            }
            return 0L;
        }
        XactId xactId = (XactId)transactionId;
        XactId xactId2 = (XactId)transactionId2;
        return xactId.id - xactId2.id;
    }

    protected long getId() {
        return this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }

    public XactId(long l) {
        this.id = l;
    }

    public XactId() {
    }
}

