/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;

public final class RecordId
implements RecordHandle {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private final PageKey pageId;
    private final int recordId;
    private transient int slotNumberHint;

    public int getId() {
        return this.recordId;
    }

    public long getPageNumber() {
        return this.pageId.getPageNumber();
    }

    public Object getPageId() {
        return this.pageId;
    }

    public ContainerKey getContainerId() {
        return this.pageId.getContainerId();
    }

    public int getSlotNumberHint() {
        return this.slotNumberHint;
    }

    public void lockEvent(Latch latch) {
    }

    public boolean requestCompatible(Object object, Object object2) {
        RowLock rowLock = (RowLock)object;
        RowLock rowLock2 = (RowLock)object2;
        return rowLock.isCompatible(rowLock2);
    }

    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public void unlockEvent(Latch latch) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordId)) {
            return false;
        }
        RecordId recordId = (RecordId)object;
        return this.recordId == recordId.recordId && this.pageId.equals(recordId.pageId);
    }

    public int hashCode() {
        return this.recordId ^ this.pageId.hashCode();
    }

    public String toString() {
        return null;
    }

    public boolean lockAttributes(int n, Hashtable hashtable) {
        if ((n & 2) == 0) {
            return false;
        }
        hashtable.put("CONTAINERID", new Long(this.pageId.getContainerId().getContainerId()));
        hashtable.put("LOCKNAME", "(" + this.pageId.getPageNumber() + "," + this.recordId + ")");
        hashtable.put("TYPE", "ROW");
        return true;
    }

    public RecordId(ContainerKey containerKey, long l, int n) {
        this.pageId = new PageKey(containerKey, l);
        this.recordId = n;
    }

    public RecordId(PageKey pageKey, int n) {
        this.pageId = pageKey;
        this.recordId = n;
    }

    public RecordId(PageKey pageKey, int n, int n2) {
        this.pageId = pageKey;
        this.recordId = n;
        this.slotNumberHint = n2;
    }
}

