/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class IsNullNode
extends UnaryComparisonOperatorNode
implements RelationalOperator {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    Object nullValue = null;

    public void setNodeType(int n) {
        String string;
        String string2;
        if (n == 25) {
            string2 = "is null";
            string = "isNullOp";
        } else {
            string2 = "is not null";
            string = "isNotNull";
        }
        this.setOperator(string2);
        this.setMethodName(string);
        super.setNodeType(n);
    }

    UnaryOperatorNode getNegation(ValueNode valueNode) throws StandardException {
        if (this.isNullNode()) {
            this.setNodeType(24);
        } else {
            this.setNodeType(25);
        }
        return this;
    }

    void bindParameter() throws StandardException {
        ((ParameterNode)this.operand).setDescriptor(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
    }

    public boolean usefulStartKey(Optimizable optimizable) {
        return this.isNullNode();
    }

    public boolean usefulStopKey(Optimizable optimizable) {
        return this.isNullNode();
    }

    public int getStartOperator(Optimizable optimizable) {
        return 1;
    }

    public int getStopOperator(Optimizable optimizable) {
        return -1;
    }

    public void generateOperator(MethodBuilder methodBuilder, Optimizable optimizable) {
        methodBuilder.push(2);
    }

    public void generateNegate(MethodBuilder methodBuilder, Optimizable optimizable) {
        methodBuilder.push(this.isNotNullNode());
    }

    public int getOperator() {
        int n = this.isNullNode() ? 7 : 8;
        return n;
    }

    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl) {
        return true;
    }

    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        if (this.nullValue == null) {
            this.nullValue = this.operand.getTypeId().getNull();
        }
        return (DataValueDescriptor)this.nullValue;
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        boolean bl = false;
        if (this.isNotNullNode()) {
            return false;
        }
        if (this.operand instanceof ColumnReference) {
            int n = ((ColumnReference)this.operand).getTableNumber();
            if (optimizable.hasTableNumber() && optimizable.getTableNumber() == n) {
                bl = true;
            }
        }
        return bl;
    }

    public RelationalOperator getTransitiveSearchClause(ColumnReference columnReference) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), columnReference, this.getContextManager()));
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    public double selectivity(Optimizable optimizable) {
        if (this.isNullNode()) {
            return 0.1;
        }
        return 0.9;
    }

    private boolean isNullNode() {
        return this.getNodeType() == 25;
    }

    private boolean isNotNullNode() {
        return this.getNodeType() == 24;
    }

    public boolean isRelationalOperator() {
        return true;
    }

    public boolean optimizableEqualityNode(Optimizable optimizable, int n, boolean bl) {
        if (!this.isNullNode() || !bl) {
            return false;
        }
        ColumnReference columnReference = this.getColumnOperand(optimizable, n);
        return columnReference != null;
    }
}

