/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedResultSet
extends ConnectionChild
implements java.sql.ResultSet,
Comparable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    protected ExecRow currentRow;
    private DataValueDescriptor[] rowData;
    protected boolean wasNull;
    protected boolean isClosed;
    private Object currentStream;
    protected ResultSet theResults;
    private boolean forMetaData;
    private ResultSetMetaData rMetaData;
    private SQLWarning topWarning;
    Activation finalizeActivation;
    final int order;
    private final ResultDescription resultDescription;
    private final int[] jdbcColumnTypes;
    private int maxRows;
    private int maxFieldSize;
    private int NumberofFetchedRows;
    protected final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    protected final boolean isAtomic;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.finalizeActivation != null) {
            this.finalizeActivation.markUnused();
        }
    }

    protected final DataValueDescriptor[] checkOnRow() throws SQLException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowData;
        if (dataValueDescriptorArray == null) {
            throw this.newSQLException("24000");
        }
        return dataValueDescriptorArray;
    }

    protected int getColumnType(int n) throws SQLException {
        this.checkOnRow();
        if (n < 1 || n >= this.jdbcColumnTypes.length) {
            throw this.newSQLException("S0022", new Integer(n));
        }
        return this.jdbcColumnTypes[n];
    }

    public boolean next() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int n, String string) throws SQLException {
        return this.movePosition(n, 0, string);
    }

    protected boolean movePosition(int n, int n2, String string) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            boolean bl2;
            this.setupContextStack();
            try {
                boolean bl3;
                Object object2;
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                try {
                    object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSQLText(), this.getParameterValueSet(), false);
                    switch (n) {
                        case 5: {
                            this.currentRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            this.currentRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            this.currentRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            this.currentRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            this.currentRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            this.currentRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            this.currentRow = this.theResults.getAbsoluteRow(n2);
                            break;
                        }
                        case 8: {
                            this.currentRow = this.theResults.getRelativeRow(n2);
                            break;
                        }
                    }
                    languageConnectionContext.popStatementContext((StatementContext)object2, null);
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
                object2 = this.theResults.getWarnings();
                if (object2 != null) {
                    if (this.topWarning == null) {
                        this.topWarning = object2;
                    } else {
                        this.topWarning.setNextWarning((SQLWarning)object2);
                    }
                }
                boolean bl4 = bl3 = this.currentRow != null;
                if (!(bl3 || n != 2 || this.forMetaData && languageConnectionContext.getActivationCount() > 1 || this.owningStmt == null)) {
                    this.owningStmt.resultSetClosing(this);
                }
                this.rowData = bl3 ? this.currentRow.getRowArray() : null;
                bl2 = bl3;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            {
                bl = bl2;
            }
            Object var5_13 = null;
            return bl;
        }
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            block12: {
                try {
                    this.setupContextStack();
                }
                catch (SQLException sQLException) {
                    Object var2_4 = null;
                    return;
                }
                try {
                    try {
                        this.theResults.finish();
                    }
                    catch (Throwable throwable) {
                        throw this.handleException(throwable);
                    }
                    if (this.forMetaData) {
                        LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                        if (languageConnectionContext.getActivationCount() <= 1 && this.owningStmt != null) {
                            this.owningStmt.resultSetClosing(this);
                        }
                        break block12;
                    }
                    if (this.owningStmt == null) break block12;
                    this.owningStmt.resultSetClosing(this);
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.isClosed = true;
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            Object var4_7 = null;
            this.isClosed = true;
            this.restoreContextStack();
            this.currentRow = null;
            this.rowData = null;
            this.rMetaData = null;
        }
    }

    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    public final String getString(int n) throws SQLException {
        try {
            String string;
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            int n2 = this.jdbcColumnTypes[n];
            if (n2 == 1111 || n2 == 2000) {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    this.setupContextStack();
                    try {
                        string = dataValueDescriptor.getString();
                    }
                    finally {
                        Object var9_7 = null;
                        this.restoreContextStack();
                    }
                }
            }
            string = dataValueDescriptor.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n2) && string.length() > this.maxFieldSize) {
                string = string.substring(0, this.maxFieldSize);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final boolean getBoolean(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return false;
            }
            return dataValueDescriptor.getBoolean();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte getByte(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getByte();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final short getShort(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getShort();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final int getInt(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getInt();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final long getLong(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dataValueDescriptor.getLong();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final float getFloat(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dataValueDescriptor.getFloat();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final double getDouble(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dataValueDescriptor.getDouble();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte[] getBytes(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] byArray = dataValueDescriptor.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.jdbcColumnTypes[n]) && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = new byte[this.maxFieldSize];
                System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public final Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getDate(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumnName(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTime(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumnName(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTimestamp(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Reader getCharacterStream(int n) throws SQLException {
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2005: {
                n2 = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16BE");
                    this.currentStream = inputStreamReader;
                    return inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            UTF8Reader uTF8Reader;
            boolean bl;
            block22: {
                StringReader stringReader;
                block21: {
                    Reader reader;
                    block20: {
                        bl = false;
                        try {
                            try {
                                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                                this.wasNull = dataValueDescriptor.isNull();
                                if (this.wasNull) {
                                    reader = null;
                                    Object var10_15 = null;
                                    if (!bl) {
                                        return reader;
                                    }
                                    break block20;
                                }
                                bl = true;
                                this.setupContextStack();
                                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                                InputStream inputStream = streamStorable.returnStream();
                                if (inputStream == null) {
                                    String string = dataValueDescriptor.getString();
                                    if (n2 > 0 && string.length() > n2) {
                                        string = string.substring(0, n2);
                                    }
                                    StringReader stringReader2 = new StringReader(string);
                                    this.currentStream = stringReader2;
                                    stringReader = stringReader2;
                                    break block21;
                                }
                                UTF8Reader uTF8Reader2 = new UTF8Reader(inputStream, n2, this, object);
                                this.currentStream = uTF8Reader2;
                                uTF8Reader = uTF8Reader2;
                                break block22;
                            }
                            catch (Throwable throwable) {
                                throw EmbedResultSet.noStateChangeException(throwable);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            if (!bl) throw throwable;
                            this.restoreContextStack();
                            throw throwable;
                        }
                    }
                    this.restoreContextStack();
                    return reader;
                }
                Object var10_16 = null;
                if (!bl) return stringReader;
                this.restoreContextStack();
                return stringReader;
            }
            Object var10_17 = null;
            if (!bl) return uTF8Reader;
            this.restoreContextStack();
            return uTF8Reader;
        }
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(n);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", n);
            }
        }
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream getBinaryStream(int n) throws SQLException {
        int n2;
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2004: {
                n2 = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", n);
            }
        }
        Object object = this.getConnectionSynchronization();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            InputStream inputStream;
            boolean bl;
            block16: {
                InputStream inputStream2;
                block15: {
                    bl = false;
                    try {
                        try {
                            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                            this.wasNull = dataValueDescriptor.isNull();
                            if (this.wasNull) {
                                inputStream2 = null;
                                Object var10_11 = null;
                                if (!bl) {
                                    return inputStream2;
                                }
                                break block15;
                            }
                            bl = true;
                            this.setupContextStack();
                            StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                            InputStream inputStream3 = streamStorable.returnStream();
                            inputStream3 = inputStream3 == null ? new NewByteArrayInputStream(dataValueDescriptor.getBytes()) : new BinaryToRawStream(inputStream3, dataValueDescriptor);
                            if (n2 > 0) {
                                LimitInputStream limitInputStream = new LimitInputStream(inputStream3);
                                limitInputStream.setLimit(n2);
                                inputStream3 = limitInputStream;
                            }
                            this.currentStream = inputStream3;
                            inputStream = inputStream3;
                            break block16;
                        }
                        catch (Throwable throwable) {
                            throw EmbedResultSet.noStateChangeException(throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (!bl) throw throwable;
                        this.restoreContextStack();
                        throw throwable;
                    }
                }
                this.restoreContextStack();
                return inputStream2;
            }
            Object var10_12 = null;
            if (!bl) return inputStream;
            this.restoreContextStack();
            return inputStream;
        }
    }

    public final String getString(String string) throws SQLException {
        return this.getString(this.findColumnName(string));
    }

    public final boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumnName(string));
    }

    public final byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumnName(string));
    }

    public final short getShort(String string) throws SQLException {
        return this.getShort(this.findColumnName(string));
    }

    public final int getInt(String string) throws SQLException {
        return this.getInt(this.findColumnName(string));
    }

    public final long getLong(String string) throws SQLException {
        return this.getLong(this.findColumnName(string));
    }

    public final float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumnName(string));
    }

    public final double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumnName(string));
    }

    public final byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumnName(string));
    }

    public final Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumnName(string));
    }

    public final Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumnName(string));
    }

    public final Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumnName(string));
    }

    public final Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumnName(string));
    }

    public final InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumnName(string));
    }

    public final InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumnName(string));
    }

    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rMetaData == null) {
                this.rMetaData = this.newEmbedResultSetMetaData(this.resultDescription);
            }
            ResultSetMetaData resultSetMetaData = this.rMetaData;
            Object var2_3 = null;
            return resultSetMetaData;
        }
    }

    public final Object getObject(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getObject();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumnName(string));
    }

    public final int findColumn(String string) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(string);
    }

    protected int findColumnName(String string) throws SQLException {
        if (string == null) {
            throw this.newSQLException("XJ018.S");
        }
        ResultDescription resultDescription = this.resultDescription;
        int n = resultDescription.getColumnCount();
        while (n >= 1) {
            String string2 = resultDescription.getColumnDescriptor(n).getName();
            if (StringUtil.SQLEqualsIgnoreCase(string, string2)) {
                return n;
            }
            --n;
        }
        throw this.newSQLException("S0022", string);
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDescription) {
        return new EmbedResultSetMetaData(resultDescription.getColumnInfo());
    }

    protected final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                try {
                    EmbedResultSet embedResultSet = this;
                    synchronized (embedResultSet) {
                        if (this.currentStream != null) {
                            if (this.currentStream instanceof Reader) {
                                ((Reader)this.currentStream).close();
                            } else {
                                ((InputStream)this.currentStream).close();
                            }
                        }
                    }
                    Object var2_3 = null;
                    this.currentStream = null;
                }
                catch (IOException iOException) {
                    Object var2_4 = null;
                    this.currentStream = null;
                }
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.currentStream = null;
                throw throwable;
            }
        }
    }

    protected final void checkIfClosed(String string) throws SQLException {
        if (this.isClosed) {
            throw this.newSQLException("XCL16.S", string);
        }
    }

    protected final void checkExecIfClosed(String string) throws SQLException {
        this.checkIfClosed(string);
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection == null || connection.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int n) {
        return n == -2 || n == -3 || n == -4 || n == 1 || n == 12 || n == -1;
    }

    protected final SQLException closeOnTransactionError(Throwable throwable) throws SQLException {
        StandardException standardException;
        int n;
        SQLException sQLException = this.handleException(throwable);
        if (throwable instanceof StandardException && (n = (standardException = (StandardException)throwable).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable throwable2) {
                SQLException sQLException2 = this.handleException(throwable2);
                sQLException2.setNextException(sQLException);
                sQLException = sQLException2;
            }
        }
        return sQLException;
    }

    protected final DataValueDescriptor getColumn(int n) throws SQLException, StandardException {
        this.closeCurrentStream();
        this.checkIfClosed("getXXX");
        DataValueDescriptor[] dataValueDescriptorArray = this.checkOnRow();
        try {
            return dataValueDescriptorArray[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.newSQLException("S0022", new Integer(n));
        }
    }

    public static final SQLException noStateChangeException(Throwable throwable) {
        return TransactionResourceImpl.wrapInSQLException(null, throwable);
    }

    void setDynamicResultSet(EmbedStatement embedStatement) {
        this.owningStmt = embedStatement;
        this.localConn = embedStatement.getEmbedConnection();
    }

    public final int compareTo(Object object) {
        EmbedResultSet embedResultSet = (EmbedResultSet)object;
        return this.order - embedResultSet.order;
    }

    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    protected final SQLException dataTypeConversion(String string, int n) {
        return this.newSQLException("22005", string, this.resultDescription.getColumnDescriptor(n).getType().getTypeId().getSQLTypeName());
    }

    public abstract BigDecimal getBigDecimal(int var1, int var2) throws SQLException;

    public abstract InputStream getUnicodeStream(int var1) throws SQLException;

    public abstract BigDecimal getBigDecimal(String var1, int var2) throws SQLException;

    public abstract InputStream getUnicodeStream(String var1) throws SQLException;

    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    public abstract BigDecimal getBigDecimal(String var1) throws SQLException;

    public abstract boolean isBeforeFirst() throws SQLException;

    public abstract boolean isAfterLast() throws SQLException;

    public abstract boolean isFirst() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract void beforeFirst() throws SQLException;

    public abstract void afterLast() throws SQLException;

    public abstract boolean first() throws SQLException;

    public abstract boolean last() throws SQLException;

    public abstract int getRow() throws SQLException;

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract boolean relative(int var1) throws SQLException;

    public abstract boolean previous() throws SQLException;

    public abstract void setFetchDirection(int var1) throws SQLException;

    public abstract int getFetchDirection() throws SQLException;

    public abstract void setFetchSize(int var1) throws SQLException;

    public abstract int getFetchSize() throws SQLException;

    public abstract int getType() throws SQLException;

    public abstract int getConcurrency() throws SQLException;

    public abstract boolean rowUpdated() throws SQLException;

    public abstract boolean rowInserted() throws SQLException;

    public abstract boolean rowDeleted() throws SQLException;

    public abstract void updateNull(int var1) throws SQLException;

    public abstract void updateBoolean(int var1, boolean var2) throws SQLException;

    public abstract void updateByte(int var1, byte var2) throws SQLException;

    public abstract void updateShort(int var1, short var2) throws SQLException;

    public abstract void updateInt(int var1, int var2) throws SQLException;

    public abstract void updateLong(int var1, long var2) throws SQLException;

    public abstract void updateFloat(int var1, float var2) throws SQLException;

    public abstract void updateDouble(int var1, double var2) throws SQLException;

    public abstract void updateBigDecimal(int var1, BigDecimal var2) throws SQLException;

    public abstract void updateString(int var1, String var2) throws SQLException;

    public abstract void updateBytes(int var1, byte[] var2) throws SQLException;

    public abstract void updateDate(int var1, Date var2) throws SQLException;

    public abstract void updateTime(int var1, Time var2) throws SQLException;

    public abstract void updateTimestamp(int var1, Timestamp var2) throws SQLException;

    public abstract void updateAsciiStream(int var1, InputStream var2, int var3) throws SQLException;

    public abstract void updateBinaryStream(int var1, InputStream var2, int var3) throws SQLException;

    public abstract void updateCharacterStream(int var1, Reader var2, int var3) throws SQLException;

    public abstract void updateObject(int var1, Object var2, int var3) throws SQLException;

    public abstract void updateObject(int var1, Object var2) throws SQLException;

    public abstract void updateNull(String var1) throws SQLException;

    public abstract void updateBoolean(String var1, boolean var2) throws SQLException;

    public abstract void updateByte(String var1, byte var2) throws SQLException;

    public abstract void updateShort(String var1, short var2) throws SQLException;

    public abstract void updateInt(String var1, int var2) throws SQLException;

    public abstract void updateLong(String var1, long var2) throws SQLException;

    public abstract void updateFloat(String var1, float var2) throws SQLException;

    public abstract void updateDouble(String var1, double var2) throws SQLException;

    public abstract void updateBigDecimal(String var1, BigDecimal var2) throws SQLException;

    public abstract void updateString(String var1, String var2) throws SQLException;

    public abstract void updateBytes(String var1, byte[] var2) throws SQLException;

    public abstract void updateDate(String var1, Date var2) throws SQLException;

    public abstract void updateTime(String var1, Time var2) throws SQLException;

    public abstract void updateTimestamp(String var1, Timestamp var2) throws SQLException;

    public abstract void updateAsciiStream(String var1, InputStream var2, int var3) throws SQLException;

    public abstract void updateBinaryStream(String var1, InputStream var2, int var3) throws SQLException;

    public abstract void updateCharacterStream(String var1, Reader var2, int var3) throws SQLException;

    public abstract void updateObject(String var1, Object var2, int var3) throws SQLException;

    public abstract void updateObject(String var1, Object var2) throws SQLException;

    public abstract void insertRow() throws SQLException;

    public abstract void updateRow() throws SQLException;

    public abstract void deleteRow() throws SQLException;

    public abstract void refreshRow() throws SQLException;

    public abstract void cancelRowUpdates() throws SQLException;

    public abstract void moveToInsertRow() throws SQLException;

    public abstract void moveToCurrentRow() throws SQLException;

    public abstract Statement getStatement() throws SQLException;

    public abstract Object getObject(int var1, Map var2) throws SQLException;

    public abstract Ref getRef(int var1) throws SQLException;

    public abstract Blob getBlob(int var1) throws SQLException;

    public abstract Clob getClob(int var1) throws SQLException;

    public abstract Array getArray(int var1) throws SQLException;

    public abstract Object getObject(String var1, Map var2) throws SQLException;

    public abstract Ref getRef(String var1) throws SQLException;

    public abstract Blob getBlob(String var1) throws SQLException;

    public abstract Clob getClob(String var1) throws SQLException;

    public abstract Array getArray(String var1) throws SQLException;

    public EmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) {
        super(embedConnection);
        this.theResults = resultSet;
        this.forMetaData = bl;
        this.stmt = this.owningStmt = embedStatement;
        this.isAtomic = bl2;
        ResultDescription resultDescription = this.resultDescription = this.theResults.getResultDescription();
        this.jdbcColumnTypes = new int[resultDescription.getColumnCount() + 1];
        int n = 1;
        while (n < this.jdbcColumnTypes.length) {
            this.jdbcColumnTypes[n] = resultDescription.getColumnDescriptor(n).getType().getTypeId().getJDBCTypeId();
            ++n;
        }
        if (embedStatement != null) {
            if (embedStatement.resultSetType == 1003) {
                this.maxRows = embedStatement.maxRows;
            }
            this.maxFieldSize = embedStatement.MaxFieldSize;
        }
        this.order = embedConnection.getResultSetOrderId();
    }
}

