/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLTimestamp
extends DataType
implements DateTimeDataValue {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2001, 2004.";
    static final int MAX_FRACTION_DIGITS = 6;
    static final int FRACTION_TO_NANO = 1000;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$Lorg$apache$derby$iapi$types$SQLTimestamp != null ? class$Lorg$apache$derby$iapi$types$SQLTimestamp : (class$Lorg$apache$derby$iapi$types$SQLTimestamp = SQLTimestamp.class$("org.apache.derby.iapi.types.SQLTimestamp")));
    static final char DATE_SEPARATOR = '-';
    private static final char[] DATE_SEPARATORS = new char[]{'-'};
    private static final char IBM_DATE_TIME_SEPARATOR = '-';
    private static final char ODBC_DATE_TIME_SEPARATOR = ' ';
    private static final char[] DATE_TIME_SEPARATORS = new char[]{'-', ' '};
    private static final char[] DATE_TIME_SEPARATORS_OR_END = new char[]{'-', ' ', '\u0000'};
    private static final char IBM_TIME_SEPARATOR = '.';
    private static final char ODBC_TIME_SEPARATOR = ':';
    private static final char[] TIME_SEPARATORS = new char[]{'.', ':'};
    private static final char[] TIME_SEPARATORS_OR_END = new char[]{'.', ':', '\u0000'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};
    private int encodedDate;
    private int encodedTime;
    private int nanos;
    private String valueString;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$types$SQLTimestamp;

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.valueString);
        return n;
    }

    public String getString() {
        if (!this.isNull()) {
            if (this.valueString == null) {
                this.valueString = this.getTimestamp(null).toString();
                int n = this.valueString.indexOf(45);
                if (n >= 0 && n < 4) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while (n < 4) {
                        stringBuffer.append('0');
                        ++n;
                    }
                    stringBuffer.append(this.valueString);
                    this.valueString = stringBuffer.toString();
                }
            }
            return this.valueString;
        }
        return null;
    }

    public Date getDate(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return this.newDate(calendar);
    }

    private Date newDate(Calendar calendar) throws StandardException {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.set(1, SQLDate.getYear(this.encodedDate));
        calendar.set(2, SQLDate.getMonth(this.encodedDate) - 1);
        calendar.set(5, SQLDate.getDay(this.encodedDate));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }

    public Time getTime(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return this.newTime(calendar);
    }

    private Time newTime(Calendar calendar) throws StandardException {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, SQLTime.getHour(this.encodedTime));
        calendar.set(12, SQLTime.getMinute(this.encodedTime));
        calendar.set(13, SQLTime.getSecond(this.encodedTime));
        calendar.set(14, (int)((double)this.nanos / 1000000.0));
        return new Time(calendar.getTime().getTime());
    }

    public Object getObject() {
        return this.getTimestamp(null);
    }

    public int getLength() {
        return 12;
    }

    public String getTypeName() {
        return "TIMESTAMP";
    }

    public int getTypeFormatId() {
        return 31;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.encodedDate);
        objectOutput.writeInt(this.encodedTime);
        objectOutput.writeInt(this.nanos);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.encodedDate = objectInput.readInt();
        this.encodedTime = objectInput.readInt();
        this.nanos = objectInput.readInt();
        this.valueString = null;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.encodedDate = arrayInputStream.readInt();
        this.encodedTime = arrayInputStream.readInt();
        this.nanos = arrayInputStream.readInt();
        this.valueString = null;
    }

    public DataValueDescriptor getClone() {
        return new SQLTimestamp(this.encodedDate, this.encodedTime, this.nanos);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLTimestamp();
    }

    public void restoreToNull() {
        this.encodedDate = 0;
        this.encodedTime = 0;
        this.nanos = 0;
        this.valueString = null;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException, StandardException {
        this.setValue(resultSet.getTimestamp(n), null);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (dataValueDescriptor instanceof SQLTimestamp) {
            SQLTimestamp sQLTimestamp = (SQLTimestamp)dataValueDescriptor;
            n = sQLTimestamp.encodedDate;
            n2 = sQLTimestamp.encodedTime;
            n3 = sQLTimestamp.nanos;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Timestamp timestamp = dataValueDescriptor.getTimestamp(gregorianCalendar);
            n = SQLTimestamp.computeEncodedDate(timestamp, gregorianCalendar);
            n2 = SQLTimestamp.computeEncodedTime(timestamp, gregorianCalendar);
            n3 = timestamp.getNanos();
        }
        int n4 = this.encodedDate < n ? -1 : (this.encodedDate > n ? 1 : (this.encodedTime < n2 ? -1 : (this.encodedTime > n2 ? 1 : (this.nanos < n3 ? -1 : (this.nanos > n3 ? 1 : 0)))));
        return n4;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    private void parseTimestamp(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        StandardException standardException = null;
        DateTimeParser dateTimeParser = new DateTimeParser(string);
        try {
            int[] nArray = SQLTimestamp.parseDateOrTimestamp(dateTimeParser, true);
            this.encodedDate = nArray[0];
            this.encodedTime = nArray[1];
            this.nanos = nArray[2];
            this.valueString = dateTimeParser.getTrimmedString();
            return;
        }
        catch (StandardException standardException2) {
            standardException = standardException2;
            try {
                string = StringUtil.trimTrailing(string);
                int[] nArray = SQLTimestamp.parseLocalTimestamp(string, localeFinder, calendar);
                this.encodedDate = nArray[0];
                this.encodedTime = nArray[1];
                this.valueString = string;
                return;
            }
            catch (ParseException parseException) {
            }
            catch (StandardException standardException3) {
                // empty catch block
            }
            if (standardException != null) {
                throw standardException;
            }
            throw StandardException.newException("22007.S.181");
        }
    }

    static int[] parseLocalTimestamp(String string, LocaleFinder localeFinder, Calendar calendar) throws StandardException, ParseException {
        DateFormat dateFormat = null;
        dateFormat = localeFinder == null ? DateFormat.getDateTimeInstance() : (calendar == null ? localeFinder.getTimestampFormat() : (DateFormat)localeFinder.getTimestampFormat().clone());
        if (calendar == null) {
            calendar = new GregorianCalendar();
        } else {
            dateFormat.setCalendar(calendar);
        }
        java.util.Date date = dateFormat.parse(string);
        return new int[]{SQLTimestamp.computeEncodedDate(date, calendar), SQLTimestamp.computeEncodedTime(date, calendar)};
    }

    static int[] parseDateOrTimestamp(DateTimeParser dateTimeParser, boolean bl) throws StandardException {
        int n = dateTimeParser.parseInt(4, false, DATE_SEPARATORS, false);
        int n2 = dateTimeParser.parseInt(2, true, DATE_SEPARATORS, false);
        int n3 = dateTimeParser.parseInt(2, true, bl ? DATE_TIME_SEPARATORS : DATE_TIME_SEPARATORS_OR_END, false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (dateTimeParser.getCurrentSeparator() != '\u0000') {
            char c = dateTimeParser.getCurrentSeparator() == ' ' ? (char)':' : '.';
            n4 = dateTimeParser.parseInt(2, true, TIME_SEPARATORS, false);
            if (c == dateTimeParser.getCurrentSeparator()) {
                n5 = dateTimeParser.parseInt(2, false, TIME_SEPARATORS, false);
                if (c == dateTimeParser.getCurrentSeparator()) {
                    n6 = dateTimeParser.parseInt(2, false, TIME_SEPARATORS_OR_END, false);
                    if (dateTimeParser.getCurrentSeparator() == '.') {
                        n7 = dateTimeParser.parseInt(6, true, END_OF_STRING, true) * 1000;
                    }
                }
            }
        }
        dateTimeParser.checkEnd();
        return new int[]{SQLDate.computeEncodedDate(n, n2, n3), SQLTime.computeEncodedTime(n4, n5, n6), n7};
    }

    public void setValue(Object object) throws StandardException {
        if (object == null) {
            this.setToNull();
        } else if (object instanceof Date) {
            this.setValue((Date)object, null);
        } else if (object instanceof Time) {
            this.setValue((Time)object, null);
        } else if (object instanceof Timestamp) {
            this.setValue((Timestamp)object, null);
        } else {
            this.genericSetObject(object);
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLTimestamp) {
            this.restoreToNull();
            SQLTimestamp sQLTimestamp = (SQLTimestamp)dataValueDescriptor;
            this.encodedDate = sQLTimestamp.encodedDate;
            this.encodedTime = sQLTimestamp.encodedTime;
            this.nanos = sQLTimestamp.nanos;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            this.setValue(dataValueDescriptor.getTimestamp(gregorianCalendar), (Calendar)gregorianCalendar);
        }
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.restoreToNull();
        if (date != null) {
            if (calendar == null) {
                calendar = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(date, calendar);
        }
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.restoreToNull();
        if (time != null) {
            Calendar calendar2 = Calendar.getInstance();
            this.encodedDate = SQLDate.computeEncodedDate(calendar2);
            if (calendar == null) {
                calendar = calendar2;
            }
            this.encodedTime = SQLTimestamp.computeEncodedTime(time, calendar);
        }
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.setNumericTimestamp(timestamp, calendar);
    }

    public void setValue(String string) throws StandardException {
        this.restoreToNull();
        if (string != null) {
            DatabaseContext databaseContext = (DatabaseContext)ContextService.getContext("Database");
            this.parseTimestamp(string, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    public NumberDataValue getYear(NumberDataValue numberDataValue) throws StandardException {
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getMonth(NumberDataValue numberDataValue) throws StandardException {
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getDate(NumberDataValue numberDataValue) throws StandardException {
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getHours(NumberDataValue numberDataValue) throws StandardException {
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), numberDataValue);
    }

    public NumberDataValue getMinutes(NumberDataValue numberDataValue) throws StandardException {
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), numberDataValue);
    }

    public NumberDataValue getSeconds(NumberDataValue numberDataValue) throws StandardException {
        NumberDataValue numberDataValue2 = numberDataValue != null ? numberDataValue : new SQLDouble();
        numberDataValue2.setValue((double)SQLTime.getSecond(this.encodedTime) + (double)this.nanos / 1.0E9);
        return numberDataValue2;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTimestamp(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedDate + this.encodedTime + this.nanos;
    }

    public int typePrecedence() {
        return 110;
    }

    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    public Timestamp getTimestamp(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return this.newTimestamp(calendar);
    }

    protected Timestamp newTimestamp(Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.set(1, SQLDate.getYear(this.encodedDate));
        calendar.set(2, SQLDate.getMonth(this.encodedDate) - 1);
        calendar.set(5, SQLDate.getDay(this.encodedDate));
        calendar.set(11, SQLTime.getHour(this.encodedTime));
        calendar.set(12, SQLTime.getMinute(this.encodedTime));
        calendar.set(13, SQLTime.getSecond(this.encodedTime));
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    private void setNumericTimestamp(Timestamp timestamp, Calendar calendar) throws StandardException {
        if (timestamp != null) {
            if (calendar == null) {
                calendar = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(timestamp, calendar);
            this.encodedTime = SQLTimestamp.computeEncodedTime(timestamp, calendar);
            this.nanos = timestamp.getNanos();
        }
    }

    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        if (this.isNull()) {
            return this.getString();
        }
        return localeFinder.getTimestampFormat().format(this.getTimestamp(null));
    }

    private static int computeEncodedDate(java.util.Date date, Calendar calendar) throws StandardException {
        if (date == null) {
            return 0;
        }
        calendar.setTime(date);
        return SQLDate.computeEncodedDate(calendar);
    }

    private static int computeEncodedTime(java.util.Date date, Calendar calendar) throws StandardException {
        calendar.setTime(date);
        return SQLTime.computeEncodedTime(calendar);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SQLTimestamp() {
    }

    public SQLTimestamp(Timestamp timestamp) throws StandardException {
        this.setValue(timestamp, null);
    }

    private SQLTimestamp(int n, int n2, int n3) {
        this.encodedDate = n;
        this.encodedTime = n2;
        this.nanos = n3;
    }

    public SQLTimestamp(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        DataType dataType;
        GregorianCalendar gregorianCalendar = null;
        if (dataValueDescriptor == null || dataValueDescriptor.isNull() || dataValueDescriptor2 == null || dataValueDescriptor2.isNull()) {
            return;
        }
        if (dataValueDescriptor instanceof SQLDate) {
            dataType = (SQLDate)dataValueDescriptor;
            this.encodedDate = ((SQLDate)dataType).getEncodedDate();
        } else {
            gregorianCalendar = new GregorianCalendar();
            this.encodedDate = SQLTimestamp.computeEncodedDate(dataValueDescriptor.getDate(gregorianCalendar), gregorianCalendar);
        }
        if (dataValueDescriptor2 instanceof SQLTime) {
            dataType = (SQLTime)dataValueDescriptor2;
            this.encodedTime = ((SQLTime)dataType).getEncodedTime();
        } else {
            if (gregorianCalendar == null) {
                gregorianCalendar = new GregorianCalendar();
            }
            this.encodedTime = SQLTimestamp.computeEncodedTime(dataValueDescriptor2.getTime(gregorianCalendar), gregorianCalendar);
        }
    }

    public SQLTimestamp(String string, boolean bl, LocaleFinder localeFinder) throws StandardException {
        this.parseTimestamp(string, bl, localeFinder, null);
    }

    public SQLTimestamp(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        this.parseTimestamp(string, bl, localeFinder, calendar);
    }
}

