/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;

public class BeginXact
implements Loggable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected int transactionStatus;
    protected GlobalTransactionId xactId;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.transactionStatus);
        objectOutput.writeObject(this.xactId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.transactionStatus = objectInput.readInt();
        this.xactId = (GlobalTransactionId)objectInput.readObject();
    }

    public int getTypeFormatId() {
        return 169;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) {
        RawTransaction rawTransaction = (RawTransaction)transaction;
        if (logInstant != null) {
            rawTransaction.setFirstLogInstant(logInstant);
            rawTransaction.addUpdateTransaction(this.transactionStatus);
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction transaction) {
        return true;
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        int n = 257;
        return n;
    }

    public String toString() {
        return null;
    }

    public GlobalTransactionId getGlobalId() {
        return this.xactId;
    }

    public BeginXact(GlobalTransactionId globalTransactionId, int n) {
        this.xactId = globalTransactionId;
        this.transactionStatus = n;
    }

    public BeginXact() {
    }
}

