/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

abstract class RealBasicNoPutResultSetStatistics
implements ResultSetStatistics {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private static DecimalFormat df = null;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;

    protected final String dumpTimeStats(String string, String string2) {
        return string2 + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected final String dumpEstimatedCosts(String string) {
        return string + MessageService.getTextMessage("43X07.U") + ": " + this.formatDouble(this.optimizerEstimatedRowCount) + "\n" + string + MessageService.getTextMessage("43X08.U") + ": " + this.formatDouble(this.optimizerEstimatedCost) + "\n";
    }

    private String formatDouble(double d) {
        String string;
        if (df == null) {
            df = new DecimalFormat("###########0.00");
            df.setMinimumIntegerDigits(1);
        }
        if ((string = df.format(d)).length() < 15) {
            string = "               ".substring(0, 15 - string.length()) + string;
        }
        return string;
    }

    public Vector getChildren() {
        return new Vector();
    }

    public long getTotalTime() {
        return this.openTime + this.nextTime + this.closeTime;
    }

    public long getChildrenTime() {
        long l = 0L;
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            l += ((RealBasicNoPutResultSetStatistics)enumeration.nextElement()).getTotalTime();
        }
        return l;
    }

    public long getNodeTime() {
        return this.getTotalTime() - this.getChildrenTime();
    }

    public abstract String getNodeName();

    public String getNodeOn() {
        return "";
    }

    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    public abstract String getStatementExecutionPlanText(int var1);

    public abstract String getScanStatisticsText(String var1, int var2);

    public RealBasicNoPutResultSetStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, double d, double d2) {
        this.numOpens = n;
        this.rowsSeen = n2;
        this.rowsFiltered = n3;
        this.constructorTime = l;
        this.openTime = l2;
        this.nextTime = l3;
        this.closeTime = l4;
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }
}

