/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class PredicateList
extends QueryTreeNodeVector
implements OptimizablePredicateList {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int QUALIFIER_ORDER_EQUALS = 0;
    private static final int QUALIFIER_ORDER_OTHER_RELOP = 1;
    private static final int QUALIFIER_ORDER_NOT_EQUALS = 2;
    private static final int QUALIFIER_ORDER_NON_QUAL = 3;
    private static final int QUALIFIER_ORDER_OR_CLAUSE = 4;
    private static final int QUALIFIER_NUM_CATEGORIES = 5;
    private int numberOfStartPredicates;
    private int numberOfStopPredicates;
    private int numberOfQualifiers;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$ColumnReference;

    public OptimizablePredicate getOptPredicate(int n) {
        return (OptimizablePredicate)((Object)this.elementAt(n));
    }

    public final void removeOptPredicate(int n) throws StandardException {
        Predicate predicate = (Predicate)this.remove(n);
        if (predicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public final void removeOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.removeElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optimizablePredicate) {
        this.addElement((Predicate)optimizablePredicate);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optimizablePredicate, int n) {
        this.insertElementAt((Predicate)optimizablePredicate, n);
        if (optimizablePredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optimizablePredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optimizablePredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public boolean useful(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        boolean bl = false;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            block11: {
                BinaryListOperatorNode binaryListOperatorNode;
                boolean bl2;
                RelationalOperator relationalOperator;
                block10: {
                    Predicate predicate = (Predicate)this.elementAt(n2);
                    relationalOperator = predicate.getRelop();
                    bl2 = false;
                    binaryListOperatorNode = null;
                    if (relationalOperator != null) break block10;
                    if (!(predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode) || ((InListOperatorNode)predicate.getAndNode().getLeftOperand()).getTransformed()) break block11;
                    bl2 = true;
                    binaryListOperatorNode = (InListOperatorNode)predicate.getAndNode().getLeftOperand();
                }
                if (bl2 || relationalOperator.usefulStartKey(optimizable) || relationalOperator.usefulStopKey(optimizable)) {
                    ColumnReference columnReference = null;
                    if (bl2) {
                        if (binaryListOperatorNode.getLeftOperand() instanceof ColumnReference && (columnReference = (ColumnReference)binaryListOperatorNode.getLeftOperand()).getColumnNumber() != conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]) {
                            columnReference = null;
                        }
                    } else {
                        columnReference = relationalOperator.getColumnOperand(optimizable, conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[0]);
                    }
                    if (!(columnReference == null || bl2 && ((InListOperatorNode)binaryListOperatorNode).selfReference(columnReference) || !bl2 && relationalOperator.selfComparison(columnReference))) {
                        bl = true;
                        break;
                    }
                }
            }
            ++n2;
        }
        return bl;
    }

    public void pushUsefulPredicates(Optimizable optimizable) throws StandardException {
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        this.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), true, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
    }

    public void classify(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        this.orderUsefulPredicates(optimizable, conglomerateDescriptor, false, false, false);
    }

    public void markAllPredicatesQualifiers() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((Predicate)this.elementAt(n2)).markQualifier();
            ++n2;
        }
        this.numberOfQualifiers = n;
    }

    public boolean hasOptimizableEqualityPredicate(Optimizable optimizable, int n, boolean bl) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (valueNode.optimizableEqualityNode(optimizable, n, bl)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasOptimizableEquijoin(Optimizable optimizable, int n) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (valueNode.optimizableEqualityNode(optimizable, n, false) && ((RelationalOperator)((Object)valueNode)).isQualifier(optimizable) && !predicate.getReferencedMap().hasSingleBitSet()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void putOptimizableEqualityPredicateFirst(Optimizable optimizable, int n) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            AndNode andNode = predicate.getAndNode();
            ValueNode valueNode = andNode.getLeftOperand();
            if (valueNode.optimizableEqualityNode(optimizable, n, false)) {
                if (n3 != 0) {
                    this.removeElementAt(n3);
                    this.insertElementAt(predicate, 0);
                }
                return;
            }
            ++n3;
        }
    }

    private void orderUsefulPredicates(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        int n;
        int n2;
        int n3 = this.size();
        Object[] objectArray = new Predicate[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            Predicate predicate = (Predicate)this.elementAt(n5);
            predicate.clearScanFlags();
            ++n5;
        }
        if (conglomerateDescriptor == null || !conglomerateDescriptor.isIndex() || bl2 && bl3) {
            Predicate[] predicateArray = new Predicate[n3];
            int n6 = 0;
            while (n6 < n3) {
                Predicate predicate = (Predicate)this.elementAt(n6);
                RelationalOperator relationalOperator = predicate.getRelop();
                if (!(relationalOperator == null ? !predicate.isPushableOrClause(optimizable) : !relationalOperator.isQualifier(optimizable))) {
                    predicate.markQualifier();
                    if (bl && optimizable.pushOptPredicate(predicate)) {
                        predicateArray[n6] = predicate;
                    }
                }
                ++n6;
            }
            n6 = n3 - 1;
            while (n6 >= 0) {
                if (predicateArray[n6] != null) {
                    this.removeOptPredicate(predicateArray[n6]);
                }
                --n6;
            }
            return;
        }
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = conglomerateDescriptor.getIndexDescriptor().isAscending();
        n5 = 0;
        while (n5 < n3) {
            block40: {
                BinaryListOperatorNode binaryListOperatorNode;
                RelationalOperator relationalOperator;
                ColumnReference columnReference;
                Predicate predicate;
                block39: {
                    predicate = (Predicate)this.elementAt(n5);
                    columnReference = null;
                    relationalOperator = predicate.getRelop();
                    n2 = 0;
                    binaryListOperatorNode = null;
                    if (relationalOperator != null) break block39;
                    if (!(predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode) || ((InListOperatorNode)predicate.getAndNode().getLeftOperand()).getTransformed()) break block40;
                    n2 = 1;
                    binaryListOperatorNode = (InListOperatorNode)predicate.getAndNode().getLeftOperand();
                }
                if (n2 != 0 || relationalOperator.isQualifier(optimizable)) {
                    n = 0;
                    while (n < nArray.length) {
                        if (n2 != 0) {
                            if (binaryListOperatorNode.getLeftOperand() instanceof ColumnReference) {
                                columnReference = (ColumnReference)binaryListOperatorNode.getLeftOperand();
                                if (optimizable.getTableNumber() != columnReference.getTableNumber() || columnReference.getColumnNumber() != nArray[n] || ((InListOperatorNode)binaryListOperatorNode).selfReference(columnReference)) {
                                    columnReference = null;
                                }
                            }
                        } else {
                            columnReference = relationalOperator.getColumnOperand(optimizable, nArray[n]);
                        }
                        if (columnReference != null) break;
                        ++n;
                    }
                    if (columnReference != null) {
                        predicate.setIndexPosition(n);
                        objectArray[n4++] = predicate;
                    }
                }
            }
            ++n5;
        }
        if (n4 == 0) {
            return;
        }
        if (objectArray.length > n4) {
            Predicate[] predicateArray = new Predicate[n4];
            System.arraycopy(objectArray, 0, predicateArray, 0, n4);
            objectArray = predicateArray;
        }
        Arrays.sort(objectArray);
        int n7 = -1;
        boolean bl4 = false;
        int n8 = -1;
        n = 0;
        boolean bl5 = false;
        n2 = -1;
        int n9 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        int n10 = 0;
        while (n10 < n4) {
            Object object = objectArray[n10];
            int n11 = ((Predicate)object).getIndexPosition();
            boolean bl8 = false;
            RelationalOperator relationalOperator = ((Predicate)object).getRelop();
            int n12 = -1;
            boolean bl9 = false;
            InListOperatorNode inListOperatorNode = null;
            if (relationalOperator == null) {
                bl9 = true;
                inListOperatorNode = (InListOperatorNode)((Predicate)object).getAndNode().getLeftOperand();
            } else {
                n12 = relationalOperator.getOperator();
            }
            if (n7 != n11) {
                if (n11 - n7 > 1) {
                    bl4 = true;
                } else if (n12 == 1 || n12 == 7) {
                    n9 = n11;
                }
                if (!bl4 && !bl7 && (bl9 || relationalOperator.usefulStartKey(optimizable) && blArray[n11] || relationalOperator.usefulStopKey(optimizable) && !blArray[n11])) {
                    ((Predicate)object).markStartKey();
                    n7 = n11;
                    bl8 = true;
                    boolean bl10 = bl7 = ((Predicate)object).getStartOperator(optimizable) == -1;
                }
            }
            if (n8 != n11) {
                if (n11 - n8 > 1) {
                    n = 1;
                }
                if (n == 0 && !bl6 && (bl9 || relationalOperator.usefulStopKey(optimizable) && blArray[n11] || relationalOperator.usefulStartKey(optimizable) && !blArray[n11])) {
                    ((Predicate)object).markStopKey();
                    n8 = n11;
                    bl8 = true;
                    boolean bl11 = bl6 = ((Predicate)object).getStopOperator(optimizable) == 1;
                }
            }
            if (!bl9 && (!bl8 || bl5 && n11 != n2)) {
                ((Predicate)object).markQualifier();
            }
            if (n9 != n11 && n2 == -1 && n12 != 1 && n12 != 7) {
                bl5 = true;
                n2 = n11;
            }
            if (bl) {
                if (!bl9 || bl8) {
                    Object object2;
                    if (bl9) {
                        AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, ((Predicate)object).getAndNode().getLeftOperand(), ((Predicate)object).getAndNode().getRightOperand(), this.getContextManager());
                        andNode.copyFields(((Predicate)object).getAndNode());
                        Predicate predicate = (Predicate)this.getNodeFactory().getNode(78, andNode, ((Predicate)object).getReferencedSet(), this.getContextManager());
                        predicate.copyFields((Predicate)object);
                        object2 = predicate;
                    } else {
                        object2 = object;
                    }
                    if (optimizable.pushOptPredicate((OptimizablePredicate)object2) && !bl9) {
                        this.removeOptPredicate((OptimizablePredicate)object);
                    }
                }
            } else {
                this.removeOptPredicate((OptimizablePredicate)object);
                this.addOptPredicate((OptimizablePredicate)object, n10);
            }
            ++n10;
        }
    }

    public void addPredicate(Predicate predicate) throws StandardException {
        if (predicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
        this.addElement(predicate);
    }

    protected void transferNonQualifiers(Optimizable optimizable, PredicateList predicateList) throws StandardException {
        int n = this.size() - 1;
        while (n >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n);
            RelationalOperator relationalOperator = predicate.getRelop();
            if (relationalOperator == null || !relationalOperator.isQualifier(optimizable)) {
                predicate.clearScanFlags();
                this.removeElementAt(n);
                predicateList.addElement(predicate);
            }
            --n;
        }
        this.markAllPredicatesQualifiers();
    }

    public void categorize() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((Predicate)this.elementAt(n2)).categorize();
            ++n2;
        }
    }

    public void printSubNodes(int n) {
    }

    public void eliminateBooleanTrueAndBooleanTrue() {
        int n = this.size() - 1;
        while (n >= 0) {
            AndNode andNode = ((Predicate)this.elementAt(n)).getAndNode();
            if (andNode.getLeftOperand().isBooleanTrue() && andNode.getRightOperand().isBooleanTrue()) {
                this.removeElementAt(n);
            }
            --n;
        }
    }

    public ValueNode restoreConstantPredicates() {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        int n = this.size() - 1;
        while (n >= 0) {
            AndNode andNode = ((Predicate)this.elementAt(n)).getAndNode();
            if (andNode.isConstantExpression()) {
                this.removeElementAt(n);
                if (!andNode.getLeftOperand().isBooleanTrue() || !andNode.getRightOperand().isBooleanTrue()) {
                    if (andNode.getLeftOperand().isBooleanFalse()) {
                        binaryOperatorNode = andNode;
                    }
                    if (valueNode != null) {
                        andNode.setRightOperand(valueNode);
                        if (valueNode.getTypeServices().isNullable()) {
                            andNode.getTypeServices().setNullability(true);
                        }
                    }
                    valueNode = andNode;
                }
            }
            --n;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        return valueNode;
    }

    public ValueNode restorePredicates() {
        BinaryOperatorNode binaryOperatorNode = null;
        ValueNode valueNode = null;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            AndNode andNode = ((Predicate)this.elementAt(n2)).getAndNode();
            if (!andNode.getLeftOperand().isBooleanTrue() || !andNode.getRightOperand().isBooleanTrue()) {
                if (andNode.getLeftOperand().isBooleanFalse()) {
                    binaryOperatorNode = andNode;
                }
                if (valueNode != null) {
                    andNode.setRightOperand(valueNode);
                    if (valueNode.getTypeServices().isNullable()) {
                        andNode.getTypeServices().setNullability(true);
                    }
                }
                valueNode = andNode;
            }
            ++n2;
        }
        if (valueNode != null && ((AndNode)valueNode).getRightOperand().isBooleanTrue()) {
            valueNode = ((AndNode)valueNode).getLeftOperand();
        } else if (binaryOperatorNode != null) {
            valueNode = binaryOperatorNode.getLeftOperand();
        }
        this.removeAllElements();
        return valueNode;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            predicate.setAndNode((AndNode)predicate.getAndNode().remapColumnReferencesToExpressions());
            ++n2;
        }
    }

    void pullExpressions(int n, ValueNode valueNode) throws StandardException {
        BooleanConstantNode booleanConstantNode = null;
        if (valueNode != null) {
            Predicate predicate;
            JBitSet jBitSet;
            AndNode andNode = (AndNode)valueNode;
            valueNode = null;
            booleanConstantNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            while (andNode.getRightOperand() instanceof AndNode) {
                AndNode andNode2 = andNode;
                andNode = (AndNode)andNode.getRightOperand();
                andNode2.setRightOperand(null);
                andNode2.setRightOperand(booleanConstantNode);
                jBitSet = new JBitSet(n);
                predicate = (Predicate)this.getNodeFactory().getNode(78, andNode2, jBitSet, this.getContextManager());
                this.addPredicate(predicate);
            }
            jBitSet = new JBitSet(n);
            predicate = (Predicate)this.getNodeFactory().getNode(78, andNode, jBitSet, this.getContextManager());
            this.addPredicate(predicate);
        }
    }

    public void xorReferencedSet(JBitSet jBitSet) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            predicate.getReferencedSet().xor(jBitSet);
            ++n2;
        }
    }

    private void countScanFlags() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            if (predicate.isStartKey()) {
                ++this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                ++this.numberOfStopPredicates;
            }
            if (predicate.isQualifier()) {
                ++this.numberOfQualifiers;
            }
            ++n2;
        }
    }

    void pushExpressionsIntoSelect(SelectNode selectNode) throws StandardException {
        int n = this.size() - 1;
        while (n >= 0) {
            boolean bl;
            Predicate predicate = (Predicate)this.elementAt(n);
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$Lorg$apache$derby$impl$sql$compile$ColumnReference != null ? class$Lorg$apache$derby$impl$sql$compile$ColumnReference : PredicateList.class$("org.apache.derby.impl.sql.compile.ColumnReference"));
            predicate.getAndNode().accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            boolean bl2 = bl = vector.size() > 0;
            if (bl) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ColumnReference columnReference = (ColumnReference)enumeration.nextElement();
                    if (columnReference.pointsToColumnReference()) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                if (predicate.isStartKey()) {
                    --this.numberOfStartPredicates;
                }
                if (predicate.isStopKey()) {
                    --this.numberOfStopPredicates;
                }
                if (predicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                predicate.clearScanFlags();
                this.removeElementAt(n);
                selectNode.pushExpressionsIntoSelect(predicate);
            }
            --n;
        }
    }

    void markReferencedColumns() throws StandardException {
        Object object;
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$Lorg$apache$derby$impl$sql$compile$ColumnReference != null ? class$Lorg$apache$derby$impl$sql$compile$ColumnReference : (class$Lorg$apache$derby$impl$sql$compile$ColumnReference = PredicateList.class$("org.apache.derby.impl.sql.compile.ColumnReference")));
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            object = (Predicate)this.elementAt(n2);
            ((Predicate)object).getAndNode().accept(collectNodesVisitor);
            ++n2;
        }
        Vector vector = collectNodesVisitor.getList();
        object = vector.elements();
        while (object.hasMoreElements()) {
            ColumnReference columnReference = (ColumnReference)object.nextElement();
            columnReference.getSource().markAllRCsInChainReferenced();
        }
    }

    void checkTopPredicatesForEqualsConditions(int n, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            AndNode andNode = ((Predicate)this.elementAt(n3)).getAndNode();
            andNode.checkTopPredicatesForEqualsConditions(n, blArray, nArray, jBitSetArray, bl);
            ++n3;
        }
    }

    boolean allPushable() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            if (!predicate.getPushable()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    PredicateList getPushablePredicates(JBitSet jBitSet) throws StandardException {
        PredicateList predicateList = null;
        int n = this.size() - 1;
        while (n >= 0) {
            JBitSet jBitSet2;
            Predicate predicate = (Predicate)this.elementAt(n);
            if (predicate.getPushable() && jBitSet.contains(jBitSet2 = predicate.getReferencedSet())) {
                if (predicateList == null) {
                    predicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
                }
                predicateList.addPredicate(predicate);
                RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
                predicate.getAndNode().accept(remapCRsVisitor);
                this.removeElementAt(n);
            }
            --n;
        }
        return predicateList;
    }

    void decrementLevel(FromList fromList, int n) {
        int[] nArray = fromList.getTableNumbers();
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            UnaryOperatorNode unaryOperatorNode;
            ColumnReference columnReference = null;
            ColumnReference columnReference2 = null;
            Predicate predicate = (Predicate)this.elementAt(n3);
            ValueNode valueNode = predicate.getAndNode().getLeftOperand();
            if (valueNode instanceof BinaryOperatorNode) {
                BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)valueNode;
                if (binaryOperatorNode.getLeftOperand() instanceof ColumnReference) {
                    columnReference = (ColumnReference)binaryOperatorNode.getLeftOperand();
                }
                if (binaryOperatorNode.getRightOperand() instanceof ColumnReference) {
                    columnReference2 = (ColumnReference)binaryOperatorNode.getRightOperand();
                }
            } else if (valueNode instanceof UnaryOperatorNode && (unaryOperatorNode = (UnaryOperatorNode)valueNode).getOperand() instanceof ColumnReference) {
                columnReference = (ColumnReference)unaryOperatorNode.getOperand();
            }
            if (columnReference != null) {
                int n5 = columnReference.getTableNumber();
                n4 = 0;
                while (n4 < nArray.length) {
                    if (nArray[n4] == n5) {
                        columnReference.setSourceLevel(columnReference.getSourceLevel() - n);
                        break;
                    }
                    ++n4;
                }
            }
            if (columnReference2 != null) {
                int n6 = columnReference2.getTableNumber();
                n4 = 0;
                while (n4 < nArray.length) {
                    if (nArray[n4] == n6) {
                        columnReference2.setSourceLevel(columnReference2.getSourceLevel() - n);
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
    }

    void joinClauseTransitiveClosure(int n, FromList fromList, CompilerContext compilerContext) throws StandardException {
        ValueNode valueNode;
        QueryTreeNode queryTreeNode;
        Object object;
        QueryTreeNode queryTreeNode2;
        if (fromList.size() < 3) {
            return;
        }
        PredicateList[] predicateListArray = new PredicateList[n];
        int n2 = 0;
        while (n2 < n) {
            predicateListArray[n2] = new PredicateList();
            ++n2;
        }
        n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            queryTreeNode2 = (Predicate)this.elementAt(n3);
            object = ((Predicate)queryTreeNode2).getAndNode().getLeftOperand();
            if (((ValueNode)object).isBinaryEqualsOperatorNode()) {
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)object;
                queryTreeNode = binaryRelationalOperatorNode.getLeftOperand();
                valueNode = binaryRelationalOperatorNode.getRightOperand();
                if (queryTreeNode instanceof ColumnReference && valueNode instanceof ColumnReference) {
                    ColumnReference columnReference = (ColumnReference)queryTreeNode;
                    ColumnReference columnReference2 = (ColumnReference)valueNode;
                    if (columnReference.getSourceLevel() == columnReference2.getSourceLevel() && columnReference.getTableNumber() != columnReference2.getTableNumber()) {
                        predicateListArray[columnReference.getTableNumber()].addElement(queryTreeNode2);
                        predicateListArray[columnReference2.getTableNumber()].addElement(queryTreeNode2);
                    }
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            block23: {
                queryTreeNode2 = predicateListArray[n3];
                if (((QueryTreeNodeVector)queryTreeNode2).size() == 0) break block23;
                object = new Vector();
                int n4 = ((QueryTreeNodeVector)queryTreeNode2).size() - 1;
                while (n4 >= 0) {
                    queryTreeNode = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n4);
                    if (((Predicate)queryTreeNode).getEquivalenceClass() != -1) {
                        ((QueryTreeNodeVector)queryTreeNode2).removeElementAt(n4);
                        ((Vector)object).addElement(queryTreeNode);
                    }
                    --n4;
                }
                n4 = 0;
                while (n4 < ((Vector)object).size()) {
                    ((QueryTreeNodeVector)queryTreeNode2).insertElementAt((Predicate)((Vector)object).elementAt(n4), 0);
                    ++n4;
                }
                n4 = 0;
                while (n4 < ((QueryTreeNodeVector)queryTreeNode2).size()) {
                    int n5;
                    int n6;
                    int n7;
                    queryTreeNode = null;
                    valueNode = null;
                    int n8 = n3;
                    Predicate predicate = (Predicate)((QueryTreeNodeVector)queryTreeNode2).elementAt(n4);
                    if (predicate.getEquivalenceClass() == -1) {
                        predicate.setEquivalenceClass(compilerContext.getNextEquivalenceClass());
                    }
                    int n9 = predicate.getEquivalenceClass();
                    BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)predicate.getAndNode().getLeftOperand();
                    ColumnReference columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                    ColumnReference columnReference3 = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
                    if (columnReference.getTableNumber() == n8) {
                        n7 = columnReference.getColumnNumber();
                        n6 = columnReference3.getTableNumber();
                        n5 = columnReference3.getColumnNumber();
                        valueNode = columnReference;
                    } else {
                        n7 = columnReference3.getColumnNumber();
                        n6 = columnReference.getTableNumber();
                        n5 = columnReference.getColumnNumber();
                        valueNode = columnReference3;
                    }
                    PredicateList predicateList = predicateListArray[n6];
                    int n10 = 0;
                    while (n10 < predicateList.size()) {
                        block24: {
                            ValueNode valueNode2;
                            ValueNode valueNode3;
                            BinaryRelationalOperatorNode binaryRelationalOperatorNode2;
                            int n11;
                            int n12;
                            Predicate predicate2;
                            block26: {
                                ColumnReference columnReference4;
                                ColumnReference columnReference5;
                                block25: {
                                    predicate2 = (Predicate)predicateList.elementAt(n10);
                                    if (predicate2.getEquivalenceClass() != -1 && predicate2.getEquivalenceClass() != n9) break block24;
                                    BinaryRelationalOperatorNode binaryRelationalOperatorNode3 = (BinaryRelationalOperatorNode)predicate2.getAndNode().getLeftOperand();
                                    columnReference5 = (ColumnReference)binaryRelationalOperatorNode3.getLeftOperand();
                                    columnReference4 = (ColumnReference)binaryRelationalOperatorNode3.getRightOperand();
                                    if (columnReference5.getTableNumber() != n6) break block25;
                                    if (columnReference5.getColumnNumber() != n5) break block24;
                                    n12 = columnReference4.getTableNumber();
                                    n11 = columnReference4.getColumnNumber();
                                    break block26;
                                }
                                if (columnReference4.getColumnNumber() != n5) break block24;
                                n12 = columnReference5.getTableNumber();
                                n11 = columnReference5.getColumnNumber();
                            }
                            if (n8 == n12 && n7 == n11) break block24;
                            predicate2.setEquivalenceClass(n9);
                            Predicate predicate3 = null;
                            PredicateList predicateList2 = predicateListArray[n12];
                            int n13 = 0;
                            while (n13 < predicateList2.size()) {
                                block27: {
                                    int n14;
                                    int n15;
                                    block29: {
                                        block28: {
                                            predicate3 = (Predicate)predicateList2.elementAt(n13);
                                            if (predicate3.getEquivalenceClass() != -1 && predicate3.getEquivalenceClass() != n9) break block27;
                                            binaryRelationalOperatorNode2 = (BinaryRelationalOperatorNode)predicate3.getAndNode().getLeftOperand();
                                            valueNode3 = (ColumnReference)binaryRelationalOperatorNode2.getLeftOperand();
                                            valueNode2 = (ColumnReference)binaryRelationalOperatorNode2.getRightOperand();
                                            if (((ColumnReference)valueNode3).getTableNumber() != n12) break block28;
                                            if (((ColumnReference)valueNode3).getColumnNumber() != n11) break block27;
                                            n15 = ((ColumnReference)valueNode2).getTableNumber();
                                            n14 = ((ColumnReference)valueNode2).getColumnNumber();
                                            queryTreeNode = valueNode3;
                                            break block29;
                                        }
                                        if (((ColumnReference)valueNode2).getColumnNumber() != n11) break block27;
                                        n15 = ((ColumnReference)valueNode3).getTableNumber();
                                        n14 = ((ColumnReference)valueNode3).getColumnNumber();
                                        queryTreeNode = valueNode2;
                                    }
                                    if (n15 == n8 && n14 == n7) break;
                                }
                                ++n13;
                            }
                            if (n13 != predicateList2.size()) {
                                predicate3.setEquivalenceClass(n9);
                            } else {
                                binaryRelationalOperatorNode2 = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(41, ((ColumnReference)valueNode).getClone(), ((ColumnReference)queryTreeNode).getClone(), this.getContextManager());
                                binaryRelationalOperatorNode2.bindComparisonOperator();
                                valueNode3 = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                                valueNode2 = (AndNode)this.getNodeFactory().getNode(39, binaryRelationalOperatorNode2, valueNode3, this.getContextManager());
                                ((AndNode)valueNode2).postBindFixup();
                                JBitSet jBitSet = new JBitSet(n);
                                ((BinaryOperatorNode)valueNode2).categorize(jBitSet, false);
                                Predicate predicate4 = (Predicate)this.getNodeFactory().getNode(78, valueNode2, jBitSet, this.getContextManager());
                                predicate4.setEquivalenceClass(n9);
                                this.addPredicate(predicate4);
                                if (n4 != ((QueryTreeNodeVector)queryTreeNode2).size() - 1) {
                                    ((QueryTreeNodeVector)queryTreeNode2).insertElementAt(predicate4, n4 + 1);
                                } else {
                                    ((QueryTreeNodeVector)queryTreeNode2).addElement(predicate4);
                                }
                                predicateList2.addElement(predicate4);
                            }
                        }
                        ++n10;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    void searchClauseTransitiveClosure(int var1_1, boolean var2_2) throws StandardException {
        var3_3 = new PredicateList();
        var4_4 = new PredicateList();
        var5_5 = null;
        var6_6 = this.size();
        var7_7 = 0;
        while (var7_7 < var6_6) {
            block30: {
                var8_8 = (Predicate)this.elementAt(var7_7);
                var9_9 = var8_8.getAndNode();
                if (!(var9_9.getLeftOperand() instanceof RelationalOperator)) break block30;
                var10_10 = (RelationalOperator)var9_9.getLeftOperand();
                if (!((ValueNode)var10_10).isBinaryEqualsOperatorNode()) ** GOTO lbl-1000
                var11_11 = (BinaryRelationalOperatorNode)var10_10;
                var5_5 = var11_11;
                var12_15 = var11_11.getLeftOperand();
                var13_18 = var11_11.getRightOperand();
                if (var12_15 instanceof ColumnReference && var13_18 instanceof ColumnReference) {
                    var14_21 = (ColumnReference)var12_15;
                    var15_23 = (ColumnReference)var13_18;
                    if (var14_21.getSourceLevel() == var15_23.getSourceLevel() && var14_21.getTableNumber() != var15_23.getTableNumber()) {
                        var3_3.addElement(var8_8);
                    }
                } else if (var10_10 instanceof UnaryComparisonOperatorNode) {
                    if (((UnaryComparisonOperatorNode)var10_10).getOperand() instanceof ColumnReference) {
                        var4_4.addElement(var8_8);
                    }
                } else if (var10_10 instanceof BinaryComparisonOperatorNode) {
                    var11_11 = (BinaryComparisonOperatorNode)var10_10;
                    var12_15 = var11_11.getLeftOperand();
                    var13_18 = var11_11.getRightOperand();
                    if (var12_15 instanceof ColumnReference && var13_18 instanceof ConstantNode) {
                        var4_4.addElement(var8_8);
                    } else if (var13_18 instanceof ConstantNode && var12_15 instanceof ColumnReference) {
                        var11_11.swapOperands();
                        var4_4.addElement(var8_8);
                    }
                }
            }
            ++var7_7;
        }
        if (var3_3.size() == 0 || var4_4.size() == 0) {
            return;
        }
        var7_7 = 0;
        while (var7_7 < var4_4.size()) {
            var9_9 = null;
            var10_10 = (RelationalOperator)((Predicate)var4_4.elementAt(var7_7)).getAndNode().getLeftOperand();
            if (var10_10 instanceof UnaryComparisonOperatorNode) {
                var8_8 = (ColumnReference)((UnaryComparisonOperatorNode)var10_10).getOperand();
            } else {
                var8_8 = (ColumnReference)((BinaryComparisonOperatorNode)var10_10).getLeftOperand();
                var11_13 = (ConstantNode)((BinaryComparisonOperatorNode)var10_10).getRightOperand();
                var9_9 = var11_13.getValue();
            }
            var11_14 = var8_8.getTableNumber();
            var12_17 = var8_8.getColumnNumber();
            var13_20 = var3_3.size();
            var14_22 = 0;
            while (var14_22 < var13_20) {
                block31: {
                    block33: {
                        block32: {
                            var15_23 = (Predicate)var3_3.elementAt(var14_22);
                            if (var15_23.transitiveSearchClauseAdded(var10_10)) break block31;
                            var16_24 = (BinaryRelationalOperatorNode)var15_23.getAndNode().getLeftOperand();
                            var17_25 = (ColumnReference)var16_24.getLeftOperand();
                            var18_26 = (ColumnReference)var16_24.getRightOperand();
                            if (var17_25.getTableNumber() != var11_14 || var17_25.getColumnNumber() != var12_17) break block32;
                            var19_27 = var18_26;
                            break block33;
                        }
                        if (var18_26.getTableNumber() != var11_14 || var18_26.getColumnNumber() != var12_17) break block31;
                        var19_27 = var17_25;
                    }
                    var15_23.setTransitiveSearchClauseAdded(var10_10);
                    var20_28 = false;
                    var21_29 = null;
                    var22_30 = null;
                    var23_31 = var4_4.size();
                    var24_32 = 0;
                    while (var24_32 < var23_31) {
                        var25_34 = null;
                        var22_30 = (RelationalOperator)((Predicate)var4_4.elementAt(var24_32)).getAndNode().getLeftOperand();
                        if (var22_30 instanceof UnaryComparisonOperatorNode) {
                            var21_29 = (ColumnReference)((UnaryComparisonOperatorNode)var22_30).getOperand();
                        } else {
                            var21_29 = (ColumnReference)((BinaryComparisonOperatorNode)var22_30).getLeftOperand();
                            var26_35 = (ConstantNode)((BinaryComparisonOperatorNode)var22_30).getRightOperand();
                            var25_34 = var26_35.getValue();
                        }
                        if (var21_29.getTableNumber() == var19_27.getTableNumber() && var21_29.getColumnNumber() == var19_27.getColumnNumber() && (var25_34 != null && var9_9 != null && var25_34.compare((DataValueDescriptor)var9_9) == 0 || var25_34 == null && var9_9 == null) && var22_30.getOperator() == var10_10.getOperator() && var22_30.getClass().getName().equals(var10_10.getClass().getName())) {
                            var20_28 = true;
                            break;
                        }
                        ++var24_32;
                    }
                    if (!var20_28) {
                        var24_33 = var10_10.getTransitiveSearchClause((ColumnReference)var19_27.getClone());
                        if (var24_33 instanceof BinaryComparisonOperatorNode) {
                            ((BinaryComparisonOperatorNode)var24_33).bindComparisonOperator();
                        } else {
                            ((UnaryComparisonOperatorNode)var24_33).bindComparisonOperator();
                        }
                        var25_34 = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                        var26_35 = (AndNode)this.getNodeFactory().getNode(39, var24_33, var25_34, this.getContextManager());
                        var26_35.postBindFixup();
                        var27_36 = new JBitSet(var1_1);
                        var26_35.categorize(var27_36, false);
                        var28_37 = (Predicate)this.getNodeFactory().getNode(78, var26_35, var27_36, this.getContextManager());
                        this.addPredicate(var28_37);
                        var4_4.addElement(var28_37);
                    }
                }
                ++var14_22;
            }
            ++var7_7;
        }
        if (var2_2) {
            return;
        }
        var7_7 = this.size() - 1;
        while (var7_7 >= 0) {
            var8_8 = (Predicate)this.elementAt(var7_7);
            if (var8_8.transitiveSearchClauseAdded(var5_5)) {
                this.removeElementAt(var7_7);
            }
            --var7_7;
        }
    }

    void removeRedundantPredicates() {
        int n = this.size() - 1;
        while (n >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n);
            int n2 = predicate.getEquivalenceClass();
            if (n2 == -1) {
                --n;
                continue;
            }
            int n3 = n - 1;
            while (n3 >= 0) {
                Predicate predicate2 = (Predicate)this.elementAt(n3);
                if (predicate2.getEquivalenceClass() == n2) {
                    if (predicate2.isStartKey()) {
                        predicate.markStartKey();
                    }
                    if (predicate2.isStopKey()) {
                        predicate.markStopKey();
                    }
                    if ((predicate2.isStartKey() || predicate2.isStopKey()) && predicate2.isQualifier() && !predicate.isQualifier()) {
                        predicate.markQualifier();
                        ++this.numberOfQualifiers;
                    }
                    if (predicate2.isQualifier()) {
                        --this.numberOfQualifiers;
                    }
                    this.removeElementAt(n3);
                    --n;
                }
                --n3;
            }
            --n;
        }
    }

    public void transferPredicates(OptimizablePredicateList optimizablePredicateList, JBitSet jBitSet, Optimizable optimizable) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        int n = this.size() - 1;
        while (n >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n);
            if (jBitSet.contains(predicate.getReferencedSet())) {
                if (predicate.isStartKey()) {
                    --this.numberOfStartPredicates;
                }
                if (predicate.isStopKey()) {
                    --this.numberOfStopPredicates;
                }
                if (predicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                predicate.clearScanFlags();
                predicateList.addPredicate(predicate);
                this.removeElementAt(n);
            }
            --n;
        }
        AccessPath accessPath = optimizable.getTrulyTheBestAccessPath();
        predicateList.orderUsefulPredicates(optimizable, accessPath.getConglomerateDescriptor(), false, accessPath.getNonMatchingIndexScan(), accessPath.getCoveringIndexScan());
        predicateList.countScanFlags();
    }

    public void transferAllPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            predicate.clearScanFlags();
            predicateList.addPredicate(predicate);
            ++n2;
        }
        this.removeAllElements();
        this.numberOfStartPredicates = 0;
        this.numberOfStopPredicates = 0;
        this.numberOfQualifiers = 0;
    }

    public void copyPredicatesToOtherList(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        int n = 0;
        while (n < this.size()) {
            optimizablePredicateList.addOptPredicate(this.getOptPredicate(n));
            ++n;
        }
    }

    public boolean isRedundantPredicate(int n) {
        Predicate predicate = (Predicate)this.elementAt(n);
        if (predicate.getEquivalenceClass() == -1) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (((Predicate)this.elementAt(n2)).getEquivalenceClass() == predicate.getEquivalenceClass()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setPredicatesAndProperties(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        predicateList.removeAllElements();
        int n = 0;
        while (n < this.size()) {
            predicateList.addOptPredicate(this.getOptPredicate(n));
            ++n;
        }
        predicateList.numberOfStartPredicates = this.numberOfStartPredicates;
        predicateList.numberOfStopPredicates = this.numberOfStopPredicates;
        predicateList.numberOfQualifiers = this.numberOfQualifiers;
    }

    public int startOperator(Optimizable optimizable) {
        int n = -1;
        int n2 = this.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            if (predicate.isStartKey()) {
                n = predicate.getStartOperator(optimizable);
                break;
            }
            --n3;
        }
        return n;
    }

    public void generateStopKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStopPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStopPredicates);
            int n = 0;
            int n2 = this.size();
            int n3 = 0;
            while (n3 < n2) {
                Predicate predicate = (Predicate)this.elementAt(n3);
                if (predicate.isStopKey()) {
                    this.generateSetColumn(expressionClassBuilder, methodBuilder2, n, predicate, optimizable, localField, false);
                    ++n;
                }
                ++n3;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    public int stopOperator(Optimizable optimizable) {
        int n = -1;
        int n2 = this.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            if (predicate.isStopKey()) {
                n = predicate.getStopOperator(optimizable);
                break;
            }
            --n3;
        }
        return n;
    }

    private void generateSingleQualifierCode(MethodBuilder methodBuilder, Optimizable optimizable, boolean bl, ExpressionClassBuilder expressionClassBuilder, RelationalOperator relationalOperator, LocalField localField, int n, int n2) throws StandardException {
        methodBuilder.getField(localField);
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)182, expressionClassBuilder.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory", 0);
        if (bl) {
            relationalOperator.generateAbsoluteColumnId(methodBuilder, optimizable);
        } else {
            relationalOperator.generateRelativeColumnId(methodBuilder, optimizable);
        }
        relationalOperator.generateOperator(methodBuilder, optimizable);
        relationalOperator.generateQualMethod(expressionClassBuilder, methodBuilder, optimizable);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        relationalOperator.generateOrderedNulls(methodBuilder);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        relationalOperator.generateNegate(methodBuilder, optimizable);
        methodBuilder.push(relationalOperator.getOrderableVariantType(optimizable));
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getQualifier", "org.apache.derby.iapi.store.access.Qualifier", 8);
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "setQualifier", "void", 4);
    }

    public void generateQualifiers(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable, boolean bl) throws StandardException {
        int n;
        int n2;
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        String string = "org.apache.derby.iapi.store.access.Qualifier[][]";
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getExecuteMethod();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        methodBuilder3.getField(localField);
        methodBuilder3.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "reinitializeQualifiers", "void", 1);
        if (this.numberOfQualifiers != 0) {
            n2 = 0;
            n = 0;
            while (n < this.numberOfQualifiers) {
                if (((Predicate)this.elementAt(n)).isOrList()) {
                    ++n2;
                }
                ++n;
            }
            methodBuilder2.pushNewArray("org.apache.derby.iapi.store.access.Qualifier[]", n2 + 1);
            methodBuilder2.putField(localField);
            methodBuilder2.endStatement();
            methodBuilder2.getField(localField);
            methodBuilder2.push(0);
            methodBuilder2.push(this.numberOfQualifiers - n2);
            methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
        }
        if (this.numberOfQualifiers > 0) {
            this.orderQualifiers();
        }
        n2 = 0;
        n = this.size();
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            Predicate predicate = (Predicate)this.elementAt(n3);
            if (predicate.isQualifier()) {
                if (predicate.isOrList()) {
                    bl2 = true;
                    break;
                }
                this.generateSingleQualifierCode(methodBuilder2, optimizable, bl, expressionClassBuilder, predicate.getRelop(), localField, 0, n2);
                ++n2;
            }
            ++n3;
        }
        if (bl2) {
            n3 = 1;
            int n4 = n2;
            while (n4 < n) {
                Predicate predicate = (Predicate)this.elementAt(n4);
                ArrayList<ValueNode> arrayList = new ArrayList<ValueNode>();
                ValueNode valueNode = predicate.getAndNode().getLeftOperand();
                while (valueNode instanceof OrNode) {
                    OrNode orNode = (OrNode)valueNode;
                    if (orNode.getLeftOperand() instanceof RelationalOperator) {
                        arrayList.add(orNode.getLeftOperand());
                    }
                    valueNode = orNode.getRightOperand();
                }
                methodBuilder2.getField(localField);
                methodBuilder2.push(n3);
                methodBuilder2.push(arrayList.size());
                methodBuilder2.callMethod((short)184, expressionClassBuilder.getBaseClassName(), "allocateQualArray", "void", 3);
                int n5 = 0;
                while (n5 < arrayList.size()) {
                    this.generateSingleQualifierCode(methodBuilder2, optimizable, bl, expressionClassBuilder, (RelationalOperator)arrayList.get(n5), localField, n3, n5);
                    ++n5;
                }
                ++n2;
                ++n4;
                ++n3;
            }
        }
        methodBuilder.getField(localField);
    }

    private void orderQualifiers() {
        PredicateList[] predicateListArray = new PredicateList[5];
        int n = predicateListArray.length - 1;
        while (n >= 0) {
            predicateListArray[n] = new PredicateList();
            --n;
        }
        int n2 = this.size();
        n = 0;
        while (n < n2) {
            Predicate predicate = (Predicate)this.elementAt(n);
            if (!predicate.isQualifier()) {
                predicateListArray[3].addElement(predicate);
            } else {
                AndNode andNode = predicate.getAndNode();
                if (!(andNode.getLeftOperand() instanceof OrNode)) {
                    RelationalOperator relationalOperator = (RelationalOperator)((Object)andNode.getLeftOperand());
                    int n3 = relationalOperator.getOperator();
                    switch (n3) {
                        case 1: 
                        case 7: {
                            predicateListArray[0].addElement(predicate);
                            break;
                        }
                        case 2: 
                        case 8: {
                            predicateListArray[2].addElement(predicate);
                            break;
                        }
                        default: {
                            predicateListArray[1].addElement(predicate);
                            break;
                        }
                    }
                } else {
                    predicateListArray[4].addElement(predicate);
                }
            }
            ++n;
        }
        n = 0;
        int n4 = 0;
        while (n4 < 5) {
            int n5 = 0;
            while (n5 < predicateListArray[n4].size()) {
                this.setElementAt(predicateListArray[n4].elementAt(n5), n++);
                ++n5;
            }
            ++n4;
        }
    }

    public void generateStartKey(ExpressionClassBuilderInterface expressionClassBuilderInterface, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        if (this.numberOfStartPredicates != 0) {
            MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
            LocalField localField = this.generateIndexableRow(expressionClassBuilder, this.numberOfStartPredicates);
            int n = 0;
            int n2 = this.size();
            int n3 = 0;
            while (n3 < n2) {
                Predicate predicate = (Predicate)this.elementAt(n3);
                if (predicate.isStartKey()) {
                    this.generateSetColumn(expressionClassBuilder, methodBuilder2, n, predicate, optimizable, localField, true);
                    ++n;
                }
                ++n3;
            }
            this.finishKey(expressionClassBuilder, methodBuilder, methodBuilder2, localField);
            return;
        }
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    public boolean sameStartStopPosition() throws StandardException {
        if (this.numberOfStartPredicates != this.numberOfStopPredicates) {
            return false;
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            if (predicate.isStartKey() && !predicate.isStopKey() || predicate.isStopKey() && !predicate.isStartKey()) {
                return false;
            }
            if (predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private LocalField generateIndexableRow(ExpressionClassBuilder expressionClassBuilder, int n) {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getIndexableRow", "org.apache.derby.iapi.sql.execute.ExecIndexRow", 1);
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecIndexRow");
        methodBuilder.putField(localField);
        methodBuilder.endStatement();
        return localField;
    }

    private void generateSetColumn(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n, Predicate predicate, Optimizable optimizable, LocalField localField, boolean bl) throws StandardException {
        Object object;
        MethodBuilder methodBuilder2;
        boolean bl2 = false;
        if (predicate.compareWithKnownConstant(optimizable, false)) {
            bl2 = true;
            methodBuilder2 = expressionClassBuilder.getConstructor();
        } else {
            methodBuilder2 = methodBuilder;
        }
        int[] nArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().baseColumnPositions();
        boolean[] blArray = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().isAscending();
        boolean bl3 = predicate.getAndNode().getLeftOperand() instanceof InListOperatorNode;
        methodBuilder2.getField(localField);
        methodBuilder2.push(n + 1);
        if (bl3) {
            object = (InListOperatorNode)predicate.getAndNode().getLeftOperand();
            ((InListOperatorNode)object).generateStartStopKey(blArray[n], bl, expressionClassBuilder, methodBuilder2);
        } else {
            predicate.generateExpressionOperand(optimizable, nArray[n], expressionClassBuilder, methodBuilder2);
        }
        methodBuilder2.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        if (!bl3) {
            object = predicate.getRelop();
            boolean bl4 = object.orderedNulls();
            if (!bl4 && !object.getColumnOperand(optimizable).getTypeServices().isNullable()) {
                if (bl2) {
                    bl4 = true;
                } else {
                    ValueNode valueNode = object.getExpressionOperand(optimizable.getTableNumber(), nArray[n]);
                    if (valueNode instanceof ColumnReference) {
                        boolean bl5 = bl4 = !((ColumnReference)valueNode).getTypeServices().isNullable();
                    }
                }
            }
            if (bl4) {
                methodBuilder2.getField(localField);
                methodBuilder2.push(n);
                methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecIndexRow", "orderedNulls", "void", 1);
            }
        }
    }

    private void finishKey(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, MethodBuilder methodBuilder2, LocalField localField) {
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    boolean constantColumn(ColumnReference columnReference) {
        boolean bl = false;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Predicate predicate = (Predicate)this.elementAt(n2);
            RelationalOperator relationalOperator = predicate.getRelop();
            if (relationalOperator != null && relationalOperator.getOperator() == 1) {
                ValueNode valueNode;
                if (relationalOperator.getOperator() == 1) {
                    valueNode = relationalOperator.getExpressionOperand(columnReference.getTableNumber(), columnReference.getColumnNumber());
                    if (valueNode != null && valueNode.isConstantExpression()) {
                        bl = true;
                        break;
                    }
                } else if (relationalOperator.getOperator() == 7 && (valueNode = relationalOperator.getColumnOperand(columnReference.getTableNumber(), columnReference.getColumnNumber())) != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        return bl;
    }

    public double selectivity(Optimizable optimizable) throws StandardException {
        int n;
        Object object;
        TableDescriptor tableDescriptor = optimizable.getTableDescriptor();
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n2 = this.size();
        int n3 = conglomerateDescriptorArray.length;
        if (n3 == 1) {
            return -1.0;
        }
        if (n2 == 0) {
            return -1.0;
        }
        boolean bl = true;
        PredicateList predicateList = new PredicateList();
        int n4 = 0;
        while (n4 < n2) {
            if (!this.isRedundantPredicate(n4)) {
                predicateList.addOptPredicate((Predicate)this.elementAt(n4));
            }
            ++n4;
        }
        n4 = predicateList.size();
        PredicateWrapperList[] predicateWrapperListArray = new PredicateWrapperList[n3];
        int n5 = 0;
        while (n5 < n3) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n5];
            if (conglomerateDescriptor.isIndex() && tableDescriptor.statisticsExist(conglomerateDescriptor)) {
                int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
                int n6 = 0;
                while (n6 < n4) {
                    object = (Predicate)predicateList.elementAt(n6);
                    n = ((Predicate)object).hasEqualOnColumnList(nArray, optimizable);
                    if (n >= 0) {
                        bl = false;
                        if (predicateWrapperListArray[n5] == null) {
                            predicateWrapperListArray[n5] = new PredicateWrapperList(n4);
                        }
                        PredicateWrapper predicateWrapper = new PredicateWrapper(n, (Predicate)object, n6);
                        predicateWrapperListArray[n5].insert(predicateWrapper);
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        if (bl) {
            return -1.0;
        }
        n5 = -1;
        int n7 = 0;
        while (n7 < n3) {
            if (predicateWrapperListArray[n7] != null) {
                predicateWrapperListArray[n7].retainLeadingContiguous();
            }
            ++n7;
        }
        this.calculateWeight(predicateWrapperListArray, n4);
        Vector vector = new Vector(n4);
        double d = 1.0;
        object = new Vector();
        do {
            ((Vector)object).removeAllElements();
            n = this.chooseLongestMatch(predicateWrapperListArray, (Vector)object, n4);
            if (n == -1) break;
            d *= tableDescriptor.selectivityForConglomerate(conglomerateDescriptorArray[n], ((Vector)object).size());
            int n8 = 0;
            while (n8 < ((Vector)object).size()) {
                Predicate predicate = (Predicate)((Vector)object).elementAt(n8);
                predicateList.removeOptPredicate(predicate);
                ++n8;
            }
        } while (predicateList.size() != 0);
        if (predicateList.size() != 0) {
            d *= predicateList.selectivityNoStatistics(optimizable);
        }
        return d;
    }

    private void calculateWeight(PredicateWrapperList[] predicateWrapperListArray, int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < predicateWrapperListArray.length) {
            if (predicateWrapperListArray[n3] != null) {
                n2 = 0;
                while (n2 < predicateWrapperListArray[n3].size()) {
                    int n4 = predicateWrapperListArray[n3].elementAt(n2).getPredicateID();
                    nArray[n4] = nArray[n4] + (n - n2);
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < predicateWrapperListArray.length) {
            n2 = 0;
            if (predicateWrapperListArray[n3] != null) {
                int n5 = 0;
                while (n5 < predicateWrapperListArray[n3].size()) {
                    n2 += nArray[predicateWrapperListArray[n3].elementAt(n5).getPredicateID()];
                    ++n5;
                }
                predicateWrapperListArray[n3].setWeight(n2);
            }
            ++n3;
        }
    }

    private int chooseLongestMatch(PredicateWrapperList[] predicateWrapperListArray, Vector vector, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        while (n5 < predicateWrapperListArray.length) {
            if (predicateWrapperListArray[n5] != null && predicateWrapperListArray[n5].uniqueSize() != 0) {
                if (predicateWrapperListArray[n5].uniqueSize() > n2) {
                    n2 = predicateWrapperListArray[n5].uniqueSize();
                    n4 = n5;
                    n3 = predicateWrapperListArray[n5].getWeight();
                }
                if (predicateWrapperListArray[n5].uniqueSize() == n2 && predicateWrapperListArray[n5].getWeight() <= n3) {
                    n4 = n5;
                    n2 = predicateWrapperListArray[n5].uniqueSize();
                    n3 = predicateWrapperListArray[n5].getWeight();
                }
            }
            ++n5;
        }
        if (n4 == -1) {
            return -1;
        }
        PredicateWrapperList predicateWrapperList = predicateWrapperListArray[n4];
        Vector vector2 = predicateWrapperList.createLeadingUnique();
        int n6 = 0;
        while (n6 < vector2.size()) {
            Predicate predicate = ((PredicateWrapper)vector2.elementAt(n6)).getPredicate();
            vector.addElement(predicate);
            int n7 = 0;
            while (n7 < predicateWrapperListArray.length) {
                if (predicateWrapperListArray[n7] != null) {
                    predicateWrapperList = predicateWrapperListArray[n7];
                    predicateWrapperList.removeElement(predicate);
                }
                ++n7;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < predicateWrapperListArray.length) {
            if (predicateWrapperListArray[n6] != null) {
                predicateWrapperListArray[n6].retainLeadingContiguous();
            }
            ++n6;
        }
        this.calculateWeight(predicateWrapperListArray, n);
        return n4;
    }

    private double selectivityNoStatistics(Optimizable optimizable) {
        double d = 1.0;
        int n = 0;
        while (n < this.size()) {
            OptimizablePredicate optimizablePredicate = (OptimizablePredicate)((Object)this.elementAt(n));
            d *= optimizablePredicate.selectivity(optimizable);
            ++n;
        }
        return d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PredicateWrapper {
        int indexPosition;
        Predicate pred;
        int predicateID;

        int getIndexPosition() {
            return this.indexPosition;
        }

        Predicate getPredicate() {
            return this.pred;
        }

        int getPredicateID() {
            return this.predicateID;
        }

        boolean before(PredicateWrapper predicateWrapper) {
            return this.indexPosition < predicateWrapper.getIndexPosition();
        }

        boolean contiguous(PredicateWrapper predicateWrapper) {
            int n = predicateWrapper.getIndexPosition();
            return this.indexPosition == n || this.indexPosition - n == 1 || this.indexPosition - n == -1;
        }

        PredicateWrapper(int n, Predicate predicate, int n2) {
            this.indexPosition = n;
            this.pred = predicate;
            this.predicateID = n2;
        }
    }

    private class PredicateWrapperList {
        Vector pwList;
        int numPreds;
        int numDuplicates;
        int weight;

        void removeElement(PredicateWrapper predicateWrapper) {
            int n = this.pwList.indexOf(predicateWrapper);
            if (n >= 0) {
                this.removeElementAt(n);
            }
        }

        void removeElement(Predicate predicate) {
            int n = this.numPreds - 1;
            while (n >= 0) {
                Predicate predicate2 = this.elementAt(n).getPredicate();
                if (predicate2 == predicate) {
                    this.removeElementAt(n);
                }
                --n;
            }
        }

        void removeElementAt(int n) {
            PredicateWrapper predicateWrapper;
            if (n < this.numPreds - 1 && (predicateWrapper = this.elementAt(n + 1)).getIndexPosition() == n) {
                --this.numDuplicates;
            }
            this.pwList.removeElementAt(n);
            --this.numPreds;
        }

        PredicateWrapper elementAt(int n) {
            return (PredicateWrapper)this.pwList.elementAt(n);
        }

        void insert(PredicateWrapper predicateWrapper) {
            int n = 0;
            while (n < this.pwList.size()) {
                if (predicateWrapper.getIndexPosition() == this.elementAt(n).getIndexPosition()) {
                    ++this.numDuplicates;
                }
                if (predicateWrapper.before(this.elementAt(n))) break;
                ++n;
            }
            ++this.numPreds;
            this.pwList.insertElementAt(predicateWrapper, n);
        }

        int size() {
            return this.numPreds;
        }

        int uniqueSize() {
            if (this.numPreds > 0) {
                return this.numPreds - this.numDuplicates;
            }
            return 0;
        }

        void retainLeadingContiguous() {
            if (this.pwList == null) {
                return;
            }
            if (this.pwList.size() == 0) {
                return;
            }
            if (this.elementAt(0).getIndexPosition() != 0) {
                this.pwList.removeAllElements();
                this.numDuplicates = 0;
                this.numPreds = 0;
                return;
            }
            int n = 0;
            while (n < this.numPreds - 1) {
                if (!this.elementAt(n).contiguous(this.elementAt(n + 1))) break;
                ++n;
            }
            int n2 = this.numPreds - 1;
            while (n2 > n) {
                if (this.elementAt(n2).getIndexPosition() == this.elementAt(n2 - 1).getIndexPosition()) {
                    --this.numDuplicates;
                }
                this.pwList.removeElementAt(n2);
                --n2;
            }
            this.numPreds = n + 1;
        }

        Vector createLeadingUnique() {
            Vector<PredicateWrapper> vector = new Vector<PredicateWrapper>();
            if (this.numPreds == 0) {
                return null;
            }
            int n = this.elementAt(0).getIndexPosition();
            if (n != 0) {
                return null;
            }
            vector.addElement(this.elementAt(0));
            int n2 = 1;
            while (n2 < this.numPreds) {
                if (this.elementAt(n2).getIndexPosition() != n) {
                    n = this.elementAt(n2).getIndexPosition();
                    vector.addElement(this.elementAt(n2));
                }
                ++n2;
            }
            return vector;
        }

        void setWeight(int n) {
            this.weight = n;
        }

        int getWeight() {
            return this.weight;
        }

        PredicateWrapperList(int n) {
            this.pwList = new Vector(n);
        }
    }
}

