/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.RowOrderingImpl;

public class OptimizerImpl
implements Optimizer {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int NO_JUMP = 0;
    private static final int READY_TO_JUMP = 1;
    private static final int JUMPING = 2;
    private static final int WALK_HIGH = 3;
    private static final int WALK_LOW = 4;
    DataDictionary dDictionary;
    int numTablesInQuery;
    int numOptimizables;
    protected JBitSet assignedTableMap;
    protected OptimizableList optimizableList;
    OptimizablePredicateList predicateList;
    JBitSet nonCorrelatedTableMap;
    protected int[] proposedJoinOrder;
    protected int[] bestJoinOrder;
    protected int joinPosition;
    boolean desiredJoinOrderFound;
    private int permuteState;
    private int[] firstLookOrder;
    private boolean ruleBasedOptimization;
    private CostEstimateImpl outermostCostEstimate;
    protected CostEstimateImpl currentCost;
    protected CostEstimateImpl currentSortAvoidanceCost;
    protected CostEstimateImpl bestCost;
    protected long timeOptimizationStarted;
    protected long currentTime;
    protected boolean timeExceeded;
    private boolean noTimeout;
    private boolean useStatistics;
    private int tableLockThreshold;
    private JoinStrategy[] joinStrategies;
    protected RequiredRowOrdering requiredRowOrdering;
    private boolean foundABestPlan;
    protected CostEstimate sortCost;
    private RowOrdering currentRowOrdering = new RowOrderingImpl();
    private RowOrdering bestRowOrdering = new RowOrderingImpl();
    private boolean conglomerate_OneRowResultSet;
    protected boolean optimizerTrace;
    protected boolean optimizerTraceHtml;
    protected int maxMemoryPerTable;

    public boolean getNextPermutation() throws StandardException {
        if (this.numOptimizables < 1) {
            if (this.optimizerTrace) {
                this.trace(3, 0, 0, 0.0, null);
            }
            return false;
        }
        this.optimizableList.initAccessPaths(this);
        if (!this.timeExceeded && this.numTablesInQuery > 6 && !this.noTimeout) {
            this.currentTime = System.currentTimeMillis();
            boolean bl = this.timeExceeded = (double)(this.currentTime - this.timeOptimizationStarted) > this.bestCost.getEstimatedCost();
            if (this.optimizerTrace && this.timeExceeded) {
                this.trace(2, 0, 0, 0.0, null);
            }
        }
        boolean bl = false;
        if (this.joinPosition < this.numOptimizables - 1 && (this.currentCost.compare(this.bestCost) < 0.0 || this.currentSortAvoidanceCost.compare(this.bestCost) < 0.0) && !this.timeExceeded) {
            if (this.joinPosition < 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]).getBestAccessPath().getCostEstimate() != null) {
                ++this.joinPosition;
                bl = true;
                this.bestRowOrdering.copy(this.currentRowOrdering);
            }
        } else if (this.optimizerTrace && this.joinPosition < this.numOptimizables - 1) {
            this.trace(8, 0, 0, 0.0, null);
        }
        if (this.permuteState == 2 && !bl && this.joinPosition >= 0) {
            this.rewindJoinOrder();
            this.permuteState = 0;
        }
        while (this.joinPosition >= 0) {
            int n;
            Object object;
            int n2 = 0;
            if (this.desiredJoinOrderFound || this.timeExceeded) {
                n2 = this.numOptimizables;
            } else if (this.permuteState == 2) {
                n2 = this.firstLookOrder[this.joinPosition];
                object = this.optimizableList.getOptimizable(n2);
                if (!object.legalJoinOrder(this.assignedTableMap)) {
                    if (this.joinPosition < this.numOptimizables - 1) {
                        this.firstLookOrder[this.joinPosition] = this.firstLookOrder[this.numOptimizables - 1];
                        this.firstLookOrder[this.numOptimizables - 1] = n2;
                    } else {
                        this.permuteState = 0;
                    }
                    if (this.joinPosition <= 0) continue;
                    --this.joinPosition;
                    this.rewindJoinOrder();
                    continue;
                }
                if (this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 3;
                }
            } else {
                n2 = this.proposedJoinOrder[this.joinPosition] + 1;
                while (n2 < this.numOptimizables) {
                    Optimizable optimizable;
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 < this.joinPosition) {
                        if (this.proposedJoinOrder[n3] == n2) {
                            bl2 = true;
                            break;
                        }
                        ++n3;
                    }
                    if (n2 < this.numOptimizables && !(optimizable = this.optimizableList.getOptimizable(n2)).legalJoinOrder(this.assignedTableMap)) {
                        if (this.optimizerTrace) {
                            this.trace(9, n2, 0, 0.0, null);
                        }
                        if (!this.optimizableList.optimizeJoinOrder()) {
                            if (this.optimizerTrace) {
                                this.trace(10, 0, 0, 0.0, null);
                            }
                            throw StandardException.newException("42Y70");
                        }
                    } else if (!bl2) break;
                    ++n2;
                }
            }
            if (this.proposedJoinOrder[this.joinPosition] >= 0) {
                double d;
                double d2;
                object = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
                n = 0;
                if (this.joinPosition == 0) {
                    d2 = this.outermostCostEstimate.rowCount();
                    d = this.outermostCostEstimate.singleScanRowCount();
                } else {
                    n = this.proposedJoinOrder[this.joinPosition - 1];
                    CostEstimate costEstimate = this.optimizableList.getOptimizable(n).getBestAccessPath().getCostEstimate();
                    d2 = costEstimate.rowCount();
                    d = costEstimate.singleScanRowCount();
                }
                double d3 = this.currentCost.getEstimatedCost();
                double d4 = 0.0;
                CostEstimate costEstimate = object.getBestAccessPath().getCostEstimate();
                if (costEstimate != null && (d3 -= (d4 = costEstimate.getEstimatedCost())) < 0.0) {
                    d3 = 0.0;
                }
                if (this.joinPosition == 0) {
                    d3 = this.outermostCostEstimate != null ? this.outermostCostEstimate.getEstimatedCost() : 0.0;
                }
                this.currentCost.setCost(d3, d2, d);
                if (this.requiredRowOrdering != null && object.considerSortAvoidancePath()) {
                    AccessPath accessPath = object.getBestSortAvoidancePath();
                    double d5 = 0.0;
                    if (this.joinPosition == 0) {
                        d2 = this.outermostCostEstimate.rowCount();
                        d = this.outermostCostEstimate.singleScanRowCount();
                        d5 = this.outermostCostEstimate.getEstimatedCost();
                    } else {
                        CostEstimate costEstimate2 = this.optimizableList.getOptimizable(n).getBestSortAvoidancePath().getCostEstimate();
                        d2 = costEstimate2.rowCount();
                        d = costEstimate2.singleScanRowCount();
                        d5 = this.currentSortAvoidanceCost.getEstimatedCost() - accessPath.getCostEstimate().getEstimatedCost();
                    }
                    this.currentSortAvoidanceCost.setCost(d5, d2, d);
                    this.bestRowOrdering.removeOptimizable(object.getTableNumber());
                    this.bestRowOrdering.copy(this.currentRowOrdering);
                }
                object.pullOptPredicates(this.predicateList);
                this.proposedJoinOrder[this.joinPosition] = -1;
            }
            if (n2 >= this.numOptimizables) {
                if (!this.optimizableList.optimizeJoinOrder()) {
                    if (!this.optimizableList.legalJoinOrder(this.numTablesInQuery)) {
                        if (this.optimizerTrace) {
                            this.trace(10, 0, 0, 0.0, null);
                        }
                        throw StandardException.newException("42Y70");
                    }
                    if (this.optimizerTrace) {
                        this.trace(11, 0, 0, 0.0, null);
                    }
                    this.desiredJoinOrderFound = true;
                }
                if (this.permuteState == 1 && this.joinPosition > 0 && this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 2;
                    object = new double[this.numOptimizables];
                    int n4 = 0;
                    while (n4 < this.numOptimizables) {
                        this.firstLookOrder[n4] = n4;
                        CostEstimate costEstimate = this.optimizableList.getOptimizable(n4).getBestAccessPath().getCostEstimate();
                        if (costEstimate == null) {
                            this.permuteState = 1;
                            break;
                        }
                        object[n4] = costEstimate.singleScanRowCount();
                        ++n4;
                    }
                    if (this.permuteState == 2) {
                        n4 = 0;
                        int n5 = 0;
                        while (n5 < this.numOptimizables) {
                            int n6 = n5;
                            n = n5 + 1;
                            while (n < this.numOptimizables) {
                                if (object[n] < object[n6]) {
                                    n6 = n;
                                }
                                ++n;
                            }
                            if (n6 != n5) {
                                object[n6] = object[n5];
                                int n7 = this.firstLookOrder[n5];
                                this.firstLookOrder[n5] = this.firstLookOrder[n6];
                                this.firstLookOrder[n6] = n7;
                                n4 = 1;
                            }
                            ++n5;
                        }
                        if (n4 != 0) {
                            --this.joinPosition;
                            this.rewindJoinOrder();
                            continue;
                        }
                        this.permuteState = 0;
                    }
                }
                --this.joinPosition;
                if (this.joinPosition >= 0) {
                    object = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
                    this.assignedTableMap.xor(object.getReferencedTableMap());
                }
                if (this.joinPosition >= 0 || this.permuteState != 3) continue;
                this.joinPosition = 0;
                this.permuteState = 4;
                continue;
            }
            this.proposedJoinOrder[this.joinPosition] = n2;
            if (this.permuteState == 4) {
                boolean bl3 = true;
                int n8 = 0;
                while (n8 < this.numOptimizables) {
                    if (this.proposedJoinOrder[n8] < this.firstLookOrder[n8]) {
                        bl3 = false;
                        break;
                    }
                    if (this.proposedJoinOrder[n8] > this.firstLookOrder[n8]) break;
                    ++n8;
                }
                if (bl3) {
                    --this.joinPosition;
                    if (this.joinPosition >= 0) {
                        this.rewindJoinOrder();
                        this.joinPosition = -1;
                    }
                    this.permuteState = 1;
                    return false;
                }
            }
            this.optimizableList.getOptimizable(n2).getBestAccessPath().setCostEstimate(null);
            this.assignedTableMap.clearAll();
            int n9 = 0;
            while (n9 <= this.joinPosition) {
                this.assignedTableMap.or(this.optimizableList.getOptimizable(this.proposedJoinOrder[n9]).getReferencedTableMap());
                ++n9;
            }
            if (this.optimizerTrace) {
                this.trace(12, 0, 0, 0.0, null);
            }
            Optimizable optimizable = this.optimizableList.getOptimizable(n2);
            optimizable.startOptimizing(this, this.currentRowOrdering);
            this.pushPredicates(this.optimizableList.getOptimizable(n2), this.assignedTableMap);
            return true;
        }
        return false;
    }

    private void rewindJoinOrder() throws StandardException {
        while (true) {
            Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            optimizable.pullOptPredicates(this.predicateList);
            this.proposedJoinOrder[this.joinPosition] = -1;
            if (this.joinPosition == 0) break;
            --this.joinPosition;
        }
        this.currentCost.setCost(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost.setCost(0.0, 0.0, 0.0);
        this.assignedTableMap.clearAll();
    }

    void pushPredicates(Optimizable optimizable, JBitSet jBitSet) throws StandardException {
        int n = this.predicateList.size();
        JBitSet jBitSet2 = new JBitSet(this.numTablesInQuery);
        int n2 = n - 1;
        while (n2 >= 0) {
            OptimizablePredicate optimizablePredicate = this.predicateList.getOptPredicate(n2);
            if (this.isPushable(optimizablePredicate)) {
                jBitSet2.setTo(optimizablePredicate.getReferencedMap());
                int n3 = 0;
                while (n3 < jBitSet2.size()) {
                    if (jBitSet.get(n3)) {
                        jBitSet2.clear(n3);
                    }
                    ++n3;
                }
                jBitSet2.and(this.nonCorrelatedTableMap);
                if (jBitSet2.getFirstSetBit() == -1 && optimizable.pushOptPredicate(optimizablePredicate)) {
                    this.predicateList.removeOptPredicate(n2);
                }
            }
            --n2;
        }
    }

    public boolean getNextDecoratedPermutation() throws StandardException {
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        double d = 0.0;
        boolean bl = optimizable.nextAccessPath(this, null, this.currentRowOrdering);
        CostEstimate costEstimate = optimizable.getBestAccessPath().getCostEstimate();
        if (!bl && costEstimate != null) {
            this.currentCost.setCost(this.currentCost.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
            if (optimizable.considerSortAvoidancePath() && this.requiredRowOrdering != null) {
                costEstimate = optimizable.getBestSortAvoidancePath().getCostEstimate();
                this.currentSortAvoidanceCost.setCost(this.currentSortAvoidanceCost.getEstimatedCost() + costEstimate.getEstimatedCost(), costEstimate.rowCount(), costEstimate.singleScanRowCount());
            }
            if (this.optimizerTrace) {
                this.trace(13, 0, 0, 0.0, null);
                if (optimizable.considerSortAvoidancePath()) {
                    this.trace(14, 0, 0, 0.0, null);
                }
            }
            if (this.joinPosition == this.numOptimizables - 1) {
                if (this.optimizerTrace) {
                    this.trace(4, 0, 0, 0.0, null);
                }
                if (this.requiredRowOrdering != null) {
                    boolean bl2 = false;
                    if (this.sortCost == null) {
                        this.sortCost = this.newCostEstimate();
                    } else if (this.requiredRowOrdering.getSortNeeded()) {
                        if (this.bestCost.rowCount() > this.currentCost.rowCount()) {
                            this.requiredRowOrdering.estimateCost(this.bestCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            double d2 = this.sortCost.getEstimatedCost();
                            this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            bl2 = true;
                            this.bestCost.setCost(this.bestCost.getEstimatedCost() - d2 + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                        } else if (this.bestCost.rowCount() < this.currentCost.rowCount()) {
                            this.currentCost.setCost(this.currentCost.getEstimatedCost(), this.bestCost.rowCount(), this.currentCost.singleScanRowCount());
                        }
                    }
                    if (!bl2) {
                        this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                    }
                    d = this.currentCost.rowCount();
                    this.currentCost.setCost(this.currentCost.getEstimatedCost() + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                    if (this.optimizerTrace) {
                        this.trace(5, 0, 0, 0.0, null);
                        this.trace(15, 0, 0, 0.0, null);
                    }
                }
                if (!this.foundABestPlan || this.currentCost.compare(this.bestCost) < 0.0) {
                    this.rememberBestCost(this.currentCost, 1);
                }
                if (this.requiredRowOrdering != null) {
                    double d3 = this.currentCost.getEstimatedCost() - this.sortCost.getEstimatedCost();
                    if (d3 < 0.0) {
                        d3 = 0.0;
                    }
                    this.currentCost.setCost(d3, d, this.currentCost.singleScanRowCount());
                }
                if (this.requiredRowOrdering != null && optimizable.considerSortAvoidancePath() && this.requiredRowOrdering.sortRequired(this.bestRowOrdering) == 3) {
                    if (this.optimizerTrace) {
                        this.trace(16, 0, 0, 0.0, null);
                    }
                    if (this.currentSortAvoidanceCost.compare(this.bestCost) <= 0.0) {
                        this.rememberBestCost(this.currentSortAvoidanceCost, 2);
                    }
                }
            }
        }
        return bl;
    }

    private void rememberBestCost(CostEstimate costEstimate, int n) throws StandardException {
        this.foundABestPlan = true;
        if (this.optimizerTrace) {
            this.trace(17, 0, 0, 0.0, null);
            this.trace(18, n, 0, 0.0, null);
            this.trace(19, 0, 0, 0.0, null);
        }
        this.bestCost.setCost(costEstimate);
        int n2 = 0;
        while (n2 < this.numOptimizables) {
            this.bestJoinOrder[n2] = this.proposedJoinOrder[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numOptimizables) {
            this.optimizableList.getOptimizable(this.bestJoinOrder[n2]).rememberAsBest(n);
            ++n2;
        }
        if (this.requiredRowOrdering != null) {
            if (n == 2) {
                this.requiredRowOrdering.sortNotNeeded();
            } else {
                this.requiredRowOrdering.sortNeeded();
            }
        }
        if (this.optimizerTrace) {
            if (this.requiredRowOrdering != null) {
                this.trace(20, n, 0, 0.0, null);
            }
            this.trace(21, 0, 0, 0.0, null);
        }
    }

    public void costPermutation() throws StandardException {
        CostEstimate costEstimate = this.joinPosition == 0 ? this.outermostCostEstimate : this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).getBestAccessPath().getCostEstimate();
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        if (!optimizable.feasibleJoinStrategy(this.predicateList, this)) {
            return;
        }
        optimizable.optimizeIt(this, this.predicateList, costEstimate, this.currentRowOrdering);
    }

    public void costOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        if (this.ruleBasedOptimization) {
            this.ruleBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        } else {
            this.costBasedCostOptimizable(optimizable, tableDescriptor, conglomerateDescriptor, optimizablePredicateList, costEstimate);
        }
    }

    private void ruleBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        Object var6_6 = null;
        ConglomerateDescriptor conglomerateDescriptor2 = null;
        AccessPath accessPath = optimizable.getBestAccessPath();
        int n = optimizable.getCurrentAccessPath().getLockMode();
        if (optimizablePredicateList != null && optimizablePredicateList.useful(optimizable, conglomerateDescriptor)) {
            boolean bl = optimizable.isCoveringIndex(conglomerateDescriptor);
            if (!accessPath.getCoveringIndexScan() || accessPath.getNonMatchingIndexScan() || bl) {
                accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
                accessPath.setConglomerateDescriptor(conglomerateDescriptor);
                accessPath.setNonMatchingIndexScan(false);
                accessPath.setCoveringIndexScan(bl);
                accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
                optimizable.rememberJoinStrategyAsBest(accessPath);
            }
            return;
        }
        if (optimizable.isCoveringIndex(conglomerateDescriptor)) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setNonMatchingIndexScan(true);
            accessPath.setCoveringIndexScan(true);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        if (!accessPath.getCoveringIndexScan() && accessPath.getNonMatchingIndexScan() && !conglomerateDescriptor.isIndex()) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            return;
        }
        conglomerateDescriptor2 = accessPath.getConglomerateDescriptor();
        if (conglomerateDescriptor2 == null) {
            accessPath.setCostEstimate(this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable));
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCoveringIndexScan(false);
            accessPath.setNonMatchingIndexScan(conglomerateDescriptor.isIndex());
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
    }

    private void costBasedCostOptimizable(Optimizable optimizable, TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate) throws StandardException {
        CostEstimate costEstimate2 = this.estimateTotalCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, optimizable);
        double d = optimizable.memoryUsage(costEstimate2.rowCount() / costEstimate.rowCount());
        if (d > (double)this.maxMemoryPerTable) {
            if (this.optimizerTrace) {
                this.trace(22, 0, 0, d, null);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate2.compare(costEstimate3) < 0.0) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate2.compare(costEstimate3) < 0.0)) {
            accessPath.setConglomerateDescriptor(conglomerateDescriptor);
            accessPath.setCostEstimate(costEstimate2);
            accessPath.setCoveringIndexScan(optimizable.isCoveringIndex(conglomerateDescriptor));
            accessPath.setNonMatchingIndexScan(optimizablePredicateList == null || !optimizablePredicateList.useful(optimizable, conglomerateDescriptor));
            accessPath.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    public void considerCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, CostEstimate costEstimate2) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(optimizablePredicateList, this)) {
            return;
        }
        double d = optimizable.memoryUsage(costEstimate.rowCount() / costEstimate2.rowCount());
        if (d > (double)this.maxMemoryPerTable) {
            if (this.optimizerTrace) {
                this.trace(22, 0, 0, d, null);
            }
            return;
        }
        AccessPath accessPath = optimizable.getBestAccessPath();
        CostEstimate costEstimate3 = accessPath.getCostEstimate();
        if (costEstimate3 == null || costEstimate.compare(costEstimate3) <= 0.0) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap) == 3 && ((costEstimate3 = (accessPath = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || costEstimate.compare(costEstimate3) < 0.0)) {
            accessPath.setCostEstimate(costEstimate);
            optimizable.rememberJoinStrategyAsBest(accessPath);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    public DataDictionary getDataDictionary() {
        return this.dDictionary;
    }

    public void modifyAccessPaths() throws StandardException {
        if (this.optimizerTrace) {
            this.trace(7, 0, 0, 0.0, null);
        }
        if (!this.foundABestPlan) {
            if (this.optimizerTrace) {
                this.trace(6, 0, 0, 0.0, null);
            }
            throw StandardException.newException("42Y69");
        }
        this.optimizableList.reOrder(this.bestJoinOrder);
        JBitSet jBitSet = new JBitSet(this.numOptimizables);
        int n = 0;
        while (n < this.numOptimizables) {
            Optimizable optimizable = this.optimizableList.getOptimizable(n);
            jBitSet.or(optimizable.getReferencedTableMap());
            this.pushPredicates(optimizable, jBitSet);
            this.optimizableList.setOptimizable(n, optimizable.modifyAccessPath(jBitSet));
            ++n;
        }
    }

    public CostEstimate newCostEstimate() {
        return new CostEstimateImpl();
    }

    public CostEstimate getOptimizedCost() {
        return this.bestCost;
    }

    public void setOuterRows(double d) {
        this.outermostCostEstimate.setCost(this.outermostCostEstimate.getEstimatedCost(), d, this.outermostCostEstimate.singleScanRowCount());
    }

    public int tableLockThreshold() {
        return this.tableLockThreshold;
    }

    public int getNumberOfJoinStrategies() {
        return this.joinStrategies.length;
    }

    public JoinStrategy getJoinStrategy(int n) {
        return this.joinStrategies[n];
    }

    public JoinStrategy getJoinStrategy(String string) {
        JoinStrategy joinStrategy = null;
        String string2 = StringUtil.SQLToUpperCase(string);
        int n = 0;
        while (n < this.joinStrategies.length) {
            if (string2.equals(this.joinStrategies[n].getName())) {
                joinStrategy = this.joinStrategies[n];
            }
            ++n;
        }
        return joinStrategy;
    }

    public double uniqueJoinWithOuterTable(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d = -1.0;
        double d2 = 1.0;
        double d3 = this.currentCost.rowCount();
        if (optimizablePredicateList != null) {
            int n = this.joinPosition - 1;
            while (n >= 0) {
                Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[n]);
                double d4 = optimizable.uniqueJoin(optimizablePredicateList);
                if (d4 > 0.0) {
                    d2 *= optimizable.uniqueJoin(optimizablePredicateList);
                }
                --n;
            }
        }
        if (d2 != 1.0) {
            d = d2 / d3;
        }
        return d;
    }

    private boolean isPushable(OptimizablePredicate optimizablePredicate) {
        return !optimizablePredicate.hasSubquery();
    }

    private CostEstimate estimateTotalCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizable optimizable) throws StandardException {
        CostEstimate costEstimate2 = optimizable.estimateCost(optimizablePredicateList, conglomerateDescriptor, costEstimate, this, this.currentRowOrdering);
        return costEstimate2;
    }

    public int getLevel() {
        return 1;
    }

    public CostEstimateImpl getNewCostEstimate(double d, double d2, double d3) {
        return new CostEstimateImpl(d, d2, d3);
    }

    public void trace(int n, int n2, int n3, double d, Object object) {
    }

    public boolean useStatistics() {
        return this.useStatistics && this.optimizableList.useStatistics();
    }

    protected OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, boolean bl, boolean bl2, boolean bl3, int n, JoinStrategy[] joinStrategyArray, int n2, RequiredRowOrdering requiredRowOrdering, int n3) throws StandardException {
        this.outermostCostEstimate = this.getNewCostEstimate(0.0, 1.0, 1.0);
        this.currentCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        optimizableList.verifyProperties(dataDictionary);
        this.numTablesInQuery = n3;
        this.numOptimizables = optimizableList.size();
        this.proposedJoinOrder = new int[this.numOptimizables];
        if (n3 > 6) {
            this.permuteState = 1;
            this.firstLookOrder = new int[this.numOptimizables];
        } else {
            this.permuteState = 0;
        }
        int n4 = 0;
        while (n4 < this.numOptimizables) {
            this.proposedJoinOrder[n4] = -1;
            ++n4;
        }
        this.bestJoinOrder = new int[this.numOptimizables];
        this.joinPosition = -1;
        this.optimizableList = optimizableList;
        this.predicateList = optimizablePredicateList;
        this.dDictionary = dataDictionary;
        this.ruleBasedOptimization = bl;
        this.noTimeout = bl2;
        this.maxMemoryPerTable = n;
        this.joinStrategies = joinStrategyArray;
        this.tableLockThreshold = n2;
        this.requiredRowOrdering = requiredRowOrdering;
        this.useStatistics = bl3;
        this.assignedTableMap = new JBitSet(n3);
        this.nonCorrelatedTableMap = new JBitSet(n3);
        n4 = 0;
        while (n4 < this.numOptimizables) {
            Optimizable optimizable = optimizableList.getOptimizable(n4);
            this.nonCorrelatedTableMap.or(optimizable.getReferencedTableMap());
            ++n4;
        }
        this.timeOptimizationStarted = System.currentTimeMillis();
    }
}

