/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class LikeEscapeOperatorNode
extends TernaryOperatorNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2001, 2004.";
    boolean addedEquals;
    String escape;

    public void init(Object object, Object object2, Object object3) {
        super.init(object, object2, object3, ReuseFactory.getInteger(3), null);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object;
        boolean bl;
        boolean bl2;
        super.bindExpression(fromList, subqueryList, vector);
        String string = null;
        if (this.leftOperand instanceof ColumnReference) {
            throw StandardException.newException("42824");
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.isParameterNode()) {
            throw StandardException.newException("42884", "LIKE", (Object)"FUNCTION");
        }
        if (this.rightOperand != null && this.rightOperand instanceof ColumnReference) {
            throw StandardException.newException("22019", ((ColumnReference)this.rightOperand).getColumnName());
        }
        if (this.rightOperand != null && !(this.rightOperand instanceof CharConstantNode) && !this.rightOperand.isParameterNode()) {
            throw StandardException.newException("42884", "LIKE", (Object)"FUNCTION");
        }
        if (this.receiver.isParameterNode()) {
            ((ParameterNode)this.receiver).setDescriptor(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
        }
        if (this.leftOperand.isParameterNode()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                ((ParameterNode)this.leftOperand).setDescriptor(this.receiver.getTypeServices());
            } else {
                ((ParameterNode)this.leftOperand).setDescriptor(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
        }
        if (this.rightOperand != null && this.rightOperand.isParameterNode()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                ((ParameterNode)this.rightOperand).setDescriptor(this.receiver.getTypeServices());
            } else {
                ((ParameterNode)this.rightOperand).setDescriptor(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
        }
        this.bindToBuiltIn();
        TypeCompiler typeCompiler = this.receiver.getTypeCompiler();
        TypeCompiler typeCompiler2 = this.leftOperand.getTypeCompiler();
        if (!this.receiver.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", "LIKE", (Object)"FUNCTION");
        }
        if (!this.leftOperand.getTypeId().isStringTypeId()) {
            this.leftOperand = this.castArgToString(this.leftOperand);
            typeCompiler2 = this.leftOperand.getTypeCompiler();
        }
        if (this.rightOperand != null) {
            this.rightOperand = this.castArgToString(this.rightOperand);
        }
        if (bl2 = this.leftOperand instanceof CharConstantNode) {
            string = ((CharConstantNode)this.leftOperand).getString();
        }
        if (bl = this.rightOperand instanceof CharConstantNode) {
            this.escape = ((CharConstantNode)this.rightOperand).getString();
            if (this.escape.length() != 1) {
                throw StandardException.newException("22019", this.escape);
            }
        } else if (this.rightOperand == null) {
            bl = true;
        }
        if (this.receiver instanceof ColumnReference && bl2 && bl && Like.isOptimizable(string)) {
            object = null;
            if (this.escape != null) {
                object = Like.stripEscapesNoPatternChars(string, this.escape.charAt(0));
            } else if (string.indexOf(95) == -1 && string.indexOf(37) == -1) {
                object = string;
            }
            if (object != null) {
                AndNode andNode = null;
                BinaryComparisonOperatorNode binaryComparisonOperatorNode = null;
                ValueNode valueNode = this.receiver.getClone();
                this.addedEquals = true;
                binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, valueNode, (ValueNode)this.getNodeFactory().getNode(61, object, this.getContextManager()), this.getContextManager());
                binaryComparisonOperatorNode.setForQueryRewrite(true);
                binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)binaryComparisonOperatorNode.bindExpression(fromList, subqueryList, vector);
                andNode = (AndNode)this.getNodeFactory().getNode(39, this, binaryComparisonOperatorNode, this.getContextManager());
                this.finishBindExpr();
                andNode.postBindFixup();
                return andNode;
            }
        }
        object = this.leftOperand.getTypeId();
        TypeId typeId = this.receiver.getTypeId();
        if (typeId.isNationalStringTypeId() && !((TypeId)object).isNationalStringTypeId()) {
            this.receiver = this.castArgToNationalString(this.receiver, typeCompiler, typeId);
        } else if (((TypeId)object).isNationalStringTypeId() && !typeId.isNationalStringTypeId()) {
            this.leftOperand = this.castArgToNationalString(this.leftOperand, typeCompiler2, (TypeId)object);
        }
        this.finishBindExpr();
        return this;
    }

    private ValueNode castArgToNationalString(ValueNode valueNode, TypeCompiler typeCompiler, TypeId typeId) throws StandardException {
        ValueNode valueNode2 = (ValueNode)this.getNodeFactory().getNode(60, valueNode, new DataTypeDescriptor(typeId, true, typeCompiler.getCastToCharWidth(valueNode.getTypeServices())), this.getContextManager());
        ((CastNode)valueNode2).bindCastNodeOnly();
        return valueNode2;
    }

    private void finishBindExpr() throws StandardException {
        boolean bl;
        this.bindComparisonOperator();
        boolean bl2 = bl = this.receiver.getTypeServices().isNullable() || this.leftOperand.getTypeServices().isNullable();
        if (this.rightOperand != null) {
            bl |= this.rightOperand.getTypeServices().isNullable();
        }
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId typeId = this.receiver.getTypeId();
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (!typeId.isStringTypeId()) {
            throw StandardException.newException("42X53", typeId.getSQLTypeName());
        }
        if (!typeId2.isStringTypeId()) {
            throw StandardException.newException("42X53", typeId2.getSQLTypeName());
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42X53", this.rightOperand.getTypeId().getSQLTypeName());
        }
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        BinaryComparisonOperatorNode binaryComparisonOperatorNode;
        QueryTreeNode queryTreeNode;
        boolean bl = false;
        String string = null;
        String string2 = null;
        super.preprocess(n, fromList, subqueryList, predicateList);
        if (this.receiver.getTypeId().getSQLTypeName().equals("CLOB")) {
            return this;
        }
        if (this.addedEquals) {
            return this;
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.isParameterNode()) {
            return this;
        }
        if (!(this.receiver instanceof ColumnReference)) {
            return this;
        }
        if (this.leftOperand instanceof CharConstantNode) {
            String string3 = ((CharConstantNode)this.leftOperand).getString();
            if (!Like.isOptimizable(string3)) {
                return this;
            }
            string = Like.greaterEqualString(string3, this.escape);
            if (!this.receiver.getTypeId().isNationalStringTypeId()) {
                string2 = Like.lessThanString(string);
                bl = !Like.isLikeComparisonNeeded(string3);
            }
        }
        AndNode andNode = null;
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        if (string2 != null || this.leftOperand.isParameterNode() && !this.receiver.getTypeId().isNationalStringTypeId()) {
            queryTreeNode = this.leftOperand.isParameterNode() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "lessThanStringFromParameter") : this.getNodeFactory().getNode(61, string2, this.getContextManager());
            binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(45, this.receiver.getClone(), queryTreeNode, this.getContextManager());
            binaryComparisonOperatorNode.setForQueryRewrite(true);
            binaryComparisonOperatorNode.bindComparisonOperator();
            binaryComparisonOperatorNode.setBetweenSelectivity();
            andNode = (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, valueNode, this.getContextManager());
            andNode.postBindFixup();
        }
        queryTreeNode = this.leftOperand.isParameterNode() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "greaterEqualStringFromParameter") : (ValueNode)this.getNodeFactory().getNode(61, string, this.getContextManager());
        binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(42, this.receiver.getClone(), queryTreeNode, this.getContextManager());
        binaryComparisonOperatorNode.setForQueryRewrite(true);
        binaryComparisonOperatorNode.bindComparisonOperator();
        binaryComparisonOperatorNode.setBetweenSelectivity();
        andNode = andNode == null ? (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, valueNode, this.getContextManager()) : (AndNode)this.getNodeFactory().getNode(39, binaryComparisonOperatorNode, andNode, this.getContextManager());
        andNode.postBindFixup();
        if (!bl) {
            andNode = (AndNode)this.getNodeFactory().getNode(39, this, andNode, this.getContextManager());
            andNode.postBindFixup();
        }
        this.setTransformed();
        return andNode;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.receiver.generateExpression(expressionClassBuilder, methodBuilder);
        this.receiverInterfaceType = this.receiver.getTypeCompiler().interfaceName();
        methodBuilder.upCast(this.receiverInterfaceType);
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast(this.leftInterfaceType);
        if (this.rightOperand != null) {
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.rightInterfaceType);
        }
        methodBuilder.callMethod((short)185, null, this.methodName, this.resultInterfaceType, this.rightOperand == null ? 1 : 2);
    }

    private ValueNode setupOptimizeStringFromParameter(ValueNode valueNode, ValueNode valueNode2, String string) throws StandardException {
        Vector<ValueNode> vector;
        if (valueNode2 != null) {
            vector = new Vector<ValueNode>(2);
            string = string + "WithEsc";
        } else {
            vector = new Vector(1);
        }
        StaticMethodCallNode staticMethodCallNode = (StaticMethodCallNode)this.getNodeFactory().getNode(85, string, "org.apache.derby.iapi.types.Like", this.getContextManager());
        staticMethodCallNode.internalCall = true;
        vector.addElement(valueNode);
        if (valueNode2 != null) {
            vector.addElement(valueNode2);
        }
        staticMethodCallNode.addParms(vector);
        ValueNode valueNode3 = (ValueNode)this.getNodeFactory().getNode(36, staticMethodCallNode, this.getContextManager());
        valueNode3 = valueNode3.bindExpression(null, null, null);
        CastNode castNode = (CastNode)this.getNodeFactory().getNode(60, valueNode3, valueNode.getTypeServices(), this.getContextManager());
        castNode.bindCastNodeOnly();
        return castNode;
    }
}

