/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.xact.Xact;

public class XactContext
extends ContextImpl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private RawTransaction xact;
    private RawStoreFactory factory;
    private boolean abortAll;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupOnError(Throwable throwable) throws StandardException {
        boolean bl;
        block12: {
            block11: {
                bl = false;
                if (!(throwable instanceof StandardException)) break block11;
                StandardException standardException = (StandardException)throwable;
                if (this.abortAll) {
                    if (standardException.getSeverity() < 30000) {
                        throw StandardException.newException("40XT5", throwable);
                    }
                    bl = true;
                    break block12;
                } else {
                    if (standardException.getSeverity() < 30000) {
                        return;
                    }
                    if (standardException.getSeverity() >= 40000) {
                        bl = true;
                    }
                }
                break block12;
            }
            bl = true;
        }
        try {
            block10: {
                try {
                    if (this.xact == null) break block10;
                    this.xact.abort();
                }
                catch (StandardException standardException) {
                    bl = true;
                    if (standardException.getSeverity() <= 40000 && standardException.getSeverity() >= ((StandardException)throwable).getSeverity()) {
                        throw this.factory.markCorrupt(StandardException.newException("XSTB0.M", standardException));
                    }
                    Object var4_6 = null;
                    if (!bl) return;
                    this.xact.close();
                    this.xact = null;
                    return;
                }
            }
            Object var4_5 = null;
            if (!bl) return;
            this.xact.close();
            this.xact = null;
            return;
        }
        catch (Throwable throwable2) {
            Object var4_7 = null;
            if (!bl) throw throwable2;
            this.xact.close();
            this.xact = null;
            throw throwable2;
        }
    }

    public RawTransaction getTransaction() {
        return this.xact;
    }

    protected RawStoreFactory getFactory() {
        return this.factory;
    }

    public void substituteTransaction(Xact xact) {
        Xact xact2 = (Xact)this.xact;
        if (xact2.xc == this) {
            xact2.xc = null;
        }
        this.xact = xact;
        ((Xact)this.xact).xc = this;
    }

    public XactContext(ContextManager contextManager, String string, Xact xact, boolean bl, RawStoreFactory rawStoreFactory) {
        super(contextManager, string);
        this.xact = xact;
        this.abortAll = bl;
        this.factory = rawStoreFactory;
        xact.xc = this;
    }
}

