/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.Scan;

public abstract class SortScan
extends Scan {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected MergeSort sort = null;
    protected TransactionManager tran = null;
    protected DataValueDescriptor[] current;
    protected boolean hold;

    public final boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = this.next();
        if (bl) {
            this.fetch(dataValueDescriptorArray);
        }
        return bl;
    }

    public final void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.current == null) {
            throw StandardException.newException("XSAS1.S");
        }
        this.sort.checkColumnTypes(dataValueDescriptorArray);
        System.arraycopy(this.current, 0, dataValueDescriptorArray, 0, dataValueDescriptorArray.length);
    }

    public void close() {
        this.sort = null;
        this.current = null;
        this.tran.closeMe(this);
    }

    public abstract boolean closeForEndTransaction(boolean var1) throws StandardException;

    public abstract boolean next() throws StandardException;

    SortScan(MergeSort mergeSort, TransactionManager transactionManager, boolean bl) {
        this.sort = mergeSort;
        this.tran = transactionManager;
        this.hold = bl;
    }
}

