/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DropStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableName;

public class DropAliasNode
extends DropStatementNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private char aliasType;
    private char nameSpace;

    public void init(Object object, Object object2) throws StandardException {
        TableName tableName = (TableName)object;
        this.initAndCheck(tableName);
        this.aliasType = ((Character)object2).charValue();
        switch (this.aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType));
    }

    public QueryTreeNode bind() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.getRelativeName();
        AliasDescriptor aliasDescriptor = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string, this.nameSpace);
        }
        if (aliasDescriptor == null) {
            throw StandardException.newException("42Y55", this.statementToString(), (Object)string);
        }
        if (aliasDescriptor.getSystemAlias()) {
            throw StandardException.newException("42Y71", string);
        }
        return this;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.nameSpace);
    }

    private static String aliasTypeName(char c) {
        String string = null;
        switch (c) {
            case 'P': {
                string = "PROCEDURE";
                break;
            }
            case 'F': {
                string = "FUNCTION";
                break;
            }
        }
        return string;
    }
}

