/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectLoaderJava2;

public final class ReflectClassesJava2
extends DatabaseClasses
implements PrivilegedAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private HashMap preCompiled;
    private int action;

    protected synchronized LoadedGeneratedClass loadGeneratedClassFromData(String string, ByteArray byteArray) {
        if (byteArray == null || byteArray.getArray() == null) {
            Object object;
            if (this.preCompiled == null) {
                this.preCompiled = new HashMap();
            } else {
                object = (ReflectGeneratedClass)this.preCompiled.get(string);
                if (object != null) {
                    return object;
                }
            }
            try {
                object = Class.forName(string);
                ReflectGeneratedClass reflectGeneratedClass = new ReflectGeneratedClass(this, (Class)object, null);
                this.preCompiled.put(string, reflectGeneratedClass);
                return reflectGeneratedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.toString());
            }
        }
        this.action = 1;
        return ((ReflectLoaderJava2)AccessController.doPrivileged(this)).loadGeneratedClass(string, byteArray);
    }

    public Object run() {
        switch (this.action) {
            case 1: {
                return new ReflectLoaderJava2(this.getClass().getClassLoader(), this);
            }
            case 2: {
                return Thread.currentThread().getContextClassLoader();
            }
        }
        return null;
    }

    protected synchronized Class loadClassNotInDatabaseJar(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        this.action = 2;
        try {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(this);
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(string);
        }
        return clazz;
    }
}

