/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.loader.ClassFactory;

class ApplicationObjectInputStream
extends ObjectInputStream
implements ErrorObjectInput {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    protected ClassFactory cf;
    protected ObjectStreamClass initialClass;

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (this.initialClass == null) {
            this.initialClass = objectStreamClass;
        }
        if (this.cf != null) {
            return this.cf.loadApplicationClass(objectStreamClass);
        }
        throw new ClassNotFoundException(objectStreamClass.getName());
    }

    public String getErrorInfo() {
        if (this.initialClass == null) {
            return "";
        }
        return this.initialClass.getName() + " (serialVersionUID=" + this.initialClass.getSerialVersionUID() + ")";
    }

    public Exception getNestedException() {
        return null;
    }

    ApplicationObjectInputStream(InputStream inputStream, ClassFactory classFactory) throws IOException {
        super(inputStream);
        this.cf = classFactory;
    }
}

