/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexRow;

public abstract class GenericRIChecker {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    protected FKInfo fkInfo;
    protected DynamicCompiledOpenConglomInfo[] fkDcocis;
    protected StaticCompiledOpenConglomInfo[] fkScocis;
    protected DynamicCompiledOpenConglomInfo refDcoci;
    protected StaticCompiledOpenConglomInfo refScoci;
    protected TransactionController tc;
    private Hashtable scanControllers;
    private int numColumns;
    private IndexRow indexQualifierRow;

    abstract void doCheck(ExecRow var1, boolean var2) throws StandardException;

    public void doCheck(ExecRow execRow) throws StandardException {
        this.doCheck(execRow, false);
    }

    protected ScanController getScanController(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo, ExecRow execRow) throws StandardException {
        int n = this.getRICheckIsolationLevel();
        Long l2 = new Long(l);
        ScanController scanController = (ScanController)this.scanControllers.get(l2);
        if (scanController == null) {
            this.setupQualifierRow(execRow);
            scanController = this.tc.openCompiledScan(false, 0, 6, n, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
            this.scanControllers.put(l2, scanController);
        } else {
            this.setupQualifierRow(execRow);
            scanController.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1);
        }
        return scanController;
    }

    private void setupQualifierRow(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        int n = 0;
        while (n < this.numColumns) {
            dataValueDescriptorArray[n] = dataValueDescriptorArray2[this.fkInfo.colArray[n] - 1];
            ++n;
        }
    }

    boolean isAnyFieldNull(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        int n = 0;
        while (n < this.numColumns) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[this.fkInfo.colArray[n] - 1];
            if (dataValueDescriptor.isNull()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void close() throws StandardException {
        Enumeration enumeration = this.scanControllers.elements();
        while (enumeration.hasMoreElements()) {
            ScanController scanController = (ScanController)enumeration.nextElement();
            scanController.close();
        }
        this.scanControllers.clear();
    }

    int getRICheckIsolationLevel() {
        return 3;
    }

    GenericRIChecker(TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        this.fkInfo = fKInfo;
        this.tc = transactionController;
        this.scanControllers = new Hashtable();
        this.numColumns = this.fkInfo.colArray.length;
        this.indexQualifierRow = new IndexRow(this.numColumns);
        this.fkDcocis = new DynamicCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        this.fkScocis = new StaticCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        int n = 0;
        while (n < this.fkInfo.fkConglomNumbers.length) {
            this.fkDcocis[n] = transactionController.getDynamicCompiledConglomInfo(this.fkInfo.fkConglomNumbers[n]);
            this.fkScocis[n] = transactionController.getStaticCompiledConglomInfo(this.fkInfo.fkConglomNumbers[n]);
            ++n;
        }
        this.refDcoci = transactionController.getDynamicCompiledConglomInfo(this.fkInfo.refConglomNumber);
        this.refScoci = transactionController.getStaticCompiledConglomInfo(this.fkInfo.refConglomNumber);
    }
}

