/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigDecimal MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(ONE);
    public static final BigDecimal MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(ONE);
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$Lorg$apache$derby$iapi$types$SQLDecimal != null ? class$Lorg$apache$derby$iapi$types$SQLDecimal : (class$Lorg$apache$derby$iapi$types$SQLDecimal = SQLDecimal.class$("org.apache.derby.iapi.types.SQLDecimal")));
    private static final int BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = SQLDecimal.class$("java.math.BigDecimal")));
    private BigDecimal value;
    private byte[] rawData;
    private int rawScale;
    private static /* synthetic */ Class class$Lorg$apache$derby$iapi$types$SQLDecimal;
    private static /* synthetic */ Class class$Ljava$math$BigDecimal;

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (this.value != null) {
            n += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (this.rawData != null) {
            n += this.rawData.length;
        }
        return n;
    }

    public int getInt() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    public byte getByte() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -128L && l <= 127L) {
                return (byte)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    public short getShort() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -32768L && l <= 32767L) {
                return (short)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    public long getLong() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0L;
        }
        if (bigDecimal.compareTo(MINLONG_MINUS_ONE) == 1 && bigDecimal.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return bigDecimal.longValue();
        }
        throw StandardException.newException("22003", "BIGINT");
    }

    public float getFloat() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0f;
        }
        float f = NumberDataType.normalizeREAL(bigDecimal.floatValue());
        return f;
    }

    public double getDouble() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0;
        }
        double d = NumberDataType.normalizeDOUBLE(bigDecimal.doubleValue());
        return d;
    }

    public BigDecimal getBigDecimal() {
        if (this.value == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger(this.rawData), this.rawScale);
        }
        return this.value;
    }

    public boolean getBoolean() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(ZERO) != 0;
    }

    public String getString() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.toString();
    }

    public Object getObject() {
        return this.getBigDecimal();
    }

    public void setValue(Object object) throws StandardException {
        this.rawData = null;
        if (object instanceof BigDecimal || object == null) {
            this.setValue((BigDecimal)object);
        } else if (object instanceof Number) {
            this.value = new BigDecimal(((Number)object).doubleValue());
        } else {
            this.genericSetObject(object);
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getBigDecimal());
    }

    public int getLength() {
        return this.getPrecision();
    }

    public String getTypeName() {
        return "DECIMAL";
    }

    public int getTypeFormatId() {
        return 200;
    }

    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        int n;
        if (this.value != null) {
            n = this.value.scale();
            BigInteger bigInteger = this.value.movePointRight(n).toBigInteger();
            byArray = bigInteger.toByteArray();
        } else {
            n = this.rawScale;
            byArray = this.rawData;
        }
        objectOutput.writeByte(n);
        objectOutput.writeByte(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = null;
        this.rawScale = objectInput.readUnsignedByte();
        int n = objectInput.readUnsignedByte();
        if (this.rawData == null || n != this.rawData.length) {
            this.rawData = new byte[n];
            objectInput.readFully(this.rawData);
        } else {
            int n2 = this.rawData.length - n;
            int n3 = 0;
            while (n3 < n2) {
                this.rawData[n3] = 0;
                ++n3;
            }
            objectInput.readFully(this.rawData, n2, n);
        }
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = null;
        this.rawScale = arrayInputStream.readUnsignedByte();
        int n = arrayInputStream.readUnsignedByte();
        if (this.rawData == null || n != this.rawData.length) {
            this.rawData = new byte[n];
            arrayInputStream.readFully(this.rawData);
        } else {
            int n2 = this.rawData.length - n;
            int n3 = 0;
            while (n3 < n2) {
                this.rawData[n3] = 0;
                ++n3;
            }
            arrayInputStream.readFully(this.rawData, n2, n);
        }
    }

    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        BigDecimal bigDecimal = dataValueDescriptor.getBigDecimal();
        return this.getBigDecimal().compareTo(bigDecimal);
    }

    public DataValueDescriptor getClone() {
        return new SQLDecimal(this.getBigDecimal());
    }

    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.value = resultSet.getBigDecimal(n, resultSetMetaData.getScale(n));
        this.rawData = null;
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 3);
            return;
        }
        preparedStatement.setBigDecimal(n, this.getBigDecimal());
    }

    public void setValue(String string) throws StandardException {
        this.rawData = null;
        if (string == null) {
            this.value = null;
        } else {
            try {
                string = string.trim();
                this.value = new BigDecimal(string);
                this.rawData = null;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
        }
    }

    public void setValue(double d) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(d));
    }

    public void setValue(float f) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(f));
    }

    public void setValue(long l) {
        this.value = BigDecimal.valueOf(l);
        this.rawData = null;
    }

    public void setValue(int n) {
        this.setValue((long)n);
    }

    public void setValue(short s) {
        this.setValue((long)s);
    }

    public void setValue(byte by) {
        this.setValue((long)by);
    }

    public void setValue(BigDecimal bigDecimal) {
        this.setCoreValue(bigDecimal);
    }

    public void setValue(boolean bl) {
        this.setCoreValue(bl ? ONE : ZERO);
    }

    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.rawData = null;
    }

    private void setCoreValue(double d) {
        this.value = new BigDecimal(d);
        this.rawData = null;
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getScale();
        int n2 = dataTypeDescriptor.getPrecision();
        this.setValue(dataValueDescriptor.getBigDecimal());
        this.setWidth(n2, n, true);
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setValue(numberDataValue.getBigDecimal().add(numberDataValue2.getBigDecimal()));
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setValue(numberDataValue.getBigDecimal().subtract(numberDataValue2.getBigDecimal()));
        return numberDataValue3;
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setValue(numberDataValue.getBigDecimal().multiply(numberDataValue2.getBigDecimal()));
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3, -1);
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        BigDecimal bigDecimal = numberDataValue2.getBigDecimal();
        if (bigDecimal.compareTo(ZERO) == 0) {
            throw StandardException.newException("22012");
        }
        BigDecimal bigDecimal2 = numberDataValue.getBigDecimal();
        numberDataValue3.setValue(bigDecimal2.divide(bigDecimal, n > -1 ? n : Math.max(bigDecimal2.scale() + SQLDecimal.getWholeDigits(bigDecimal) + 1, 4), 1));
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLDecimal();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getBigDecimal().negate());
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getBigDecimal().toString();
    }

    public int hashCode() {
        long l;
        double d;
        BigDecimal bigDecimal = this.getBigDecimal();
        double d2 = d = bigDecimal != null ? bigDecimal.doubleValue() : 0.0;
        if (Double.isInfinite(d)) {
            l = bigDecimal.longValue();
        } else {
            l = (long)d;
            if ((double)l != d) {
                l = Double.doubleToLongBits(d);
            }
        }
        return (int)(l ^ l >> 32);
    }

    public DataValueDescriptor setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.isNull()) {
            return this;
        }
        if (n != -1 && n - n2 < this.getWholeDigits()) {
            throw StandardException.newException("22003", "DECIMAL/NUMERIC(" + n + "," + n2 + ")");
        }
        this.value = this.value.setScale(n2, 1);
        this.rawData = null;
        return this;
    }

    public int getPrecision() {
        return SQLDecimal.getPrecision(this.getBigDecimal());
    }

    public static int getPrecision(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.equals(ZERO)) {
            return 0;
        }
        return SQLDecimal.getWholeDigits(bigDecimal) + bigDecimal.scale();
    }

    public int getScale() {
        BigDecimal bigDecimal = this.getBigDecimal();
        return bigDecimal == null ? 0 : bigDecimal.scale();
    }

    public int getWholeDigits() {
        return SQLDecimal.getWholeDigits(this.getBigDecimal());
    }

    public static int getWholeDigits(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.equals(ZERO)) {
            return 0;
        }
        String string = bigDecimal.abs().toString();
        int n = bigDecimal.scale();
        return n == 0 ? string.length() : string.indexOf(46) - (string.startsWith("0.") ? 1 : 0);
    }

    public BigDecimal getValue() {
        return this.getBigDecimal();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public SQLDecimal(BigDecimal bigDecimal, int n, int n2) throws StandardException {
        this.value = bigDecimal;
        if (this.value != null && n2 >= 0) {
            this.value = this.value.setScale(n2, 1);
        }
    }

    public SQLDecimal(String string) {
        this.value = new BigDecimal(string);
    }
}

