/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    public static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    public static DataValueDescriptor getColumn(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < dataValueDescriptorArray.length ? dataValueDescriptorArray[n] : null;
    }

    public static Object getColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            return n < objectArray.length ? objectArray[n] : null;
        }
        if (formatableBitSet.getLength() <= n || !formatableBitSet.isSet(n)) {
            return null;
        }
        return n < objectArray.length ? objectArray[n] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifierArray) {
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        if (qualifierArray != null) {
            int n = 0;
            while (n < qualifierArray.length) {
                int n2 = 0;
                while (n2 < qualifierArray[n].length) {
                    int n3 = qualifierArray[n][n2].getColumnId();
                    formatableBitSet.grow(n3 + 1);
                    formatableBitSet.set(n3);
                    ++n2;
                }
                ++n;
            }
        }
        return formatableBitSet;
    }

    public static int getNumberOfColumns(int n, FormatableBitSet formatableBitSet) {
        int n2 = formatableBitSet.getLength();
        if (n > 0 && n < n2) {
            n2 = n;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (formatableBitSet.isSet(n4)) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) {
        if (dataValueDescriptorArray == null) {
            return true;
        }
        if (dataValueDescriptorArray.length == 0) {
            return true;
        }
        if (formatableBitSet == null) {
            return false;
        }
        int n = formatableBitSet.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (formatableBitSet.isSet(n2)) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public static int columnOutOfRange(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet == null) {
            if (dataValueDescriptorArray.length > n) {
                return n;
            }
            return -1;
        }
        int n2 = formatableBitSet.getLength();
        int n3 = n;
        while (n3 < n2) {
            if (formatableBitSet.isSet(n3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int nextColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n) {
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.getLength();
            while (n < n2) {
                if (formatableBitSet.isSet(n)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (objectArray == null) {
            return -1;
        }
        return n < objectArray.length ? n : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int n) {
        if (n < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[n];
        }
        return new FetchDescriptor(n, n);
    }

    public static InstanceGetter[] newClassInfoTemplate(FormatableBitSet formatableBitSet, int[] nArray) throws StandardException {
        int n = nArray.length;
        InstanceGetter[] instanceGetterArray = new InstanceGetter[n];
        int n2 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        int n3 = 0;
        while (n3 < n) {
            if (formatableBitSet == null || n2 > n3 && formatableBitSet.isSet(n3)) {
                instanceGetterArray[n3] = Monitor.classFromIdentifier(nArray[n3]);
            }
            ++n3;
        }
        return instanceGetterArray;
    }

    private static void newRowFromClassInfoTemplateError() {
    }

    public static DataValueDescriptor[] newRowFromClassInfoTemplate(InstanceGetter[] instanceGetterArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[instanceGetterArray.length];
        try {
            int n = instanceGetterArray.length;
            while (n-- > 0) {
                if (instanceGetterArray[n] == null) continue;
                dataValueDescriptorArray[n] = (DataValueDescriptor)instanceGetterArray[n].getNewInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        catch (IllegalAccessException illegalAccessException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        catch (InvocationTargetException invocationTargetException) {
            RowUtil.newRowFromClassInfoTemplateError();
        }
        return dataValueDescriptorArray;
    }

    public static String toString(Object[] objectArray) {
        return null;
    }

    public static String toString(Hashtable hashtable) {
        return null;
    }

    public static final boolean qualifyRow(Object[] objectArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        boolean bl = true;
        int n = 0;
        while (n < qualifierArray[0].length) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n];
            object = (DataValueDescriptor)objectArray[qualifier.getColumnId()];
            bl = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        n = 1;
        while (n < qualifierArray.length) {
            bl = false;
            int n2 = 0;
            while (n2 < qualifierArray[n].length) {
                object = qualifierArray[n][n2];
                int n3 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray[object.getColumnId()];
                bl = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
                ++n2;
            }
            if (!bl) break;
            ++n;
        }
        return bl;
    }

    private RowUtil() {
    }
}

